package eu.dnetlib.data.information.oai.publisher.conf;

import javax.annotation.Resource;

import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import eu.dnetlib.data.information.oai.publisher.OaiPublisherRuntimeException;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpDocumentNotFoundException;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpException;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpService;
import eu.dnetlib.enabling.tools.ServiceLocator;
import eu.dnetlib.miscutils.functional.IdentityFunction;
import eu.dnetlib.miscutils.functional.UnaryFunction;
import eu.dnetlib.miscutils.functional.xml.ApplyXslt;

/**
 * Helper class for common queries to the IS.
 * 
 * @author alessia
 * 
 */
public class ISLookUpClient {

	/**
	 * lookup service.
	 */
	@Resource(name = "lookupLocator")
	private ServiceLocator<ISLookUpService> lookupLocator;

	private static final Log log = LogFactory.getLog(ISLookUpClient.class); // NOPMD by marko on 11/24/08 5:02 PM

	public UnaryFunction<String, String> getUnaryFunctionFromTDSRule(final String tdsRuleId) {
		final String queryCodeRule = "//RESOURCE_PROFILE[.//RESOURCE_IDENTIFIER/@value='" + tdsRuleId
				+ "']/BODY/CONFIGURATION/SCRIPT/CODE/*[local-name()='stylesheet']";
		String xsltCode = null;
		try {
			xsltCode = this.lookupLocator.getService().getResourceProfileByQuery(queryCodeRule);
		} catch (ISLookUpDocumentNotFoundException e) {
			log.fatal("Unexisting TDSRule profile with identifier " + tdsRuleId);
			throw new OaiPublisherRuntimeException(e);
		} catch (ISLookUpException e) {
			throw new OaiPublisherRuntimeException(e);
		}
		if (StringUtils.isBlank(xsltCode)) {
			log.warn("Unexpected blank stylesheet in TDSRule profile with id: " + tdsRuleId + ". Returning identity function.");
			return new IdentityFunction<String>();
		} else return new ApplyXslt(xsltCode);
	}

	public ServiceLocator<ISLookUpService> getLookupLocator() {
		return lookupLocator;
	}

	public void setLookupLocator(final ServiceLocator<ISLookUpService> lookupLocator) {
		this.lookupLocator = lookupLocator;
	}

}
