/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.information.oai.publisher.wf;

import com.googlecode.sarasvati.Engine;
import com.googlecode.sarasvati.NodeToken;
import eu.dnetlib.data.information.DataSourceResolver;
import eu.dnetlib.data.information.MDStoreDataSinkSourceDescriptorGenerator;
import eu.dnetlib.data.information.oai.publisher.store.MongoPublisherStore;
import eu.dnetlib.data.information.oai.publisher.store.MongoPublisherStoreDAO;
import eu.dnetlib.enabling.resultset.client.IterableResultSetClient;
import eu.dnetlib.enabling.resultset.client.ResultSetClientFactory;
import eu.dnetlib.workflow.AbstractJobNode;
import javax.annotation.Resource;

public class UpdatePublisherStoreJob
extends AbstractJobNode {
    private String mdstoreIDAttributeName = "mdId";
    private String pubstoreIDAttributeName = "pubstoreId";
    private String repositoryIDAttributeName = "repositoryId";
    @Resource
    private MongoPublisherStoreDAO publisherStoreDAO;
    @Resource(name="msroSourceSinkGenerator")
    private MDStoreDataSinkSourceDescriptorGenerator sourceDescriptionGenerator;
    @Resource(name="resultSetClientFactory")
    private ResultSetClientFactory rsClientFactory;
    @Resource
    private DataSourceResolver dataSourceResolver;

    public void execute(Engine engine, NodeToken token) {
        try {
            String mdstoreID = token.getFullEnv().getAttribute(this.mdstoreIDAttributeName);
            String pubstoreID = token.getFullEnv().getAttribute(this.pubstoreIDAttributeName);
            String repoId = token.getFullEnv().getAttribute(this.repositoryIDAttributeName);
            String dataSourceDescriptor = this.sourceDescriptionGenerator.generateDataSourceDescriptor(mdstoreID);
            MongoPublisherStore pubStore = this.publisherStoreDAO.getStore(pubstoreID);
            IterableResultSetClient rsClient = this.rsClientFactory.getClient(this.dataSourceResolver.resolve(dataSourceDescriptor).retrieve());
            pubStore.feed((Iterable<String>)rsClient, repoId);
        }
        catch (Exception e) {
            this.failed(engine, token, e);
        }
        super.execute(engine, token);
    }

    public String getMdstoreIDAttributeName() {
        return this.mdstoreIDAttributeName;
    }

    public void setMdstoreIDAttributeName(String mdstoreIDAttributeName) {
        this.mdstoreIDAttributeName = mdstoreIDAttributeName;
    }

    public MongoPublisherStoreDAO getPublisherStoreDAO() {
        return this.publisherStoreDAO;
    }

    public void setPublisherStoreDAO(MongoPublisherStoreDAO publisherStoreDAO) {
        this.publisherStoreDAO = publisherStoreDAO;
    }

    public String getPubstoreIDAttributeName() {
        return this.pubstoreIDAttributeName;
    }

    public void setPubstoreIDAttributeName(String pubstoreIDAttributeName) {
        this.pubstoreIDAttributeName = pubstoreIDAttributeName;
    }

    public String getRepositoryIDAttributeName() {
        return this.repositoryIDAttributeName;
    }

    public void setRepositoryIDAttributeName(String repositoryIDAttributeName) {
        this.repositoryIDAttributeName = repositoryIDAttributeName;
    }

    public MDStoreDataSinkSourceDescriptorGenerator getSourceDescriptionGenerator() {
        return this.sourceDescriptionGenerator;
    }

    public void setSourceDescriptionGenerator(MDStoreDataSinkSourceDescriptorGenerator sourceDescriptionGenerator) {
        this.sourceDescriptionGenerator = sourceDescriptionGenerator;
    }

    public ResultSetClientFactory getRsClientFactory() {
        return this.rsClientFactory;
    }

    public void setRsClientFactory(ResultSetClientFactory rsClientFactory) {
        this.rsClientFactory = rsClientFactory;
    }

    public DataSourceResolver getDataSourceResolver() {
        return this.dataSourceResolver;
    }

    public void setDataSourceResolver(DataSourceResolver dataSourceResolver) {
        this.dataSourceResolver = dataSourceResolver;
    }
}

