/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.information.oai.publisher.store;

import com.google.common.collect.Multimap;
import com.mongodb.BasicDBObject;
import com.mongodb.BasicDBObjectBuilder;
import com.mongodb.DBCollection;
import com.mongodb.DBCursor;
import com.mongodb.DBObject;
import com.mongodb.WriteResult;
import eu.dnetlib.data.information.oai.publisher.core.MetadataExtractor;
import eu.dnetlib.data.information.oai.publisher.info.RecordInfo;
import eu.dnetlib.data.information.oai.publisher.store.MongoCursor;
import eu.dnetlib.data.information.oai.publisher.store.MongoQueryParser;
import eu.dnetlib.data.information.oai.publisher.store.PublisherStore;
import eu.dnetlib.data.information.oai.publisher.store.RecordChangeDetector;
import eu.dnetlib.data.information.oai.publisher.store.RecordInfoGenerator;
import eu.dnetlib.data.information.oai.publisher.store.parser.PublisherRecordParser;
import eu.dnetlib.miscutils.functional.UnaryFunction;
import java.util.Date;
import java.util.concurrent.ArrayBlockingQueue;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MongoPublisherStore
implements PublisherStore<MongoCursor> {
    private static final Log log = LogFactory.getLog(MongoPublisherStore.class);
    private String id;
    private String metadataFormat;
    private String interpretation;
    private String layout;
    private Multimap<String, String> indices;
    private DBCollection collection;
    private DBCollection discardedCollection;
    private RecordInfoGenerator recordInfoGenerator;
    private MetadataExtractor metadataExtractor;
    private MongoQueryParser queryParser;
    private RecordChangeDetector recordChangeDetector;
    private String idScheme;
    private String idNamespace;

    public String getId() {
        return this.id;
    }

    public String getMetadataFormat() {
        return this.metadataFormat;
    }

    public String getInterpretation() {
        return this.interpretation;
    }

    public String getLayout() {
        return this.layout;
    }

    public RecordInfo getRecord(String recordId) {
        BasicDBObject query = new BasicDBObject("objIdentifier", (Object)recordId);
        DBObject result = this.collection.findOne((DBObject)query);
        return this.recordInfoGenerator.transformDBObject(result, true);
    }

    public RecordInfo getRecord(String recordId, UnaryFunction<String, String> unaryFunction) {
        RecordInfo result = this.getRecord(recordId);
        if (result != null) {
            String transformedBody = (String)unaryFunction.evaluate((Object)result.getMetadata());
            result.setMetadata(transformedBody);
        }
        return result;
    }

    public MongoCursor getRecords(String queryString, boolean bodyIncluded) {
        DBObject query = this.queryParser.parse(queryString);
        DBCursor cursor = this.collection.find(query).sort((DBObject)new BasicDBObject("_id", (Object)1));
        return new MongoCursor(cursor, bodyIncluded, this.recordInfoGenerator, this.metadataExtractor);
    }

    public MongoCursor getRecords(String queryString, UnaryFunction<String, String> unaryFunction, boolean bodyIncluded) {
        DBObject query = this.queryParser.parse(queryString);
        DBCursor cursor = this.collection.find(query).sort((DBObject)new BasicDBObject("_id", (Object)1));
        return new MongoCursor(cursor, unaryFunction, bodyIncluded, this.recordInfoGenerator, this.metadataExtractor);
    }

    public Multimap<String, String> getIndices() {
        return this.indices;
    }

    public void ensureIndices() {
        this.collection.resetIndexCache();
        for (String key : this.indices.keySet()) {
            this.collection.ensureIndex((DBObject)new BasicDBObject(key, (Object)1));
        }
        this.collection.ensureIndex((DBObject)new BasicDBObject("datestamp", (Object)1));
        this.collection.ensureIndex((DBObject)new BasicDBObject("lastCollectionDate", (Object)1));
    }

    private void dropDiscarded(String source) {
        if (StringUtils.isBlank((String)source)) {
            log.debug((Object)("Dropping discarded records from publisherStore " + this.id));
            this.discardedCollection.drop();
        } else {
            log.debug((Object)("Dropping discarded records for source " + source + " from publisherStore " + this.id));
            this.discardedCollection.remove((DBObject)new BasicDBObject("set", (Object)source));
        }
    }

    public int feed(Iterable<String> records, final String source) {
        final ArrayBlockingQueue<Object> queue = new ArrayBlockingQueue<Object>(80);
        final Object sentinel = new Object();
        this.dropDiscarded(source);
        final Date feedDate = new Date();
        Thread background = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    Object record;
                    while ((record = queue.take()) != sentinel) {
                        MongoPublisherStore.this.safeFeedRecord((String)record, source, feedDate);
                    }
                }
                catch (InterruptedException e) {
                    log.fatal((Object)"got exception in background thread", (Throwable)e);
                    throw new IllegalStateException(e);
                }
            }
        });
        background.start();
        long startFeed = feedDate.getTime();
        try {
            log.info((Object)("feeding publisherStore " + this.id));
            for (String record : records) {
                queue.put(record);
            }
            queue.put(sentinel);
            log.info((Object)("finished feeding publisherStore " + this.id));
            background.join();
        }
        catch (InterruptedException e) {
            throw new IllegalStateException(e);
        }
        long endFeed = System.currentTimeMillis();
        log.info((Object)("OAI STORE " + this.id + " FEEDING COMPLETED IN " + (endFeed - startFeed) + "ms"));
        this.setDeletedFlags(feedDate, source);
        return this.count();
    }

    private void setDeletedFlags(final Date feedDate, final String source) {
        Thread deletedSetter = new Thread(new Runnable(){

            @Override
            public void run() {
                DBObject query = BasicDBObjectBuilder.start((String)"deleted", (Object)false).append("lastCollectionDate", (Object)new BasicDBObject("$lt", (Object)feedDate)).get();
                if (!StringUtils.isBlank((String)source)) {
                    query.put("set", (Object)source);
                }
                log.debug((Object)("Delete flag query: " + query.toString()));
                BasicDBObject update = new BasicDBObject("$set", (Object)BasicDBObjectBuilder.start((String)"deleted", (Object)true).append("datestamp", (Object)feedDate).append("updated", (Object)true).get());
                log.debug((Object)("Updating as: " + update.toString()));
                WriteResult wr = MongoPublisherStore.this.collection.update(query, (DBObject)update, false, true);
                log.info((Object)("Deleted flags set for source: " + source + " #records = " + wr.getN()));
            }
        });
        deletedSetter.start();
        try {
            deletedSetter.join();
        }
        catch (InterruptedException e) {
            throw new IllegalStateException(e);
        }
    }

    public void drop() {
        this.collection.drop();
    }

    public void drop(String queryString) {
        DBObject query = this.queryParser.parse(queryString);
        this.collection.remove(query);
    }

    public int count() {
        return (int)this.collection.count();
    }

    private void safeFeedRecord(String record, String source, Date feedDate) {
        try {
            if (record.isEmpty()) {
                return;
            }
            this.feedRecord(record, source, feedDate);
        }
        catch (Throwable e) {
            log.info((Object)"Got unhandled exception while parsing record", e);
            this.discardedCollection.insert(new DBObject[]{new BasicDBObject("set", (Object)source).append("body", (Object)record)});
        }
    }

    private void feedRecord(String record, String source, Date feedDate) {
        PublisherRecordParser parser = new PublisherRecordParser(this.indices);
        Multimap<String, String> recordProperties = parser.parseRecord(record);
        String id = "";
        String oaiID = "";
        if (recordProperties.containsKey((Object)"objIdentifier")) {
            id = (String)recordProperties.get((Object)"objIdentifier").iterator().next();
            oaiID = this.getOAIIdentifier(id);
            if (this.isNewRecord(oaiID)) {
                this.feedNew(oaiID, record, recordProperties, feedDate);
            } else if (this.isChanged(oaiID, record)) {
                this.updateRecord(oaiID, record, recordProperties, feedDate);
            } else {
                this.handleRecord(oaiID, feedDate);
            }
        } else {
            log.debug((Object)"parsed record seems invalid -- no identifier property with name: objIdentifier");
            this.discardedCollection.insert(new DBObject[]{new BasicDBObject("set", (Object)source).append("body", (Object)record).append("datestamp", (Object)feedDate)});
        }
    }

    private DBObject createBasicObject(String oaiID, String record, Multimap<String, String> recordProperties) {
        BasicDBObject obj = new BasicDBObject();
        for (String key : recordProperties.keySet()) {
            if (key.equals("objIdentifier")) {
                obj.put(key, (Object)oaiID);
                continue;
            }
            obj.put(key, (Object)recordProperties.get((Object)key));
        }
        obj.put("body", (Object)record);
        obj.put("deleted", (Object)false);
        return obj;
    }

    private void feedNew(String oaiID, String record, Multimap<String, String> recordProperties, Date feedDate) {
        log.debug((Object)("New record received. Assigned oai id: " + oaiID));
        DBObject obj = this.createBasicObject(oaiID, record, recordProperties);
        obj.put("lastCollectionDate", (Object)feedDate);
        obj.put("datestamp", (Object)feedDate);
        obj.put("updated", (Object)false);
        this.collection.insert(new DBObject[]{obj});
    }

    private void updateRecord(String oaiID, String record, Multimap<String, String> recordProperties, Date feedDate) {
        log.debug((Object)("updating record " + oaiID));
        DBObject obj = this.createBasicObject(oaiID, record, recordProperties);
        obj.put("lastCollectionDate", (Object)feedDate);
        obj.put("datestamp", (Object)feedDate);
        obj.put("updated", (Object)true);
        BasicDBObject oldObj = new BasicDBObject("objIdentifier", (Object)oaiID);
        this.collection.update((DBObject)oldObj, obj, true, false);
    }

    private void handleRecord(String oaiID, Date lastCollectionDate) {
        log.debug((Object)("handling unchanged record " + oaiID));
        BasicDBObject oldObj = new BasicDBObject("objIdentifier", (Object)oaiID);
        BasicDBObject update = new BasicDBObject("$set", (Object)new BasicDBObject("lastCollectionDate", (Object)lastCollectionDate));
        this.collection.update((DBObject)oldObj, (DBObject)update, true, false);
    }

    private boolean isNewRecord(String oaiIdentifier) {
        return this.collection.findOne((DBObject)new BasicDBObject("objIdentifier", (Object)oaiIdentifier)) == null;
    }

    private boolean isChanged(String oaiID, String record) {
        RecordInfo oldRecord = this.getRecord(oaiID);
        return this.recordChangeDetector.differs(oldRecord.getMetadata(), record);
    }

    private String getOAIIdentifier(String id) {
        return this.idScheme + ":" + this.idNamespace + ":" + id;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.collection == null ? 0 : this.collection.hashCode());
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        result = 31 * result + (this.interpretation == null ? 0 : this.interpretation.hashCode());
        result = 31 * result + (this.layout == null ? 0 : this.layout.hashCode());
        result = 31 * result + (this.metadataFormat == null ? 0 : this.metadataFormat.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MongoPublisherStore)) {
            return false;
        }
        MongoPublisherStore other = (MongoPublisherStore)obj;
        if (this.collection == null ? other.collection != null : !this.collection.equals((Object)other.collection)) {
            return false;
        }
        if (this.id == null ? other.id != null : !this.id.equals(other.id)) {
            return false;
        }
        if (this.interpretation == null ? other.interpretation != null : !this.interpretation.equals(other.interpretation)) {
            return false;
        }
        if (this.layout == null ? other.layout != null : !this.layout.equals(other.layout)) {
            return false;
        }
        return !(this.metadataFormat == null ? other.metadataFormat != null : !this.metadataFormat.equals(other.metadataFormat));
    }

    public MongoPublisherStore() {
    }

    public MongoPublisherStore(String id, String metadataFormat, String interpretation, String layout, DBCollection collection, Multimap<String, String> indices, MongoQueryParser queryParser, RecordInfoGenerator recordInfoGenerator, String idScheme, String idNamespace, MetadataExtractor metadataExtractor, RecordChangeDetector recordChangeDetector) {
        this.id = id;
        this.metadataFormat = metadataFormat;
        this.interpretation = interpretation;
        this.layout = layout;
        this.collection = collection;
        this.discardedCollection = collection.getDB().getCollection("discarded-" + collection.getName());
        this.indices = indices;
        this.queryParser = queryParser;
        this.recordInfoGenerator = recordInfoGenerator;
        this.idScheme = idScheme;
        this.idNamespace = idNamespace;
        this.recordChangeDetector = recordChangeDetector;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setMetadataFormat(String metadataFormat) {
        this.metadataFormat = metadataFormat;
    }

    public void setInterpretation(String interpretation) {
        this.interpretation = interpretation;
    }

    public void setLayout(String layout) {
        this.layout = layout;
    }

    public DBCollection getCollection() {
        return this.collection;
    }

    public void setCollection(DBCollection collection) {
        this.collection = collection;
    }

    public MongoQueryParser getQueryParser() {
        return this.queryParser;
    }

    public void setQueryParser(MongoQueryParser queryParser) {
        this.queryParser = queryParser;
    }

    public void setIndices(Multimap<String, String> indices) {
        this.indices = indices;
    }

    public DBCollection getDiscardedCollection() {
        return this.discardedCollection;
    }

    public void setDiscardedCollection(DBCollection discardedCollection) {
        this.discardedCollection = discardedCollection;
    }

    public String getIdScheme() {
        return this.idScheme;
    }

    public void setIdScheme(String idScheme) {
        this.idScheme = idScheme;
    }

    public String getIdNamespace() {
        return this.idNamespace;
    }

    public void setIdNamespace(String idNamespace) {
        this.idNamespace = idNamespace;
    }

    public RecordInfoGenerator getRecordInfoGenerator() {
        return this.recordInfoGenerator;
    }

    public void setRecordInfoGenerator(RecordInfoGenerator recordInfoGenerator) {
        this.recordInfoGenerator = recordInfoGenerator;
    }

    public MetadataExtractor getMetadataExtractor() {
        return this.metadataExtractor;
    }

    public void setMetadataExtractor(MetadataExtractor metadataExtractor) {
        this.metadataExtractor = metadataExtractor;
    }

    public RecordChangeDetector getRecordChangeDetector() {
        return this.recordChangeDetector;
    }

    public void setRecordChangeDetector(RecordChangeDetector recordChangeDetector) {
        this.recordChangeDetector = recordChangeDetector;
    }
}

