/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.information.oai.publisher.store;

import com.mongodb.DBCursor;
import com.mongodb.DBObject;
import eu.dnetlib.data.information.oai.publisher.OaiPublisherRuntimeException;
import eu.dnetlib.data.information.oai.publisher.core.MetadataExtractor;
import eu.dnetlib.data.information.oai.publisher.info.RecordInfo;
import eu.dnetlib.data.information.oai.publisher.store.Cursor;
import eu.dnetlib.data.information.oai.publisher.store.RecordInfoGenerator;
import eu.dnetlib.miscutils.functional.UnaryFunction;
import java.io.Reader;
import java.io.StringReader;
import java.util.Iterator;
import org.dom4j.DocumentException;
import org.dom4j.io.SAXReader;

public class MongoCursor
implements Cursor {
    private DBCursor dbCursor;
    private UnaryFunction<String, String> function;
    private boolean bodyIncluded;
    private RecordInfoGenerator recordInfoGenerator;
    private MetadataExtractor metadataExtractor;

    public int count() {
        return this.dbCursor.count();
    }

    public Iterator<RecordInfo> iterator() {
        return new Iterator<RecordInfo>(){

            @Override
            public boolean hasNext() {
                return MongoCursor.this.dbCursor.hasNext();
            }

            @Override
            public RecordInfo next() {
                try {
                    DBObject res = MongoCursor.this.dbCursor.next();
                    RecordInfo info = MongoCursor.this.recordInfoGenerator.transformDBObject(res, MongoCursor.this.bodyIncluded);
                    if (MongoCursor.this.function != null && MongoCursor.this.bodyIncluded) {
                        String body = MongoCursor.this.metadataExtractor.evaluate(new SAXReader().read((Reader)new StringReader(info.getMetadata())));
                        info.setMetadata((String)MongoCursor.this.function.evaluate((Object)body));
                    }
                    return info;
                }
                catch (DocumentException e) {
                    throw new OaiPublisherRuntimeException((Throwable)e);
                }
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public MongoCursor() {
    }

    public MongoCursor(DBCursor dbCursor, boolean bodyIncluded, RecordInfoGenerator recordInfoGenerator, MetadataExtractor metadataExtractor) {
        this(dbCursor, null, bodyIncluded, recordInfoGenerator, metadataExtractor);
    }

    public MongoCursor(DBCursor dbCursor, UnaryFunction<String, String> function, boolean bodyIncluded, RecordInfoGenerator recordInfoGenerator, MetadataExtractor metadataExtractor) {
        this.dbCursor = dbCursor;
        this.function = function;
        this.bodyIncluded = bodyIncluded;
        this.recordInfoGenerator = recordInfoGenerator;
        this.metadataExtractor = metadataExtractor;
    }

    public UnaryFunction<String, String> getFunction() {
        return this.function;
    }

    public void setFunction(UnaryFunction<String, String> function) {
        this.function = function;
    }

    public DBCursor getDbCursor() {
        return this.dbCursor;
    }

    public void setDbCursor(DBCursor dbCursor) {
        this.dbCursor = dbCursor;
    }

    public boolean isBodyIncluded() {
        return this.bodyIncluded;
    }

    public void setBodyIncluded(boolean bodyIncluded) {
        this.bodyIncluded = bodyIncluded;
    }

    public RecordInfoGenerator getRecordInfoGenerator() {
        return this.recordInfoGenerator;
    }

    public void setRecordInfoGenerator(RecordInfoGenerator recordInfoGenerator) {
        this.recordInfoGenerator = recordInfoGenerator;
    }

    public MetadataExtractor getMetadataExtractor() {
        return this.metadataExtractor;
    }

    public void setMetadataExtractor(MetadataExtractor metadataExtractor) {
        this.metadataExtractor = metadataExtractor;
    }
}

