/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.information.oai.publisher.sets;

import eu.dnetlib.data.information.oai.publisher.OaiPublisherRuntimeException;
import eu.dnetlib.data.information.oai.publisher.conf.PublisherConfigurationReader;
import eu.dnetlib.data.information.oai.publisher.info.SetInfo;
import eu.dnetlib.data.information.oai.publisher.sets.SetCollection;
import java.util.List;
import javax.annotation.Resource;

public class ConfigurationSetCollection
implements SetCollection {
    @Resource
    private PublisherConfigurationReader configuration;

    public List<SetInfo> getAllSets() {
        return this.configuration.getSets(true);
    }

    public boolean containSet(String set) {
        return this.configuration.getSetSpecs().contains(set);
    }

    public String getSetQuery(String set) {
        SetInfo setInfo = this.configuration.getSetInfo(set);
        if (setInfo == null) {
            throw new OaiPublisherRuntimeException("No set with name " + set + " is defined in the OAI Publisher configuration profile");
        }
        return setInfo.getQuery();
    }

    public PublisherConfigurationReader getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(PublisherConfigurationReader configuration) {
        this.configuration = configuration;
    }
}

