/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.information.oai.publisher.core;

import com.google.common.collect.Lists;
import eu.dnetlib.data.information.oai.publisher.OaiPublisherRuntimeException;
import eu.dnetlib.data.information.oai.publisher.core.ResumptionToken;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ResumptionTokenImpl
implements ResumptionToken {
    private static final Log log = LogFactory.getLog(ResumptionTokenImpl.class);
    private int nMaxElements;
    private String metadataPrefix;
    private String query;
    private int nRead;
    private String lastObjIdentifier;
    private String requestedSet = "";

    public String serialize() {
        String escapedQuery = StringEscapeUtils.escapeXml((String)this.query);
        ArrayList info = Lists.newArrayList((Object[])new String[]{"" + this.nMaxElements, this.metadataPrefix, escapedQuery, "" + this.nRead, this.lastObjIdentifier, this.requestedSet});
        try {
            String encoded = URLEncoder.encode(StringUtils.join((Collection)info, (String)"|"), "UTF-8");
            return encoded;
        }
        catch (UnsupportedEncodingException e) {
            throw new OaiPublisherRuntimeException((Throwable)e);
        }
    }

    public void deserialize(String token) {
        String unescapedQuery;
        String decoded;
        try {
            decoded = URLDecoder.decode(token, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new OaiPublisherRuntimeException((Throwable)e);
        }
        String[] info = StringUtils.split((String)decoded, (String)"|");
        if (info.length < 5) {
            throw new OaiPublisherRuntimeException("badResumptionToken");
        }
        this.nMaxElements = Integer.parseInt(info[0]);
        this.metadataPrefix = info[1];
        this.query = unescapedQuery = StringEscapeUtils.unescapeXml((String)info[2]);
        this.nRead = Integer.parseInt(info[3]);
        this.lastObjIdentifier = info[4];
        if (info.length == 6) {
            this.requestedSet = info[5];
        }
    }

    public int getnMaxElements() {
        return this.nMaxElements;
    }

    public void setnMaxElements(int nMaxElements) {
        this.nMaxElements = nMaxElements;
    }

    public String getMetadataPrefix() {
        return this.metadataPrefix;
    }

    public void setMetadataPrefix(String metadataPrefix) {
        this.metadataPrefix = metadataPrefix;
    }

    public String getQuery() {
        return this.query;
    }

    public void setQuery(String query) {
        this.query = query;
    }

    public int getnRead() {
        return this.nRead;
    }

    public void setnRead(int nRead) {
        this.nRead = nRead;
    }

    public String getLastObjIdentifier() {
        return this.lastObjIdentifier;
    }

    public void setLastObjIdentifier(String lastObjIdentifier) {
        this.lastObjIdentifier = lastObjIdentifier;
    }

    public String getRequestedSet() {
        return this.requestedSet;
    }

    public void setRequestedSet(String requestedSet) {
        this.requestedSet = requestedSet;
    }

    public String toString() {
        return "ResumptionToken [nMaxElements=" + this.nMaxElements + ", metadataPrefix=" + this.metadataPrefix + ", query=" + this.query + ", nRead=" + this.nRead + ", lastObjIdentifier=" + this.lastObjIdentifier + ", requestedSet= " + this.requestedSet + "]";
    }
}

