/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.information.oai.publisher.conf;

import com.google.common.collect.Lists;
import eu.dnetlib.data.information.oai.publisher.OaiPublisherRuntimeException;
import eu.dnetlib.data.information.oai.publisher.conf.OAIStoreInitializerFactory;
import eu.dnetlib.data.information.oai.publisher.conf.PublisherConfigurationReader;
import eu.dnetlib.data.information.oai.publisher.info.MDFInfo;
import eu.dnetlib.enabling.tools.AbstractSchedulable;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import javax.annotation.Resource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Required;

public class SchedulableOAIInitializer
extends AbstractSchedulable {
    private static final Log log = LogFactory.getLog(SchedulableOAIInitializer.class);
    @Resource
    private PublisherConfigurationReader configuration;
    private OAIStoreInitializerFactory initializerFactory;
    private int maxInitThreads = 2;
    private boolean forceContentSynchronization;

    protected void doExecute() {
        log.info((Object)("Initializing OAI Publisher stores from its configuration profile with initializer from factory: " + this.initializerFactory.getClass().getCanonicalName()));
        new Thread(){

            @Override
            public void run() {
                SchedulableOAIInitializer.this.checkStores();
            }
        }.start();
        log.info((Object)"OAI Publisher configuration updated.");
    }

    protected void checkStores() {
        ExecutorService executor = Executors.newFixedThreadPool(this.maxInitThreads);
        List<MDFInfo> metadataFormats = this.configuration.getMetadataFormatInfo();
        ArrayList futures = Lists.newArrayList();
        for (MDFInfo mdf : metadataFormats) {
            futures.add(executor.submit(this.initializerFactory.create(mdf, this.forceContentSynchronization)));
        }
        executor.shutdown();
        for (Future future : futures) {
            try {
                future.get();
            }
            catch (InterruptedException e) {
                throw new OaiPublisherRuntimeException((Throwable)e);
            }
            catch (ExecutionException e) {
                throw new OaiPublisherRuntimeException((Throwable)e);
            }
        }
    }

    public OAIStoreInitializerFactory getInitializerFactory() {
        return this.initializerFactory;
    }

    @Required
    public void setInitializerFactory(OAIStoreInitializerFactory initializerFactory) {
        this.initializerFactory = initializerFactory;
    }

    public int getMaxInitThreads() {
        return this.maxInitThreads;
    }

    public void setMaxInitThreads(int maxInitThreads) {
        this.maxInitThreads = maxInitThreads;
    }

    public PublisherConfigurationReader getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(PublisherConfigurationReader configuration) {
        this.configuration = configuration;
    }

    public boolean isForceContentSynchronization() {
        return this.forceContentSynchronization;
    }

    @Required
    public void setForceContentSynchronization(boolean forceContentSynchronization) {
        this.forceContentSynchronization = forceContentSynchronization;
    }
}

