/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.information.oai.publisher.conf;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import eu.dnetlib.data.information.oai.publisher.info.MDFInfo;
import eu.dnetlib.data.information.oai.publisher.info.SetInfo;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpException;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpService;
import eu.dnetlib.enabling.tools.SplittedQueryExecutor;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Resource;

public class PublisherConfigurationReader {
    public static final String ID_FIELD = "objIdentifier";
    public static final String DATESTAMP_FIELD = "datestamp";
    public static final String SET_FIELD = "set";
    public static final String DELETED_FIELD = "deleted";
    public static final String BODY_FIELD = "body";
    public static final String UPDATED_FIELD = "updated";
    public static final String LAST_COLLECTION_DATE_FIELD = "lastCollectionDate";
    private String idScheme;
    private String idNamespace;
    @Resource
    private SplittedQueryExecutor queryExecutor;

    public List<SetInfo> getSets() {
        String query = "for $x in collection('/db/DRIVER/OAIPublisherConfigurationDSResources/OAIPublisherConfigurationDSResourceType')//CONFIGURATION/OAISETS/OAISET return concat($x/spec, ':-:', $x/name, ':-:', $x//description , ':-:', $x//query, ':-:', $x/@enabled/string())";
        Iterable sets = this.queryExecutor.query(SetInfo.class, "for $x in collection('/db/DRIVER/OAIPublisherConfigurationDSResources/OAIPublisherConfigurationDSResourceType')//CONFIGURATION/OAISETS/OAISET return concat($x/spec, ':-:', $x/name, ':-:', $x//description , ':-:', $x//query, ':-:', $x/@enabled/string())", ":-:");
        return Lists.newArrayList((Iterable)sets);
    }

    public List<SetInfo> getSets(boolean onlyEnabled) {
        if (onlyEnabled) {
            String query = "for $x in collection('/db/DRIVER/OAIPublisherConfigurationDSResources/OAIPublisherConfigurationDSResourceType')//CONFIGURATION/OAISETS/OAISET where $x/@enabled/string() = 'true' return concat($x/spec, ':-:', $x/name, ':-:', $x//description , ':-:', $x//query, ':-:', $x/@enabled/string())";
            Iterable sets = this.queryExecutor.query(SetInfo.class, "for $x in collection('/db/DRIVER/OAIPublisherConfigurationDSResources/OAIPublisherConfigurationDSResourceType')//CONFIGURATION/OAISETS/OAISET where $x/@enabled/string() = 'true' return concat($x/spec, ':-:', $x/name, ':-:', $x//description , ':-:', $x//query, ':-:', $x/@enabled/string())", ":-:");
            return Lists.newArrayList((Iterable)sets);
        }
        return this.getSets();
    }

    public List<String> getSetSpecs() {
        String query = "for $x in collection('/db/DRIVER/OAIPublisherConfigurationDSResources/OAIPublisherConfigurationDSResourceType')//CONFIGURATION/OAISETS/OAISET where $x/@enabled/string() = 'true' return $x/spec/string() ";
        List names = this.queryExecutor.performQuery("for $x in collection('/db/DRIVER/OAIPublisherConfigurationDSResources/OAIPublisherConfigurationDSResourceType')//CONFIGURATION/OAISETS/OAISET where $x/@enabled/string() = 'true' return $x/spec/string() ");
        return names;
    }

    public SetInfo getSetInfo(String setSpec) {
        String query = "for $x in collection('/db/DRIVER/OAIPublisherConfigurationDSResources/OAIPublisherConfigurationDSResourceType')//CONFIGURATION/OAISETS/OAISET where $x/spec = '" + setSpec + "' " + "return concat($x/spec, ':-:', $x/name, ':-:', $x//description , ':-:', $x//query, ':-:', $x/@enabled/string())";
        Iterable sets = this.queryExecutor.query(SetInfo.class, query, ":-:");
        if (sets.iterator().hasNext()) {
            return (SetInfo)sets.iterator().next();
        }
        return null;
    }

    public List<MDFInfo> getMetadataFormatInfo() {
        String query = "for $x in collection('/db/DRIVER/OAIPublisherConfigurationDSResources/OAIPublisherConfigurationDSResourceType')//CONFIGURATION//METADATAFORMAT return concat($x/@metadataPrefix/string(), ':-:', $x//SCHEMA , ':-:', $x//NAMESPACE,  ':-:', $x//SOURCE_METADATA_FORMAT/@name/string(), ':-:',  $x//SOURCE_METADATA_FORMAT/@layout/string(), ':-:', $x//SOURCE_METADATA_FORMAT/@interpretation/string(), ':-:', $x//BASE_QUERY, ':-:',  $x//TRANSFORMATION_RULE, ':-:', $x/@exportable/string() )";
        Iterable mdFormats = this.queryExecutor.query(MDFInfo.class, "for $x in collection('/db/DRIVER/OAIPublisherConfigurationDSResources/OAIPublisherConfigurationDSResourceType')//CONFIGURATION//METADATAFORMAT return concat($x/@metadataPrefix/string(), ':-:', $x//SCHEMA , ':-:', $x//NAMESPACE,  ':-:', $x//SOURCE_METADATA_FORMAT/@name/string(), ':-:',  $x//SOURCE_METADATA_FORMAT/@layout/string(), ':-:', $x//SOURCE_METADATA_FORMAT/@interpretation/string(), ':-:', $x//BASE_QUERY, ':-:',  $x//TRANSFORMATION_RULE, ':-:', $x/@exportable/string() )", ":-:");
        return Lists.newArrayList((Iterable)mdFormats);
    }

    public List<MDFInfo> getMetadataFormatInfo(boolean onlyEnabled) {
        if (onlyEnabled) {
            String query = "for $x in collection('/db/DRIVER/OAIPublisherConfigurationDSResources/OAIPublisherConfigurationDSResourceType')//CONFIGURATION//METADATAFORMAT where $x/@exportable/string() = 'true' return concat($x/@metadataPrefix/string(), ':-:', $x//SCHEMA , ':-:', $x//NAMESPACE,  ':-:', $x//SOURCE_METADATA_FORMAT/@name/string(), ':-:',  $x//SOURCE_METADATA_FORMAT/@layout/string(), ':-:', $x//SOURCE_METADATA_FORMAT/@interpretation/string(), ':-:', $x//BASE_QUERY, ':-:',  $x//TRANSFORMATION_RULE, ':-:', $x/@exportable/string() )";
            Iterable mdFormats = this.queryExecutor.query(MDFInfo.class, "for $x in collection('/db/DRIVER/OAIPublisherConfigurationDSResources/OAIPublisherConfigurationDSResourceType')//CONFIGURATION//METADATAFORMAT where $x/@exportable/string() = 'true' return concat($x/@metadataPrefix/string(), ':-:', $x//SCHEMA , ':-:', $x//NAMESPACE,  ':-:', $x//SOURCE_METADATA_FORMAT/@name/string(), ':-:',  $x//SOURCE_METADATA_FORMAT/@layout/string(), ':-:', $x//SOURCE_METADATA_FORMAT/@interpretation/string(), ':-:', $x//BASE_QUERY, ':-:',  $x//TRANSFORMATION_RULE, ':-:', $x/@exportable/string() )", ":-:");
            return Lists.newArrayList((Iterable)mdFormats);
        }
        return this.getMetadataFormatInfo();
    }

    public MDFInfo getMetadataFormatInfo(String mdPrefix) {
        String query = "for $x in collection('/db/DRIVER/OAIPublisherConfigurationDSResources/OAIPublisherConfigurationDSResourceType')//CONFIGURATION//METADATAFORMAT where $x/@metadataPrefix/string()='" + mdPrefix + "' " + "return concat($x/@metadataPrefix/string(), ':-:', $x//SCHEMA , ':-:', $x//NAMESPACE,  " + "':-:', $x//SOURCE_METADATA_FORMAT/@name/string(), ':-:',  $x//SOURCE_METADATA_FORMAT/@layout/string(), ':-:', $x//SOURCE_METADATA_FORMAT/@interpretation/string(), " + "':-:', $x//BASE_QUERY,':-:', $x//TRANSFORMATION_RULE, ':-:', $x/@exportable/string() )";
        Iterable mdFormats = this.queryExecutor.query(MDFInfo.class, query, ":-:");
        Iterator iterator = mdFormats.iterator();
        if (iterator.hasNext()) {
            return (MDFInfo)iterator.next();
        }
        return null;
    }

    public Multimap<String, String> getIndices(String format, String interpretation, String layout) throws ISLookUpException {
        ArrayListMultimap indices = ArrayListMultimap.create();
        String query = "for $x in collection('/db/DRIVER/OAIPublisherConfigurationDSResources/OAIPublisherConfigurationDSResourceType')//CONFIGURATION//INDICES/INDEX return concat($x/@name, ':-:', string-join($x/SOURCE[./@name/string()='" + format + "' and ./@interpretation/string()='" + interpretation + "' and ./@layout/string()='" + layout + "']/@path/string(), ':-:'))";
        List res = ((ISLookUpService)this.queryExecutor.getLookupLocator().getService()).quickSearchProfile(query);
        for (String index : res) {
            String[] splitted = index.split(":-:");
            String indexName = splitted[0];
            for (int i = 1; i < splitted.length; ++i) {
                indices.put((Object)indexName, (Object)splitted[i]);
            }
        }
        return indices;
    }

    public List<String> getIndexNames() throws ISLookUpException {
        String query = "//RESOURCE_PROFILE[.//RESOURCE_TYPE/@value = 'OAIPublisherConfigurationDSResourceType']//CONFIGURATION//INDICES/INDEX/@name/string()";
        return ((ISLookUpService)this.queryExecutor.getLookupLocator().getService()).quickSearchProfile(query);
    }

    public SplittedQueryExecutor getQueryExecutor() {
        return this.queryExecutor;
    }

    public void setQueryExecutor(SplittedQueryExecutor queryExecutor) {
        this.queryExecutor = queryExecutor;
    }

    public String getIdScheme() {
        return this.idScheme;
    }

    public void setIdScheme(String idScheme) {
        this.idScheme = idScheme;
    }

    public String getIdNamespace() {
        return this.idNamespace;
    }

    public void setIdNamespace(String idNamespace) {
        this.idNamespace = idNamespace;
    }
}

