/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.functionality.index.cql;

import eu.dnetlib.functionality.index.cql.CqlUtils;
import java.util.List;
import org.z3950.zing.cql.CQLBooleanNode;
import org.z3950.zing.cql.CQLNode;
import org.z3950.zing.cql.CQLPrefixNode;
import org.z3950.zing.cql.CQLTermNode;

public class CqlFilter {
    public CQLNode filter(CQLNode node, List<String> fields) {
        return this.doFilter(node, fields);
    }

    private CQLNode doFilter(CQLNode node, List<String> fields) {
        if (node instanceof CQLBooleanNode) {
            return this.doFilter((CQLBooleanNode)node, fields);
        }
        if (node instanceof CQLTermNode) {
            return CqlFilter.doFilter((CQLTermNode)node, fields);
        }
        if (node instanceof CQLPrefixNode) {
            return node;
        }
        if (node == null) {
            return null;
        }
        throw new RuntimeException("error choice");
    }

    private CQLNode doFilter(CQLBooleanNode node, List<String> fields) {
        CQLNode left = this.doFilter(node.getLeftOperand(), fields);
        CQLNode right = this.doFilter(node.getRightOperand(), fields);
        if (left == null && right == null) {
            return null;
        }
        if (left == null) {
            return right;
        }
        if (right == null) {
            return left;
        }
        return CqlUtils.cloneBooleanNode(node, left, right);
    }

    private static CQLNode doFilter(CQLTermNode node, List<String> fields) {
        return CqlFilter.isTermNodeToFilter(node, fields) ? null : node;
    }

    private static boolean isTermNodeToFilter(CQLTermNode node, List<String> fields) {
        return fields.contains(node.getIndex().toLowerCase());
    }
}

