/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.functionality.index.cql;

import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.z3950.zing.cql.CQLBooleanNode;
import org.z3950.zing.cql.CQLNode;
import org.z3950.zing.cql.CQLOrNode;
import org.z3950.zing.cql.CQLParser;
import org.z3950.zing.cql.CQLTermNode;
import org.z3950.zing.cql.ModifierSet;

public class CQLExpander {
    private static final String OP = "or";
    private static final String _OP_ = " or ";

    public CQLNode expand(CQLNode node, Set<String> fields) {
        return CQLExpander.doExpand(node, fields);
    }

    private static CQLNode doExpand(CQLNode node, Set<String> fields) {
        if (node instanceof CQLBooleanNode) {
            return CQLExpander.doExpand((CQLBooleanNode)node, fields);
        }
        if (node instanceof CQLTermNode) {
            return CQLExpander.doExpand((CQLTermNode)node, fields);
        }
        throw new RuntimeException("error choice");
    }

    private static CQLNode doExpand(CQLBooleanNode node, Set<String> fields) {
        CQLNode left = CQLExpander.doExpand(node.getLeftOperand(), fields);
        CQLNode right = CQLExpander.doExpand(node.getRightOperand(), fields);
        return new CQLOrNode(left, right, new ModifierSet(OP));
    }

    private static CQLNode doExpand(CQLTermNode node, Set<String> fields) {
        String expand = "";
        for (String field : fields) {
            expand = expand + field + "=" + node.getTerm() + _OP_;
        }
        expand = StringUtils.removeEnd((String)expand, (String)_OP_);
        try {
            return new CQLParser(12370).parse(expand);
        }
        catch (Exception e) {
            throw new RuntimeException("unable to parse: " + expand);
        }
    }
}

