/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.functionality.index.parse;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.Maps;
import eu.dnetlib.functionality.index.parse.Node;
import eu.dnetlib.functionality.index.parse.Relation;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.lucene.queryparser.classic.QueryParser;

public class TermNode
extends Node {
    public static final String dnetDefaultField = "__all";
    private String field;
    private Relation rel;
    private String value;
    private Map<String, List<String>> options = Maps.newHashMap();
    private BiMap<String, String> aliases = HashBiMap.create();
    private Map<String, String> weights = Maps.newHashMap();

    public TermNode(String field, Relation rel, String value) {
        this.field = field;
        this.rel = rel;
        this.value = value;
    }

    public TermNode(String field, Relation rel, String value, Map<String, List<String>> options, BiMap<String, String> aliases, Map<String, String> weights) {
        this(field, rel, value);
        this.options = options;
        this.aliases = aliases;
        this.weights = weights;
    }

    @Override
    public String toString() {
        return TermNode.class.getSimpleName() + "(" + this.field + " " + (Object)((Object)this.rel) + " " + this.value + ")";
    }

    @Override
    public String toLucene() {
        StringTokenizer termTokenizer = new StringTokenizer(this.value, " ");
        StringTokenizer weightTokenizer = new StringTokenizer(this.value, " ");
        switch (this.rel) {
            case EXACT: {
                return this.getFieldName() + ":" + "\"" + this.value + "\"" + this.weight() + " " + this.expand(this.value);
            }
            case ALL: {
                return "(" + this.handleTokens(termTokenizer, "+") + " " + this.expandTokens(weightTokenizer) + ")";
            }
            case EQUAL: 
            case ANY: {
                return "(" + this.handleTokens(termTokenizer, "") + " " + this.expandTokens(weightTokenizer) + ")";
            }
            case NOT: {
                return "-" + this.field + ":" + "\"" + this.value + "\"";
            }
            case LT: {
                return this.field + ":" + "{* TO " + this.value + "}" + this.weight();
            }
            case GT: {
                return this.field + ":" + "{" + this.value + " TO *}" + this.weight();
            }
            case LTE: {
                return this.field + ":" + "[* TO " + this.value + "]" + this.weight();
            }
            case GTE: {
                return this.field + ":" + "[" + this.value + " TO *]" + this.weight();
            }
            case WITHIN: {
                String lower = this.checkDate(this.value.split(" ")[0]);
                String upper = this.checkDate(this.value.split(" ")[1]);
                return this.field + ":[" + lower + " TO " + upper + "]" + this.weight();
            }
        }
        throw new RuntimeException("unable to serialize: " + this.toString());
    }

    private String getFieldName() {
        return this.aliases.get((Object)this.field) != null ? (String)this.aliases.get((Object)this.field) : this.field;
    }

    private String weight() {
        return this.weights != null && this.weights.get(this.field) != null ? "^" + this.weights.get(this.field) : "";
    }

    private String expandTokens(StringTokenizer tokenizer) {
        String ret = "";
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            if (!this.field.equals(dnetDefaultField.toLowerCase()) && !this.field.equals(dnetDefaultField.toLowerCase())) continue;
            ret = ret + this.expand(token);
        }
        return ret.trim();
    }

    private String expand(String token) {
        String ret = "";
        if (!this.weights.keySet().contains(this.field)) {
            for (Map.Entry<String, String> e : this.weights.entrySet()) {
                ret = ret + e.getKey() + ":\"" + this.checkEscaping(token) + "\"^" + e.getValue() + " ";
            }
        }
        return ret;
    }

    private String handleTokens(StringTokenizer tokenizer, String op) {
        String ret = "";
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            ret = ret + op + this.field + ":" + this.checkEscaping(token) + this.weight() + " ";
        }
        return ret.trim();
    }

    private String checkEscaping(String token) {
        boolean isWildcardEnabled;
        boolean isWildcard = token.contains("*") || token.contains("?");
        boolean bl = isWildcardEnabled = this.options.get("wildcard") != null && this.options.get("wildcard").contains("true") || token.equals("*");
        if (!(isWildcard & isWildcardEnabled)) {
            token = QueryParser.escape((String)token);
        }
        return token;
    }

    private String checkDate(String date) {
        if (!date.endsWith("Z")) {
            return date + "T00:00:00Z";
        }
        return date;
    }

    public String getField() {
        return this.field;
    }

    public Relation getRel() {
        return this.rel;
    }

    public String getValue() {
        return this.value;
    }
}

