/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.functionality.index.parse;

import eu.dnetlib.functionality.index.parse.Node;
import eu.dnetlib.functionality.index.parse.Relation;
import eu.dnetlib.functionality.index.parse.TermNode;

public abstract class BooleanNode
extends Node {
    private Node left;
    private Node right;

    public BooleanNode(Node left, Node right) {
        this.left = left;
        this.right = right;
    }

    public abstract String op();

    @Override
    public String toString() {
        return BooleanNode.class.getSimpleName() + "(" + this.left + ", " + this.right + ")";
    }

    @Override
    public String toLucene() {
        return "(" + this.peekNotRel(this.left) + this.left.toLucene() + " " + this.peekNotRel(this.right) + this.right.toLucene() + ")";
    }

    private String peekNotRel(Node node) {
        if (node instanceof TermNode && ((TermNode)node).getRel().equals((Object)Relation.NOT)) {
            return "";
        }
        return this.op();
    }

    public Node getLeft() {
        return this.left;
    }

    public Node getRight() {
        return this.right;
    }
}

