/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.functionality.index.cql;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import eu.dnetlib.functionality.index.cql.CqlTranslator;
import eu.dnetlib.functionality.index.cql.CqlValueTransformerMap;
import eu.dnetlib.functionality.index.cql.IdentityCqlValueTransformerMap;
import eu.dnetlib.functionality.index.cql.QueryOptions;
import eu.dnetlib.functionality.index.cql.SortOperation;
import eu.dnetlib.functionality.index.cql.TranslatedQuery;
import eu.dnetlib.functionality.index.parse.AndNode;
import eu.dnetlib.functionality.index.parse.Node;
import eu.dnetlib.functionality.index.parse.NotNode;
import eu.dnetlib.functionality.index.parse.OrNode;
import eu.dnetlib.functionality.index.parse.Relations;
import eu.dnetlib.functionality.index.parse.TermNode;
import eu.dnetlib.miscutils.functional.UnaryFunction;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.z3950.zing.cql.CQLAndNode;
import org.z3950.zing.cql.CQLBooleanNode;
import org.z3950.zing.cql.CQLNode;
import org.z3950.zing.cql.CQLNotNode;
import org.z3950.zing.cql.CQLOrNode;
import org.z3950.zing.cql.CQLParseException;
import org.z3950.zing.cql.CQLParser;
import org.z3950.zing.cql.CQLSortNode;
import org.z3950.zing.cql.CQLTermNode;
import org.z3950.zing.cql.Modifier;
import org.z3950.zing.cql.ModifierSet;

public class CqlTranslatorImpl
implements CqlTranslator {
    @Override
    public String toLucene(String queryRoot) throws CQLParseException, IOException {
        return this.toLucene(CqlTranslatorImpl.parse(queryRoot), (CqlValueTransformerMap)new IdentityCqlValueTransformerMap());
    }

    @Override
    public String toLucene(String queryRoot, Map<String, List<String>> options) throws CQLParseException, IOException {
        return this.toLucene(CqlTranslatorImpl.parse(queryRoot), new IdentityCqlValueTransformerMap(), options);
    }

    @Override
    public String toLucene(String queryRoot, CqlValueTransformerMap valueTransformerMap) throws CQLParseException, IOException {
        return this.toLucene(CqlTranslatorImpl.parse(queryRoot), valueTransformerMap);
    }

    @Override
    public String toLucene(CQLNode queryRoot) throws CQLParseException, IOException {
        return this.toLucene(queryRoot, (CqlValueTransformerMap)new IdentityCqlValueTransformerMap());
    }

    @Override
    public String toLucene(CQLNode queryRoot, CqlValueTransformerMap valueTransformerMap) throws CQLParseException, IOException {
        return this.getTranslatedQuery(queryRoot, valueTransformerMap).asLucene();
    }

    @Override
    public String toLucene(CQLNode queryRoot, CqlValueTransformerMap valueTransformerMap, Map<String, List<String>> options) throws CQLParseException, IOException {
        HashBiMap aliases = HashBiMap.create();
        return this.getTranslatedQuery(queryRoot, valueTransformerMap, options, (BiMap<String, String>)aliases, new HashMap<String, String>()).asLucene();
    }

    @Override
    public TranslatedQuery getTranslatedQuery(CQLNode queryRoot, CqlValueTransformerMap valueTransformerMap) throws CQLParseException, IOException {
        HashBiMap aliases = HashBiMap.create();
        return this.getTranslatedQuery(queryRoot, valueTransformerMap, new HashMap<String, List<String>>(), (BiMap<String, String>)aliases, new HashMap<String, String>());
    }

    @Override
    public TranslatedQuery getTranslatedQuery(CQLNode queryRoot, CqlValueTransformerMap valueTransformerMap, Map<String, List<String>> options, BiMap<String, String> aliases, Map<String, String> weights) throws CQLParseException, IOException {
        return CqlTranslatorImpl.translate(this.hackAnd(queryRoot), valueTransformerMap, options, aliases, weights);
    }

    private CQLNode hackAnd(CQLNode queryRoot) throws CQLParseException, IOException {
        String cql = queryRoot.toCQL().toLowerCase();
        if (cql.startsWith("\"and ") || cql.startsWith("and ")) {
            return CqlTranslatorImpl.parse(cql.replaceFirst("and ", ""));
        }
        return queryRoot;
    }

    @Override
    public TranslatedQuery getTranslatedQuery(String cqlQuery) throws CQLParseException, IOException {
        return this.getTranslatedQuery(CqlTranslatorImpl.parse(cqlQuery), (CqlValueTransformerMap)new IdentityCqlValueTransformerMap());
    }

    @Override
    public TranslatedQuery getTranslatedQuery(String cqlQuery, Map<String, List<String>> options) throws CQLParseException, IOException {
        HashBiMap aliases = HashBiMap.create();
        return this.getTranslatedQuery(CqlTranslatorImpl.parse(cqlQuery), new IdentityCqlValueTransformerMap(), options, (BiMap<String, String>)aliases, new HashMap<String, String>());
    }

    @Override
    public TranslatedQuery getTranslatedQuery(String cqlQuery, CqlValueTransformerMap valueTransformerMap) throws CQLParseException, IOException {
        return this.getTranslatedQuery(CqlTranslatorImpl.parse(cqlQuery), valueTransformerMap);
    }

    @Override
    public TranslatedQuery getTranslatedQuery(String cqlQuery, CqlValueTransformerMap valueTransformerMap, Map<String, List<String>> options) throws CQLParseException, IOException {
        HashBiMap aliases = HashBiMap.create();
        return this.getTranslatedQuery(CqlTranslatorImpl.parse(cqlQuery), valueTransformerMap, options, (BiMap<String, String>)aliases, new HashMap<String, String>());
    }

    protected static CQLNode parse(String query) throws CQLParseException, IOException {
        return new CQLParser().parse(query);
    }

    private static TranslatedQuery translate(CQLNode node, CqlValueTransformerMap valueTranformerMap, Map<String, List<String>> cqlOptions, BiMap<String, String> aliases, Map<String, String> weights) throws CQLParseException {
        if (node instanceof CQLBooleanNode) {
            return CqlTranslatorImpl.doTranslate((CQLBooleanNode)node, valueTranformerMap, cqlOptions, aliases, weights);
        }
        if (node instanceof CQLTermNode) {
            return CqlTranslatorImpl.doTranslate((CQLTermNode)node, valueTranformerMap, cqlOptions, aliases, weights);
        }
        if (node instanceof CQLSortNode) {
            return CqlTranslatorImpl.doTranslate((CQLSortNode)node, valueTranformerMap, cqlOptions, aliases, weights);
        }
        throw new RuntimeException("error choice");
    }

    private static TranslatedQuery doTranslate(CQLSortNode node, CqlValueTransformerMap valueTranformerMap, Map<String, List<String>> cqlOptions, BiMap<String, String> aliases, Map<String, String> weights) throws CQLParseException {
        TranslatedQuery subQuery = CqlTranslatorImpl.translate(node.subtree, valueTranformerMap, cqlOptions, aliases, weights);
        Node query = subQuery.getQuery();
        String sortField = ((ModifierSet)node.getSortIndexes().get(0)).getBase();
        SortOperation.Mode sortMode = SortOperation.modifiersToMode(((ModifierSet)node.getSortIndexes().get(0)).getModifiers());
        QueryOptions options = new QueryOptions(new SortOperation(sortField, sortMode));
        return new TranslatedQuery(query, options);
    }

    private static TranslatedQuery doTranslate(CQLBooleanNode node, CqlValueTransformerMap valueTranformerMap, Map<String, List<String>> cqlOptions, BiMap<String, String> aliases, Map<String, String> weights) throws CQLParseException {
        TranslatedQuery left = CqlTranslatorImpl.translate(node.left, valueTranformerMap, cqlOptions, aliases, weights);
        TranslatedQuery right = CqlTranslatorImpl.translate(node.right, valueTranformerMap, cqlOptions, aliases, weights);
        QueryOptions options = right.getOptions();
        if (options != null) {
            options.merge(left.getOptions());
        }
        if (node instanceof CQLAndNode) {
            return new TranslatedQuery(new AndNode(left.getQuery(), right.getQuery()), options);
        }
        if (node instanceof CQLOrNode) {
            return new TranslatedQuery(new OrNode(left.getQuery(), right.getQuery()), options);
        }
        if (node instanceof CQLNotNode) {
            return new TranslatedQuery(new NotNode(left.getQuery(), right.getQuery()), options);
        }
        throw new RuntimeException("unknow boolean node");
    }

    private static TranslatedQuery doTranslate(CQLTermNode node, CqlValueTransformerMap valueTranformerMap, Map<String, List<String>> cqlOptions, BiMap<String, String> aliases, Map<String, String> weights) {
        String rel = node.getRelation().getBase();
        String index = node.getIndex().toLowerCase();
        Vector modifiers = node.getRelation().getModifiers();
        UnaryFunction<String, String> valueTransformer = valueTranformerMap.transformerFor(index);
        String term = (String)valueTransformer.evaluate((Object)node.getTerm());
        if (!index.equals("")) {
            if (modifiers.size() > 0) {
                rel = ((Modifier)modifiers.firstElement()).getType();
            }
            if (Relations.contains(rel)) {
                return CqlTranslatorImpl.buildTerm(cqlOptions, rel, index, term, aliases, weights);
            }
            throw new RuntimeException("unknow relation: " + rel);
        }
        throw new RuntimeException("invalid field: " + index);
    }

    private static TranslatedQuery buildTerm(Map<String, List<String>> cqlOptions, String rel, String index, String term, BiMap<String, String> aliases, Map<String, String> weights) {
        return new TranslatedQuery(new TermNode(index, Relations.get(rel), term, cqlOptions, aliases, weights), new QueryOptions());
    }
}

