 DROP SCHEMA IF EXISTS SHADOW CASCADE;
 CREATE SCHEMA shadow;
 ALTER SCHEMA shadow OWNER TO dnet;
 CREATE TABLE shadow.computation (  id text NOT NULL,  title text,  shortlabel text,  parent text DEFAULT (-1),  observedpropertyids text[] DEFAULT ARRAY[]::text[],  observationcollectionids text[] DEFAULT ARRAY[]::text[],  instrumenttypeids text[] DEFAULT ARRAY[]::text[],  computationtypeids text[] DEFAULT ARRAY[]::text[],  platformids text[] DEFAULT ARRAY[]::text[],  projectids text[] DEFAULT ARRAY[]::text[],  description text,  startdate timestamp with time zone,  enddate timestamp with time zone );
 ALTER TABLE shadow.computation OWNER TO dnet;
 COMMENT ON TABLE shadow.computation IS 'done';
 CREATE TABLE shadow.computationtype (  id text NOT NULL,  title text,  shortlabel text,  parent text DEFAULT (-1),  observedpropertyids text[] DEFAULT ARRAY[]::text[],  observationcollectionids text[] DEFAULT ARRAY[]::text[],  definition text,  startdate timestamp with time zone,  enddate timestamp with time zone );
 ALTER TABLE shadow.computationtype OWNER TO dnet;
 COMMENT ON TABLE shadow.computationtype IS 'done';
 CREATE TABLE shadow.dimensionalityinstance (  id text NOT NULL,  title text,  shortlabel text,  parent text DEFAULT (-1),  instrumentids text[] DEFAULT ARRAY[]::text[],  computationids text[] DEFAULT ARRAY[]::text[],  observedpropertyids text[] DEFAULT ARRAY[]::text[],  definition text,  startdate timestamp with time zone,  enddate timestamp with time zone );
 ALTER TABLE shadow.dimensionalityinstance OWNER TO dnet;
 COMMENT ON TABLE shadow.dimensionalityinstance IS 'done';
 CREATE TABLE shadow.dimensionalitytimeline (  id text NOT NULL,  title text,  shortlabel text,  parent text DEFAULT (-1),  instrumentids text[] DEFAULT ARRAY[]::text[],  computationids text[] DEFAULT ARRAY[]::text[],  observedpropertyids text[] DEFAULT ARRAY[]::text[],  definition text,  startdate timestamp with time zone,  enddate timestamp with time zone );
 ALTER TABLE shadow.dimensionalitytimeline OWNER TO dnet;
 COMMENT ON TABLE shadow.dimensionalitytimeline IS 'done';
 CREATE TABLE shadow.instrument (  id text NOT NULL,  title text,  shortlabel text,  parent text DEFAULT (-1),  observedpropertyids text[] DEFAULT ARRAY[]::text[],  observationcollectionids text[] DEFAULT ARRAY[]::text[],  instrumenttypeids text[] DEFAULT ARRAY[]::text[],  computationtypeids text[] DEFAULT ARRAY[]::text[],  platformids text[] DEFAULT ARRAY[]::text[],  projectids text[] DEFAULT ARRAY[]::text[],  description text,  startdate timestamp with time zone,  enddate timestamp with time zone );
 ALTER TABLE shadow.instrument OWNER TO dnet;
 COMMENT ON TABLE shadow.instrument IS 'done';
 CREATE TABLE shadow.instrumenttype (  id text NOT NULL,  title text,  shortlabel text,  parent text DEFAULT (-1),  observedpropertyids text[] DEFAULT ARRAY[]::text[],  observationcollectionids text[] DEFAULT ARRAY[]::text[],  definition text,  startdate timestamp with time zone,  enddate timestamp with time zone );
 ALTER TABLE shadow.instrumenttype OWNER TO dnet;
 COMMENT ON TABLE shadow.instrumenttype IS 'done';
 CREATE TABLE shadow.location (  id text NOT NULL,  location public.geography,  srsname text );
 ALTER TABLE shadow.location OWNER TO dnet;
 COMMENT ON TABLE shadow.location IS 'temporary location table';
 CREATE TABLE shadow.measurand (  id text NOT NULL,  title text,  shortlabel text,  parent text DEFAULT (-1),  instrumentids text[] DEFAULT ARRAY[]::text[],  computationids text[] DEFAULT ARRAY[]::text[],  observationcollectionids text[] DEFAULT ARRAY[]::text[],  definition text,  startdate timestamp with time zone,  enddate timestamp with time zone );
 ALTER TABLE shadow.measurand OWNER TO dnet;
 COMMENT ON TABLE shadow.measurand IS 'done';
 CREATE TABLE shadow.observation (  id text NOT NULL,  startdate timestamp with time zone NOT NULL,  enddate timestamp with time zone,  seconds integer, results text[] DEFAULT ARRAY[]::text[],  resulttypes text[] DEFAULT ARRAY[]::text[],  temporalresolution interval );
 ALTER TABLE shadow.observation OWNER TO dnet;
 COMMENT ON TABLE shadow.observation IS 'The "view" on observations - done!';
 CREATE TABLE shadow.observation_computation (  observation text NOT NULL,  computation text NOT NULL );
 ALTER TABLE shadow.observation_computation OWNER TO dnet;
 CREATE TABLE shadow.observation_dimensionalityinstance (  observation text NOT NULL,  dimensionalityinstance text NOT NULL );
 ALTER TABLE shadow.observation_dimensionalityinstance OWNER TO dnet;
 CREATE TABLE shadow.observation_dimensionalitytimeline (  observation text NOT NULL,  dimensionalitytimeline text NOT NULL );
 ALTER TABLE shadow.observation_dimensionalitytimeline OWNER TO dnet;
 CREATE TABLE shadow.observation_instrument (  observation text NOT NULL,  instrument text NOT NULL );
 ALTER TABLE shadow.observation_instrument OWNER TO dnet;
 CREATE TABLE shadow.observation_location (  observation text,  location text );
 ALTER TABLE shadow.observation_location OWNER TO dnet;
 COMMENT ON TABLE shadow.observation_location IS 'done';
 CREATE TABLE shadow.observation_observationcollection (  observation text NOT NULL,  observationcollection text NOT NULL );
 ALTER TABLE shadow.observation_observationcollection OWNER TO dnet;
 CREATE TABLE shadow.observation_observedproperty (  observation text NOT NULL,  observedproperty text NOT NULL );
 ALTER TABLE shadow.observation_observedproperty OWNER TO dnet;
 CREATE TABLE shadow.observation_platform (  observation text NOT NULL,  platform text NOT NULL );
 ALTER TABLE shadow.observation_platform OWNER TO dnet;
 CREATE TABLE shadow.observation_project (  observation text NOT NULL,  project text NOT NULL );
 ALTER TABLE shadow.observation_project OWNER TO dnet;
 CREATE TABLE shadow.observation_regionofspace (  observation text NOT NULL,  regionofspace text NOT NULL );
 ALTER TABLE shadow.observation_regionofspace OWNER TO dnet;
 CREATE TABLE shadow.observation_year (  observation text NOT NULL,  year text NOT NULL );
 ALTER TABLE shadow.observation_year OWNER TO dnet;
 CREATE TABLE shadow.observationcollection (  id text NOT NULL,  title text,  shortlabel text,  parent text DEFAULT (-1),  instrumentids text[] DEFAULT ARRAY[]::text[],  computationids text[] DEFAULT ARRAY[]::text[],  observedpropertyids text[] DEFAULT ARRAY[]::text[],  dimensionalitytimelineids text[] DEFAULT ARRAY[]::text[],  dimensionalityinstanceids text[] DEFAULT ARRAY[]::text[],  description text,  regionofspaceids text[] DEFAULT ARRAY[]::text[],  startdate timestamp with time zone,  enddate timestamp with time zone );
 ALTER TABLE shadow.observationcollection OWNER TO dnet;
 COMMENT ON TABLE shadow.observationcollection IS 'done';
 CREATE TABLE shadow.observedproperty (  id text NOT NULL,  title text,  shortlabel text,  parent text DEFAULT (-1),  instrumentids text[] DEFAULT ARRAY[]::text[],  computationids text[] DEFAULT ARRAY[]::text[],  observationcollectionids text[] DEFAULT ARRAY[]::text[],  phenomenonids text[] DEFAULT ARRAY[]::text[],  measurandids text[] DEFAULT ARRAY[]::text[],  qualifierids text[] DEFAULT ARRAY[]::text[],  definition text,  startdate timestamp with time zone,  enddate timestamp with time zone );
 ALTER TABLE shadow.observedproperty OWNER TO dnet;
 COMMENT ON TABLE shadow.observedproperty IS 'done';
 CREATE TABLE shadow.phenomenon (  id text NOT NULL,  title text,  shortlabel text,  parent text DEFAULT (-1),  instrumentids text[] DEFAULT ARRAY[]::text[],  computationids text[] DEFAULT ARRAY[]::text[],  observationcollectionids text[] DEFAULT ARRAY[]::text[],  definition text,  startdate timestamp with time zone,  enddate timestamp with time zone );
 ALTER TABLE shadow.phenomenon OWNER TO dnet;
 CREATE TABLE shadow.platform (  id text NOT NULL,  title text,  shortlabel text,  parent text DEFAULT (-1),  observedpropertyids text[] DEFAULT ARRAY[]::text[],  observationcollectionids text[] DEFAULT ARRAY[]::text[],  type text,  description text,  startdate timestamp with time zone,  enddate timestamp with time zone );
 ALTER TABLE shadow.platform OWNER TO dnet;
 COMMENT ON TABLE shadow.platform IS 'done';
 CREATE TABLE shadow.project (  id text NOT NULL,  title text,  shortlabel text,  parent text DEFAULT (-1),  observedpropertyids text[] DEFAULT ARRAY[]::text[],  observationcollectionids text[] DEFAULT ARRAY[]::text[],  description text,  startdate timestamp with time zone,  enddate timestamp with time zone );
 ALTER TABLE shadow.project OWNER TO dnet;
 COMMENT ON TABLE shadow.project IS 'done';
 CREATE TABLE shadow.qualifier (  id text NOT NULL,  title text,  shortlabel text,  parent text DEFAULT (-1),  instrumentids text[] DEFAULT ARRAY[]::text[],  computationids text[] DEFAULT ARRAY[]::text[],  observationcollectionids text[] DEFAULT ARRAY[]::text[],  definition text,  startdate timestamp with time zone,  enddate timestamp with time zone );
 ALTER TABLE shadow.qualifier OWNER TO dnet;
 CREATE TABLE shadow.regionofspace (  id text NOT NULL,  title text,  shortlabel text,  parent text DEFAULT (-1),  instrumentids text[] DEFAULT ARRAY[]::text[],  computationids text[] DEFAULT ARRAY[]::text[],  observedpropertyids text[] DEFAULT ARRAY[]::text[],  definition text,  startdate timestamp with time zone,  enddate timestamp with time zone );
 ALTER TABLE shadow.regionofspace OWNER TO dnet;
 COMMENT ON TABLE shadow.regionofspace IS 'done';
 CREATE TABLE shadow.resource (  id text,  name text,  shortname text,  description text );
 ALTER TABLE shadow.resource OWNER TO dnet;
 COMMENT ON TABLE shadow.resource IS 'done';
 CREATE TABLE shadow.result_observation (  result text,  observation text );
 ALTER TABLE shadow.result_observation OWNER TO dnet;
 ALTER TABLE ONLY shadow.computation  ADD CONSTRAINT computation_pkey PRIMARY KEY (id);
 ALTER TABLE ONLY shadow.computationtype  ADD CONSTRAINT computationtype_pkey PRIMARY KEY (id);
 ALTER TABLE ONLY shadow.dimensionalityinstance  ADD CONSTRAINT dimentionalityinstance_pkey PRIMARY KEY (id);
 ALTER TABLE ONLY shadow.dimensionalitytimeline  ADD CONSTRAINT dimentionalitytimeline_pkey PRIMARY KEY (id);
 ALTER TABLE ONLY shadow.instrument  ADD CONSTRAINT instrument_pkey PRIMARY KEY (id);
 ALTER TABLE ONLY shadow.instrumenttype  ADD CONSTRAINT instrumenttype_pkey PRIMARY KEY (id);
 ALTER TABLE ONLY shadow.location  ADD CONSTRAINT location_pkey PRIMARY KEY (id);
 ALTER TABLE ONLY shadow.measurand  ADD CONSTRAINT measurand_pkey PRIMARY KEY (id);
 ALTER TABLE ONLY shadow.observation_computation  ADD CONSTRAINT observation_computation_pkey PRIMARY KEY (observation, computation);
 ALTER TABLE ONLY shadow.observation_dimensionalityinstance  ADD CONSTRAINT observation_dimensionalityinstance_pkey PRIMARY KEY (observation, dimensionalityinstance);
 ALTER TABLE ONLY shadow.observation_dimensionalitytimeline  ADD CONSTRAINT observation_dimensionalitytimeline_pkey PRIMARY KEY (observation, dimensionalitytimeline);
 ALTER TABLE ONLY shadow.observation_instrument  ADD CONSTRAINT observation_instrument_pkey PRIMARY KEY (observation, instrument);
 ALTER TABLE ONLY shadow.observation_observationcollection  ADD CONSTRAINT observation_observationcollection_pkey PRIMARY KEY (observation, observationcollection);
 ALTER TABLE ONLY shadow.observation_observedproperty  ADD CONSTRAINT observation_observedproperty_pkey PRIMARY KEY (observation, observedproperty);
 ALTER TABLE ONLY shadow.observation  ADD CONSTRAINT observation_pkey PRIMARY KEY (id);
 ALTER TABLE ONLY shadow.observation_platform  ADD CONSTRAINT observation_platform_pkey PRIMARY KEY (observation, platform);
 ALTER TABLE ONLY shadow.observation_project  ADD CONSTRAINT observation_project_pkey PRIMARY KEY (observation, project);
 ALTER TABLE ONLY shadow.observation_regionofspace  ADD CONSTRAINT observation_regionsofspace_pkey PRIMARY KEY (observation, regionofspace);
 ALTER TABLE ONLY shadow.observation_year  ADD CONSTRAINT observation_year_pkey PRIMARY KEY (observation, year);
 ALTER TABLE ONLY shadow.observationcollection  ADD CONSTRAINT observationcollection_pkey PRIMARY KEY (id);
 ALTER TABLE ONLY shadow.observedproperty  ADD CONSTRAINT observedproperty_pkey PRIMARY KEY (id);
 ALTER TABLE ONLY shadow.phenomenon  ADD CONSTRAINT phenomenon_pkey PRIMARY KEY (id);
 ALTER TABLE ONLY shadow.platform  ADD CONSTRAINT platform_pkey PRIMARY KEY (id);
 ALTER TABLE ONLY shadow.project  ADD CONSTRAINT project_pkey PRIMARY KEY (id);
 ALTER TABLE ONLY shadow.qualifier  ADD CONSTRAINT qualifier_pkey PRIMARY KEY (id);
 ALTER TABLE ONLY shadow.regionofspace  ADD CONSTRAINT regionofspace_pkey PRIMARY KEY (id);
 ALTER TABLE ONLY shadow.observation_computation  ADD CONSTRAINT observation_computation_computation FOREIGN KEY (computation) REFERENCES shadow.computation(id) on update cascade on delete cascade;
 ALTER TABLE ONLY shadow.observation_computation  ADD CONSTRAINT observation_computation_observation FOREIGN KEY (observation) REFERENCES shadow.observation(id) on update cascade on delete cascade;
 ALTER TABLE ONLY shadow.observation_dimensionalityinstance  ADD CONSTRAINT observation_dimensionalityinstance_dimensionalityinstance FOREIGN KEY (dimensionalityinstance) REFERENCES shadow.dimensionalityinstance(id) on update cascade on delete cascade;
 ALTER TABLE ONLY shadow.observation_dimensionalityinstance  ADD CONSTRAINT observation_dimensionalityinstance_observation FOREIGN KEY (observation) REFERENCES shadow.observation(id) on update cascade on delete cascade;
 ALTER TABLE ONLY shadow.observation_dimensionalitytimeline  ADD CONSTRAINT observation_dimensionalitytimeline_dimensionalitytimeline FOREIGN KEY (dimensionalitytimeline) REFERENCES shadow.dimensionalitytimeline(id) on update cascade on delete cascade;
 ALTER TABLE ONLY shadow.observation_dimensionalitytimeline  ADD CONSTRAINT observation_dimensionalitytimeline_observation FOREIGN KEY (observation) REFERENCES shadow.observation(id) on update cascade on delete cascade;
 ALTER TABLE ONLY shadow.observation_instrument  ADD CONSTRAINT observation_instrument_instrument FOREIGN KEY (instrument) REFERENCES shadow.instrument(id) on update cascade on delete cascade;
 ALTER TABLE ONLY shadow.observation_instrument  ADD CONSTRAINT observation_instrument_observation FOREIGN KEY (observation) REFERENCES shadow.observation(id) on update cascade on delete cascade;
 ALTER TABLE ONLY shadow.observation_observationcollection  ADD CONSTRAINT observation_observationcollection_observation FOREIGN KEY (observation) REFERENCES shadow.observation(id) on update cascade on delete cascade;
 ALTER TABLE ONLY shadow.observation_observationcollection  ADD CONSTRAINT observation_observationcollection_observationcollection FOREIGN KEY (observationcollection) REFERENCES shadow.observationcollection(id) on update cascade on delete cascade;
 ALTER TABLE ONLY shadow.observation_observedproperty  ADD CONSTRAINT observation_observedproperty_observation FOREIGN KEY (observation) REFERENCES shadow.observation(id) on update cascade on delete cascade;
 ALTER TABLE ONLY shadow.observation_platform  ADD CONSTRAINT observation_platform_observation FOREIGN KEY (observation) REFERENCES shadow.observation(id) on update cascade on delete cascade;
 ALTER TABLE ONLY shadow.observation_platform  ADD CONSTRAINT observation_platform_platform FOREIGN KEY (platform) REFERENCES shadow.platform(id) on update cascade on delete cascade;
 ALTER TABLE ONLY shadow.observation_project  ADD CONSTRAINT observation_project_observation FOREIGN KEY (observation) REFERENCES shadow.observation(id) on update cascade on delete cascade;
 ALTER TABLE ONLY shadow.observation_project  ADD CONSTRAINT observation_project_project FOREIGN KEY (project) REFERENCES shadow.project(id) on update cascade on delete cascade;
 ALTER TABLE ONLY shadow.observation_regionofspace  ADD CONSTRAINT observation_regionofspace_observation FOREIGN KEY (observation) REFERENCES shadow.observation(id) on update cascade on delete cascade;
 ALTER TABLE ONLY shadow.observation_regionofspace  ADD CONSTRAINT observation_regionofspace_regionofspace FOREIGN KEY (regionofspace) REFERENCES shadow.regionofspace(id) on update cascade on delete cascade;
 ALTER TABLE ONLY shadow.observation_year  ADD CONSTRAINT observation_year_observation FOREIGN KEY (observation) REFERENCES shadow.observation(id) on update cascade on delete cascade;
 CREATE VIEW shadow.observation_procedure AS SELECT id AS observation, procedure AS procedure FROM public.observation;
 ALTER TABLE shadow.observation_procedure OWNER TO dnet;