-- functions
create or replace function yearsdifference (startdate timestamp with time zone, enddate timestamp with time zone) returns int[] as $$ DECLARE startyear int; yearsdiff int; i int; years int[]; BEGIN startyear := extract('year' from startdate); yearsdiff := extract('year' from (enddate - startdate)); years = array_fill(0, array[yearsdiff + 1]); for i in 1 .. array_length(years, 1) loop years[i] := years[i] + startyear + (i-1); end loop; return years; END; $$ language plpgsql;
create or replace function measurement_count (fromdate timestamp with time zone, todate timestamp with time zone, resolution interval, fromsecs int, tosecs int) returns real as $$ DECLARE iterator timestamp with time zone; i int; measurements real; secsofday int; BEGIN measurements := 0; iterator := fromdate; WHILE iterator<=todate loop secsofday := extract('epoch' from iterator)::integer % 86400 ;	if(fromsecs=tosecs) then if(secsofday = fromsecs) then measurements := measurements + 1; end if; elseif(fromsecs<tosecs) then if( (secsofday >= fromsecs) and (secsofday <= tosecs) ) then measurements := measurements + 1; end if; else if( (secsofday <= tosecs) or (secsofday >= fromsecs) ) then measurements := measurements + 1; end if; end if; iterator := iterator + resolution; end loop; return measurements; END; $$ language 'plpgsql'; 
create or replace function measurement_count_with_timeperiods (startdate timestamp with time zone, enddate timestamp with time zone, resolution interval, tpcount int, tpstartdate timestamp with time zone[], tpenddate timestamp with time zone[], tpfromsecs integer[], tptosecs integer[]) returns real as $$ DECLARE fromdate timestamp with time zone; todate timestamp with time zone; iterator timestamp with time zone; i int; measurements int; BEGIN if (startdate = enddate) then return 1; elsif (resolution is null) then return 0; else measurements := 0; if(enddate is null) then enddate:=now(); 	end if; if(tpcount>0) then for i in 1 .. tpcount loop if(startdate<tpstartdate[i]) then fromdate:=tpstartdate[i]; else fromdate:=startdate; end if; if(enddate>tpenddate[i]) then todate:=tpenddate[i]; else todate:=enddate; end if; measurements := measurement_count(fromdate, todate, resolution, tpfromsecs[i], tptosecs[i]); end loop; else measurements := measurement_count(startdate, enddate, resolution, 0, 86400); end if; end if; return measurements; END; $$ language 'plpgsql';

-- result-observation
drop table shadow.result_observation;
create table shadow.result_observation as with recursive result_observation (result, observation) as (select o.result, o.id from observation o union select rs.segment, ro.observation from result_segment rs join result_observation ro on rs.parent = ro.result) select * from result_observation ro;

create index result_observation_observation on shadow.result_observation(observation);
create index result_observation_result on shadow.result_observation(result);

-- resources
insert into shadow.resource (id, name, shortname, description) select id, name, null, description from public.instrument;
insert into shadow.resource (id, name, shortname, description) select a.process, i.name, null, p.description from public.acquisition a join public.process p on a.process=p.id join public.acquisition_instrument aqi on aqi.acquisition=a.process join public.instrument i on aqi.instrument=i.id;
insert into shadow.resource (id, name, shortname, description) select p.id, i.name || ' - ' || c.name, null, p.description from public.compositeprocess cp join process p on p.id=cp.process join compositeprocess_acquisition cpa on cpa.compositeprocess=cp.process join  public.acquisition a on a.process=cpa.acquisition join public.acquisition_instrument aqi on aqi.acquisition=a.process join public.instrument i on aqi.instrument=i.id join compositeprocess_computation cpc on cpc.compositeprocess=cp.process join computation c on c.process=cpc.computation;
insert into shadow.resource (id, name, shortname, description) select process, name, null, description from public.computation c join public.process p on c.process=p.id;
insert into shadow.resource (id, name, shortname, description) select id, name, null, description from public.platform;
insert into shadow.resource (id, name, shortname, description) select id, name, null, description from public.observationcollection;
insert into shadow.resource (id, name, shortname, description) select id, name, null, description from public.project;
insert into shadow.resource (id, name, shortname, description) select id, title, shortlabel, definition from public.regionofspace;
insert into shadow.resource (id, name, shortname, description) select id, title, shortlabel, definition from public.dimensionality_timeline;
insert into shadow.resource (id, name, shortname, description) select id, title, shortlabel, definition from public.dimensionality_instance;
insert into shadow.resource (id, name, shortname, description) select id, title, shortlabel, definition from public.resultdataformat;

-- phenomenon
insert into shadow.phenomenon (id, title, shortlabel, parent, definition) select id, title, shortlabel, (case when parent is not null then parent else '-1' end), definition from public.phenomenon;
update shadow.phenomenon vp set instrumentids = (select array_agg(distinct aqi.instrument) from public.observation o join public.acquisition_instrument aqi on o.procedure=aqi.acquisition join public.simpleobservedproperty sop on o.observedproperty=sop.property join observedproperty_phenomenon opm on opm.observedproperty = sop.property where opm.phenomenon=vp.id);
update shadow.phenomenon vp set instrumentids = instrumentids || (select array_agg(distinct aqi.instrument) from public.observation o join public.acquisition_instrument aqi on o.procedure=aqi.acquisition join public.compositeproperty_subproperties cops on cops.composite=o.observedproperty join public.simpleobservedproperty sop on o.observedproperty=sop.property join observedproperty_phenomenon opm on opm.observedproperty = sop.property where opm.phenomenon=vp.id);
update shadow.phenomenon vp set instrumentids = instrumentids || (select array_agg(distinct aqi.instrument) from public.observation o join public.compositeprocess_acquisition cpa on cpa.compositeprocess=o.procedure join public.acquisition aq on aq.process=cpa.acquisition join public.acquisition_instrument aqi on aqi.acquisition = aq.process join public.simpleobservedproperty sop on o.observedproperty=sop.property join observedproperty_phenomenon opm on opm.observedproperty = sop.property where opm.phenomenon=vp.id);
update shadow.phenomenon vp set instrumentids = instrumentids || (select array_agg(distinct aqi.instrument) from public.observation o join public.compositeprocess_acquisition cpa on cpa.compositeprocess=o.procedure join public.acquisition aq on aq.process=cpa.acquisition join public.acquisition_instrument aqi on aqi.acquisition = aq.process join public.compositeproperty_subproperties cops on cops.composite=o.observedproperty join public.simpleobservedproperty sop on cops.simpleproperty=sop.property join observedproperty_phenomenon opm on opm.observedproperty = sop.property where opm.phenomenon=vp.id);
update shadow.phenomenon vp set instrumentids = ARRAY[]::text[] where instrumentids is null;
update shadow.phenomenon vp set computationids = (select array_agg(distinct c.process) from public.observation o join public.computation c on o.procedure=c.process  join observedproperty_phenomenon opm on opm.observedproperty= o.observedproperty where opm.phenomenon=vp.id);
update shadow.phenomenon vp set computationids = computationids || (select array_agg(distinct c.process) from public.observation o join public.computation c on o.procedure=c.process join public.compositeproperty_subproperties cops on cops.composite=o.observedproperty join public.simpleobservedproperty sop on cops.simpleproperty=sop.property join observedproperty_phenomenon opm on opm.observedproperty = sop.property where opm.phenomenon=vp.id);
update shadow.phenomenon vp set computationids = computationids || (select array_agg(distinct cpc.computation) from public.observation o join public.compositeprocess_computation cpc on cpc.compositeprocess=o.procedure join public.simpleobservedproperty sop on o.observedproperty=sop.property join observedproperty_phenomenon opm on opm.observedproperty = sop.property where opm.phenomenon=vp.id);
update shadow.phenomenon vp set computationids = computationids || (select array_agg(distinct cpc.computation) from public.observation o join public.compositeprocess_computation cpc on cpc.compositeprocess=o.procedure join public.compositeproperty_subproperties cops on cops.composite=o.observedproperty join public.simpleobservedproperty sop on cops.simpleproperty=sop.property join observedproperty_phenomenon opm on opm.observedproperty = sop.property where opm.phenomenon=vp.id);
update shadow.phenomenon vp set computationids = ARRAY[]::text[] where computationids is null;

-- measurand
insert into shadow.measurand (id, title, shortlabel, parent, definition) select id, title, shortlabel, (case when parent is not null then parent else '-1' end), definition from public.measurand;
update shadow.measurand vm set instrumentids = (select array_agg(distinct aqi.instrument) from public.observation o join public.acquisition_instrument aqi on o.procedure=aqi.acquisition join public.simpleobservedproperty sop on o.observedproperty=sop.property join observedproperty_measurand opm on opm.observedproperty = sop.property where opm.measurand=vm.id);
update shadow.measurand vm set instrumentids = instrumentids || (select array_agg(distinct aqi.instrument) from public.observation o join public.acquisition_instrument aqi on o.procedure=aqi.acquisition join public.compositeproperty_subproperties cops on cops.composite=o.observedproperty join public.simpleobservedproperty sop on o.observedproperty=sop.property join observedproperty_measurand opm on opm.observedproperty = sop.property where opm.measurand=vm.id);
update shadow.measurand vm set instrumentids = instrumentids || (select array_agg(distinct aqi.instrument) from public.observation o join public.compositeprocess_acquisition cpa on cpa.compositeprocess=o.procedure join public.acquisition aq on aq.process=cpa.acquisition join public.acquisition_instrument aqi on aqi.acquisition = aq.process join public.simpleobservedproperty sop on o.observedproperty=sop.property join observedproperty_measurand opm on opm.observedproperty = sop.property where opm.measurand=vm.id);
update shadow.measurand vm set instrumentids = instrumentids || (select array_agg(distinct aqi.instrument) from public.observation o join public.compositeprocess_acquisition cpa on cpa.compositeprocess=o.procedure join public.acquisition aq on aq.process=cpa.acquisition join public.acquisition_instrument aqi on aqi.acquisition = aq.process join public.compositeproperty_subproperties cops on cops.composite=o.observedproperty join public.simpleobservedproperty sop on cops.simpleproperty=sop.property join observedproperty_measurand opm on opm.observedproperty = sop.property where opm.measurand=vm.id);
update shadow.measurand vm set instrumentids = ARRAY[]::text[] where instrumentids is null;
update shadow.measurand vm set computationids = (select array_agg(distinct c.process) from public.observation o join public.computation c on o.procedure=c.process  join observedproperty_measurand opm on opm.observedproperty= o.observedproperty where opm.measurand=vm.id);
update shadow.measurand vm set computationids = computationids || (select array_agg(distinct c.process) from public.observation o join public.computation c on o.procedure=c.process join public.compositeproperty_subproperties cops on cops.composite=o.observedproperty join public.simpleobservedproperty sop on cops.simpleproperty=sop.property join observedproperty_measurand opm on opm.observedproperty = sop.property where opm.measurand=vm.id);
update shadow.measurand vm set computationids = computationids || (select array_agg(distinct cpc.computation) from public.observation o join public.compositeprocess_computation cpc on cpc.compositeprocess=o.procedure join public.simpleobservedproperty sop on o.observedproperty=sop.property join observedproperty_measurand opm on opm.observedproperty = sop.property where opm.measurand=vm.id);
update shadow.measurand vm set computationids = computationids || (select array_agg(distinct cpc.computation) from public.observation o join public.compositeprocess_computation cpc on cpc.compositeprocess=o.procedure join public.compositeproperty_subproperties cops on cops.composite=o.observedproperty join public.simpleobservedproperty sop on cops.simpleproperty=sop.property join observedproperty_measurand opm on opm.observedproperty = sop.property where opm.measurand=vm.id);
update shadow.measurand vm set computationids = ARRAY[]::text[] where computationids is null;

-- location
insert into shadow.location (id, location, srsname) select id, geometry, srsname from public.location;
insert into shadow.observation_location (observation, location)  select o.id, l.id from observation o join acquisition_platform aqp on aqp.acquisition=o.procedure join platform p on p.id=aqp.platform join location l on p.location=l.id;
insert into shadow.observation_location (observation, location) select o.id, l.id from observation o join public.compositeprocess cpc on cpc.process=o.procedure join public.compositeprocess_acquisition cpa on cpa.compositeprocess=cpc.process  join acquisition_platform aqp on aqp.acquisition=cpa.acquisition join platform p on p.id=aqp.platform join location l on p.location=l.id;

-- qualifier
insert into shadow.qualifier (id, title, shortlabel, parent, definition) select id, title, shortlabel, (case when parent is not null then parent else '-1' end), definition from public.qualifier;
update shadow.qualifier vq set instrumentids = (select array_agg(distinct aqi.instrument) from public.observation o join public.acquisition_instrument aqi on o.procedure=aqi.acquisition join public.simpleobservedproperty sop on o.observedproperty=sop.property join observedproperty_qualifier opm on opm.observedproperty = sop.property where opm.qualifier=vq.id);
update shadow.qualifier vq set instrumentids = instrumentids || (select array_agg(distinct aqi.instrument) from public.observation o join public.acquisition_instrument aqi on o.procedure=aqi.acquisition join public.compositeproperty_subproperties cops on cops.composite=o.observedproperty join public.simpleobservedproperty sop on o.observedproperty=sop.property join observedproperty_qualifier opm on opm.observedproperty = sop.property where opm.qualifier=vq.id);
update shadow.qualifier vq set instrumentids = instrumentids || (select array_agg(distinct aqi.instrument) from public.observation o join public.compositeprocess_acquisition cpa on cpa.compositeprocess=o.procedure join public.acquisition aq on aq.process=cpa.acquisition join public.acquisition_instrument aqi on aqi.acquisition = aq.process join public.simpleobservedproperty sop on o.observedproperty=sop.property join observedproperty_qualifier opm on opm.observedproperty = sop.property where opm.qualifier=vq.id);
update shadow.qualifier vq set instrumentids = instrumentids || (select array_agg(distinct aqi.instrument) from public.observation o join public.compositeprocess_acquisition cpa on cpa.compositeprocess=o.procedure join public.acquisition aq on aq.process=cpa.acquisition join public.acquisition_instrument aqi on aqi.acquisition = aq.process join public.compositeproperty_subproperties cops on cops.composite=o.observedproperty join public.simpleobservedproperty sop on cops.simpleproperty=sop.property join observedproperty_qualifier opm on opm.observedproperty = sop.property where opm.qualifier=vq.id);
update shadow.qualifier vq set instrumentids = ARRAY[]::text[] where instrumentids is null;
update shadow.qualifier vq set computationids = (select array_agg(distinct c.process) from public.observation o join public.computation c on o.procedure=c.process  join observedproperty_qualifier opm on opm.observedproperty= o.observedproperty where opm.qualifier=vq.id);
update shadow.qualifier vq set computationids = computationids || (select array_agg(distinct c.process) from public.observation o join public.computation c on o.procedure=c.process join public.compositeproperty_subproperties cops on cops.composite=o.observedproperty join public.simpleobservedproperty sop on cops.simpleproperty=sop.property join observedproperty_qualifier opm on opm.observedproperty = sop.property where opm.qualifier=vq.id);
update shadow.qualifier vq set computationids = computationids || (select array_agg(distinct cpc.computation) from public.observation o join public.compositeprocess_computation cpc on cpc.compositeprocess=o.procedure join public.simpleobservedproperty sop on o.observedproperty=sop.property join observedproperty_qualifier opm on opm.observedproperty = sop.property where opm.qualifier=vq.id);
update shadow.qualifier vq set computationids = computationids || (select array_agg(distinct cpc.computation) from public.observation o join public.compositeprocess_computation cpc on cpc.compositeprocess=o.procedure join public.compositeproperty_subproperties cops on cops.composite=o.observedproperty join public.simpleobservedproperty sop on cops.simpleproperty=sop.property join observedproperty_qualifier opm on opm.observedproperty = sop.property where opm.qualifier=vq.id);
update shadow.qualifier vm set computationids = ARRAY[]::text[] where computationids is null;

-- observedproperty
insert into shadow.observedproperty (id, title, shortlabel, parent, definition) select id, title, shortlabel, (case when parent is not null then parent else '-1' end), definition from public.simpleobservedproperty join public.observedproperty on id=property;
update shadow.observedproperty set measurandids = (select array_agg(measurand) from public.observedproperty_measurand join public.simpleobservedproperty on observedproperty=property where observedproperty=id);
update shadow.observedproperty set measurandids = array[]::text[] where measurandids is null;
update shadow.observedproperty set phenomenonids = (select array_agg(phenomenon) from public.observedproperty_phenomenon join public.simpleobservedproperty on observedproperty=property where observedproperty=id);
update shadow.observedproperty set phenomenonids = array[]::text[] where phenomenonids is null;
update shadow.observedproperty set qualifierids = (select array_agg(qualifier) from public.observedproperty_qualifier join public.simpleobservedproperty on observedproperty=property where observedproperty=id);
update shadow.observedproperty set qualifierids = array[]::text[] where qualifierids is null;
update shadow.observedproperty vop set computationids = (select array_agg(distinct c.process) from public.observation o join public.computation c on o.procedure=c.process join public.simpleobservedproperty sop on o.observedproperty=sop.property where sop.property=vop.id);
update shadow.observedproperty vop set computationids = computationids || (select array_agg(distinct c.process) from public.observation o join public.computation c on o.procedure=c.process join public.compositeproperty_subproperties cops on cops.composite=o.observedproperty join public.simpleobservedproperty sop on cops.simpleproperty=sop.property where sop.property=vop.id);
update shadow.observedproperty vop set computationids = computationids || (select array_agg(distinct cpc.computation) from public.observation o join public.compositeprocess_computation cpc on cpc.compositeprocess=o.procedure join public.simpleobservedproperty sop on o.observedproperty=sop.property where sop.property=vop.id);
update shadow.observedproperty vop set computationids = computationids || (select array_agg(distinct cpc.computation) from public.observation o join public.compositeprocess_computation cpc on cpc.compositeprocess=o.procedure join public.compositeproperty_subproperties cops on cops.composite=o.observedproperty join public.simpleobservedproperty sop on cops.simpleproperty=sop.property  where sop.property=vop.id);
update shadow.observedproperty vop set computationids = ARRAY[]::text[] where computationids is null;
update shadow.observedproperty vop set instrumentids = (select array_agg(distinct aqi.instrument) from public.observation o join public.acquisition_instrument aqi on o.procedure=aqi.acquisition join public.simpleobservedproperty sop on o.observedproperty=sop.property where sop.property=vop.id);
update shadow.observedproperty vop set instrumentids = instrumentids || (select array_agg(distinct aqi.instrument) from public.observation o join public.acquisition_instrument aqi on o.procedure=aqi.acquisition join public.compositeproperty_subproperties cops on cops.composite=o.observedproperty join public.simpleobservedproperty sop on o.observedproperty=sop.property where sop.property=vop.id);
update shadow.observedproperty vop set instrumentids = instrumentids || (select array_agg(distinct aqi.instrument) from public.observation o join public.compositeprocess_acquisition cpa on cpa.compositeprocess=o.procedure join public.acquisition aq on aq.process=cpa.acquisition join public.acquisition_instrument aqi on aqi.acquisition = aq.process join public.simpleobservedproperty sop on o.observedproperty=sop.property where sop.property=vop.id);
update shadow.observedproperty vop set instrumentids = instrumentids || (select array_agg(distinct aqi.instrument) from public.observation o join public.compositeprocess_acquisition cpa on cpa.compositeprocess=o.procedure join public.acquisition aq on aq.process=cpa.acquisition join public.acquisition_instrument aqi on aqi.acquisition = aq.process join public.compositeproperty_subproperties cops on cops.composite=o.observedproperty join public.simpleobservedproperty sop on cops.simpleproperty=sop.property where sop.property=vop.id);
update shadow.observedproperty vop set instrumentids = ARRAY[]::text[] where instrumentids is null;

-- computation type
insert into shadow.computationtype (id, title, shortlabel, definition, parent) select id, title, shortlabel, definition, (case when parent is not null then parent else '-1' end) from public.computationtype;
update shadow.computationtype vct set observedpropertyids = (select array_agg(distinct sop.property) from public.observation o join public.computation c on o.procedure=c.process join public.simpleobservedproperty sop on o.observedproperty=sop.property where c.type=vct.id);
update shadow.computationtype vct set observedpropertyids = observedpropertyids || (select array_agg(distinct sop.property) from public.observation o join public.computation c on o.procedure=c.process join public.compositeproperty_subproperties cops on cops.composite=o.observedproperty join public.simpleobservedproperty sop on cops.simpleproperty=sop.property where c.type=vct.id);
update shadow.computationtype vct  set observedpropertyids = observedpropertyids || (select array_agg(distinct sop.property) from public.observation o join public.compositeprocess_computation cpc on cpc.compositeprocess=o.procedure join computation c on c.process=cpc.computation join public.simpleobservedproperty sop on o.observedproperty=sop.property where c.type=vct.id);
update shadow.computationtype vct set observedpropertyids = observedpropertyids || (select array_agg(distinct sop.property) from public.observation o join public.compositeprocess_computation cpc on cpc.compositeprocess=o.procedure join public.compositeproperty_subproperties cops on cops.composite=o.observedproperty join public.simpleobservedproperty sop on cops.simpleproperty=sop.property join computation c on c.process=cpc.computation where c.type=vct.id);
update shadow.computationtype set observedpropertyids = ARRAY[]::text[] where observedpropertyids is null;

-- computation
insert into shadow.computation (id, title, shortlabel, description, parent) select id, name, null, description, '-1' from public.computation c join public.process p on c.process=p.id ;
update shadow.computation vc set computationtypeids = (select array_agg(type) from public.computation pc where pc.process = vc.id);
update shadow.computation vc set observedpropertyids = (select array_agg(distinct sop.property) from public.observation o join public.process p on o.procedure=p.id join public.simpleobservedproperty sop on o.observedproperty=sop.property where p.id=vc.id);
update shadow.computation vc set observedpropertyids = observedpropertyids || (select array_agg(distinct sop.property) from public.observation o join public.process p on o.procedure=p.id join public.compositeproperty_subproperties cops on cops.composite=o.observedproperty join public.simpleobservedproperty sop on cops.simpleproperty=sop.property where p.id=vc.id);
update shadow.computation vc set observedpropertyids = observedpropertyids || (select array_agg(distinct sop.property) from public.observation o join public.compositeprocess_computation cpc on cpc.compositeprocess=o.procedure join public.simpleobservedproperty sop on o.observedproperty=sop.property where cpc.computation=vc.id);
update shadow.computation vc set observedpropertyids = observedpropertyids || (select array_agg(distinct sop.property) from public.observation o join public.compositeprocess_computation cpc on cpc.compositeprocess=o.procedure join public.compositeproperty_subproperties cops on cops.composite=o.observedproperty join public.simpleobservedproperty sop on cops.simpleproperty=sop.property  where cpc.computation=vc.id);
update shadow.computation vc set observedpropertyids = ARRAY[]::text[] where observedpropertyids is null;

-- instrument type
insert into shadow.instrumenttype (id, title, shortlabel, definition, parent) select id, title, shortlabel, definition, (case when parent is not null then parent else '-1' end) from public.instrumenttype;
update shadow.instrumenttype vit set observedpropertyids = (select array_agg(distinct sop.property) from public.observation o join public.acquisition_instrument aqi on o.procedure=aqi.acquisition join public.instrument i on aqi.instrument=i.id join public.simpleobservedproperty sop on o.observedproperty=sop.property where i.type=vit.id);
update shadow.instrumenttype vit set observedpropertyids = observedpropertyids || (select array_agg(distinct sop.property) from public.observation o join public.acquisition_instrument aqi on o.procedure=aqi.acquisition join public.instrument i on aqi.instrument=i.id join public.compositeproperty_subproperties cops on cops.composite=o.observedproperty join public.simpleobservedproperty sop on o.observedproperty=sop.property where i.type=vit.id);
update shadow.instrumenttype vit set observedpropertyids = observedpropertyids || (select array_agg(distinct sop.property) from public.observation o join public.compositeprocess_acquisition cpa on cpa.compositeprocess=o.procedure join public.acquisition aq on aq.process=cpa.acquisition join public.acquisition_instrument aqi on aqi.acquisition = aq.process join public.instrument i on i.id=aqi.instrument join public.simpleobservedproperty sop on o.observedproperty=sop.property where i.type=vit.id);
update shadow.instrumenttype vit set observedpropertyids = observedpropertyids || (select array_agg(distinct sop.property) from public.observation o join public.compositeprocess_acquisition cpa on cpa.compositeprocess=o.procedure join public.acquisition aq on aq.process=cpa.acquisition join public.acquisition_instrument aqi on aqi.acquisition = aq.process join public.instrument i on i.id=aqi.instrument join public.compositeproperty_subproperties cops on cops.composite=o.observedproperty join public.simpleobservedproperty sop on cops.simpleproperty=sop.property where i.type=vit.id);
update shadow.instrumenttype vit set observedpropertyids = ARRAY[]::text[] where observedpropertyids is null;

-- instrument
insert into shadow.instrument (id, title, shortlabel, description, parent) (select id, name, null, description, max(case when parent is not null then parent else '-1' end) from public.instrument i left join public.instrument_subinstrument isi on i.id=isi.child group by id, name, description);
update shadow.instrument vi set instrumenttypeids = (select array_agg(type) from public.instrument pi where pi.id = vi.id);
update shadow.instrument vi set observedpropertyids = (select array_agg(distinct sop.property) from public.observation o join public.acquisition_instrument aqi on o.procedure=aqi.acquisition join public.simpleobservedproperty sop on o.observedproperty=sop.property where aqi.instrument=vi.id);
update shadow.instrument vi set observedpropertyids = observedpropertyids || (select array_agg(distinct sop.property) from public.observation o join public.acquisition_instrument aqi on o.procedure=aqi.acquisition join public.compositeproperty_subproperties cops on cops.composite=o.observedproperty join public.simpleobservedproperty sop on cops.simpleproperty=sop.property where aqi.instrument=vi.id);
update shadow.instrument vi set observedpropertyids = observedpropertyids || (select array_agg(distinct sop.property) from public.observation o join public.compositeprocess_acquisition cpa on cpa.compositeprocess=o.procedure join public.acquisition aq on aq.process=cpa.acquisition join public.acquisition_instrument aqi on aqi.acquisition = aq.process join public.simpleobservedproperty sop on o.observedproperty=sop.property where aqi.instrument=vi.id);
update shadow.instrument vi set observedpropertyids = observedpropertyids || (select array_agg(distinct sop.property) from public.observation o join public.compositeprocess_acquisition cpa on cpa.compositeprocess=o.procedure join public.acquisition aq on aq.process=cpa.acquisition join public.acquisition_instrument aqi on aqi.acquisition = aq.process join public.compositeproperty_subproperties cops on cops.composite=o.observedproperty join public.simpleobservedproperty sop on cops.simpleproperty=sop.property where aqi.instrument=vi.id);
update shadow.instrument vi set observedpropertyids = ARRAY[]::text[] where observedpropertyids is null;
update shadow.instrument vi set platformids = (select array_agg(distinct aqp.platform) from public.observation o join public.acquisition_instrument aqi on o.procedure=aqi.acquisition join public.acquisition_platform aqp on aqp.acquisition=o.procedure where aqi.instrument=vi.id);
update shadow.instrument vi set platformids = platformids || (select array_agg(distinct aqp.platform) from public.observation o join public.compositeprocess_acquisition cpa on cpa.compositeprocess=o.procedure join public.acquisition aq on aq.process=cpa.acquisition join public.acquisition_instrument aqi on aqi.acquisition = aq.process join public.acquisition_platform aqp on aqp.acquisition=aq.process where aqi.instrument=vi.id);
update shadow.instrument vi set platformids = ARRAY[]::text[] where platformids is null;

-- dimensionality instance
insert into shadow.dimensionalityinstance (id, title, shortlabel, parent, definition) select id, title, shortlabel, (case when parent is not null then parent else '-1' end), definition from public.dimensionality_instance;
update shadow.dimensionalityinstance vdi set observedpropertyids = (select array_agg(distinct pc.observedproperty) from public.observation o join shadow.result_observation ro on ro.observation=o.id join public.result_processcapability rpc on rpc.result=ro.result join public.processcapability pc on pc.id=rpc.capability where pc.dimensionalityinstance=vdi.id );
update shadow.dimensionalityinstance vdi set observedpropertyids =  ARRAY[]::text[] where observedpropertyids is null;
update shadow.dimensionalityinstance vdi set instrumentids = (select array_agg(distinct aqi.instrument) from public.acquisition_instrument aqi join public.observation o on o.procedure=aqi.acquisition join shadow.result_observation ro on ro.observation = o.id join public.result r on r.id=ro.result join public.result_processcapability rpc on r.id=rpc.result join public.processcapability pc on pc.id=rpc.capability where pc.dimensionalityinstance=vdi.id);
update shadow.dimensionalityinstance vdi set instrumentids = instrumentids || (select array_agg(distinct aqi.instrument) from public.acquisition_instrument aqi join public.compositeprocess_acquisition cpa on cpa.acquisition=aqi.acquisition join public.observation o on o.procedure=cpa.compositeprocess join shadow.result_observation ro on ro.observation = o.id join public.result r on r.id=ro.result join public.result_processcapability rpc on r.id=rpc.result join public.processcapability pc on pc.id=rpc.capability where pc.dimensionalityinstance=vdi.id);
update shadow.dimensionalityinstance vdi set instrumentids = array[]::text[] where instrumentids is null;
update shadow.dimensionalityinstance vdi set computationids = (select array_agg(distinct o.procedure) from public.observation o  join shadow.result_observation ro on ro.observation = o.id join public.result r on r.id=ro.result join public.result_processcapability rpc on r.id=rpc.result join public.processcapability pc on pc.id=rpc.capability where pc.dimensionalityinstance=vdi.id);
update shadow.dimensionalityinstance vdi set computationids = computationids || (select array_agg(distinct cpc.computation) from public.compositeprocess_computation cpc join public.observation o on cpc.compositeprocess = o.procedure join shadow.result_observation ro on ro.observation = o.id join public.result r on r.id=ro.result join public.result_processcapability rpc on r.id=rpc.result join public.processcapability pc on pc.id=rpc.capability where pc.dimensionalityinstance=vdi.id);
update shadow.dimensionalityinstance vdi set computationids = array[]::text[] where computationids is null;

-- dimensionalitytimeline
insert into shadow.dimensionalitytimeline (id, title, shortlabel, parent, definition) select id, title, shortlabel, (case when parent is not null then parent else '-1' end), definition from public.dimensionality_timeline;
update shadow.dimensionalitytimeline vdt set observedpropertyids = (select array_agg(distinct pc.observedproperty) from public.observation o join shadow.result_observation ro on ro.observation=o.id join public.result_processcapability rpc on rpc.result=ro.result join public.processcapability pc on pc.id=rpc.capability where pc.dimensionalitytimeline=vdt.id );
update shadow.dimensionalitytimeline vdt set observedpropertyids = ARRAY[]::text[] where observedpropertyids is null;
update shadow.dimensionalitytimeline vdt set instrumentids = (select array_agg(distinct aqi.instrument) from public.acquisition_instrument aqi join public.observation o on o.procedure=aqi.acquisition join shadow.result_observation ro on ro.observation = o.id join public.result r on r.id=ro.result join public.result_processcapability rpc on r.id=rpc.result join public.processcapability pc on pc.id=rpc.capability where pc.dimensionalitytimeline=vdt.id);
update shadow.dimensionalitytimeline vdt set instrumentids = instrumentids || (select array_agg(distinct aqi.instrument) from public.acquisition_instrument aqi join public.compositeprocess_acquisition cpa on cpa.acquisition=aqi.acquisition join public.observation o on o.procedure=cpa.compositeprocess join shadow.result_observation ro on ro.observation = o.id join public.result r on r.id=ro.result join public.result_processcapability rpc on r.id=rpc.result join public.processcapability pc on pc.id=rpc.capability where pc.dimensionalityinstance=vdt.id);
update shadow.dimensionalitytimeline vdt set instrumentids = array[]::text[] where instrumentids is null;
update shadow.dimensionalitytimeline vdt set computationids = (select array_agg(distinct o.procedure) from public.observation o  join shadow.result_observation ro on ro.observation = o.id join public.result r on r.id=ro.result join public.result_processcapability rpc on r.id=rpc.result join public.processcapability pc on pc.id=rpc.capability where pc.dimensionalitytimeline=vdt.id);
update shadow.dimensionalitytimeline vdt set computationids = computationids || (select array_agg(distinct cpc.computation) from public.compositeprocess_computation cpc join public.observation o on cpc.compositeprocess = o.procedure join shadow.result_observation ro on ro.observation = o.id join public.result r on r.id=ro.result join public.result_processcapability rpc on r.id=rpc.result join public.processcapability pc on pc.id=rpc.capability where pc.dimensionalityinstance=vdt.id);
update shadow.dimensionalitytimeline vdt set computationids = array[]::text[] where computationids is null;

-- platform
insert into shadow.platform (id, title, shortlabel, description, parent) select id, name, shortname, description, '-1' from public.platform;
update shadow.platform vp set observedpropertyids = (select array_agg(distinct pc.observedproperty) from public.platform p join public.acquisition_platform ap on ap.platform=p.id join public.acquisition a on a.process=ap.acquisition join observation o on o.procedure=a.process join shadow.result_observation ro on ro.observation=o.id join public.result_processcapability rpc on rpc.result=ro.result join public.processcapability pc on pc.id=rpc.capability where p.id=vp.id);
update shadow.platform vp set observedpropertyids = observedpropertyids || (select array_agg(distinct pc.observedproperty) from public.platform p join public.acquisition_platform ap on ap.platform=p.id join public.acquisition a on a.process=ap.acquisition join public.compositeprocess_acquisition cpa on cpa.acquisition=a.process join compositeprocess cp on cp.process=cpa.compositeprocess join observation o on o.procedure=cp.process join shadow.result_observation ro on ro.observation=o.id join public.result_processcapability rpc on rpc.result=ro.result join public.processcapability pc on pc.id=rpc.capability where p.id=vp.id);
update shadow.platform vp set observedpropertyids = ARRAY[]::text[] where observedpropertyids is null;

-- project
insert into shadow.project (id, title, shortlabel, description, parent) select id, name, shortname, description, '-1' from public.project;
update shadow.project vp set observationcollectionids = observationcollectionids || (select array_agg(ocp.observationcollection) from public.observationcollection_project ocp where ocp.project=vp.id);

-- observation collection
insert into shadow.observationcollection (id, title, shortlabel, description, parent) select id, name, null, description, '-1' from public.observationcollection;

-- regionofspace
insert into shadow.regionofspace (id, title, shortlabel, parent, definition) select id, title, shortlabel, (case when parent is not null then parent else '-1' end), definition from public.regionofspace;
update shadow.regionofspace vr set instrumentids = (select array_agg(distinct aqi.instrument) from public.observation o join public.acquisition_instrument aqi on o.procedure=aqi.acquisition where o.featureofinterest=vr.id);
update shadow.regionofspace vr set instrumentids = vr.instrumentids || (select array_agg(distinct aqi.instrument) from public.observation o join public.compositeprocess_acquisition cpa on cpa.compositeprocess=o.procedure join public.acquisition aq on aq.process=cpa.acquisition join public.acquisition_instrument aqi on aqi.acquisition = aq.process where o.featureofinterest=vr.id);
update shadow.regionofspace vr set instrumentids = array[]::text[] where instrumentids is null;
update shadow.regionofspace vr set computationids = (select array_agg(distinct c.process) from public.observation o join public.computation c on o.procedure = c.process where o.featureofinterest=vr.id);
update shadow.regionofspace vr set computationids = computationids || (select array_agg(distinct cpc.computation) from public.observation o join public.compositeprocess_computation cpc on cpc.compositeprocess=o.procedure where o.featureofinterest=vr.id);
update shadow.regionofspace vr set computationids = ARRAY[]::text[] where computationids is null;
update shadow.regionofspace vr set observedpropertyids = (select array_agg(distinct pc.observedproperty) from public.observation o join shadow.result_observation ro on ro.observation=o.id join public.result_processcapability rpc on rpc.result=ro.result join public.processcapability pc on rpc.capability=pc.id  where o.featureofinterest=vr.id);
update shadow.regionofspace vr set observedpropertyids = observedpropertyids || (select array_agg(distinct observedproperty) from public.observation o where o.featureofinterest=vr.id);
update shadow.regionofspace vr set observedpropertyids = ARRAY[]::text[] where observedpropertyids is null;

-- observation
insert into shadow.observation (id, startdate, enddate, seconds, temporalresolution) select id, startphenomenontime, endphenomenontime, extract(HOUR from startphenomenontime)*3600 + extract(MINUTE from startphenomenontime)*60 + extract(SECOND from startphenomenontime), temporalresolution::interval from public.observation;
insert into shadow.observation_instrument (observation, instrument) (select o.id, aqi.instrument from public.observation o join public.acquisition_instrument aqi on o.procedure=aqi.acquisition union select o.id, aqi.instrument from public.observation o join public.compositeprocess_acquisition cpa on cpa.compositeprocess=o.procedure join public.acquisition aq on aq.process=cpa.acquisition join public.acquisition_instrument aqi on aqi.acquisition = aq.process);
insert into shadow.observation_computation (observation, computation) (select o.id, c.process from public.observation o join public.computation c on o.procedure = c.process union select o.id, cpc.computation from public.observation o join public.compositeprocess_computation cpc on cpc.compositeprocess=o.procedure);
insert into shadow.observation_regionofspace (observation, regionofspace) (select o.id, o.featureofinterest from public.observation o);
insert into shadow.observation_platform (observation, platform) (select o.id, aqp.platform from public.observation o join public.acquisition_platform aqp on aqp.acquisition = o.procedure union select o.id, ap.platform from public.observation o join public.compositeprocess cp on cp.process=o.procedure join compositeprocess_acquisition cpa on cpa.compositeprocess=cp.process join acquisition aq on aq.process=cpa.acquisition join acquisition_platform ap on ap.acquisition=aq.process);
insert into shadow.observation_observedproperty (observation, observedproperty) (select distinct o.id, pc.observedproperty from public.observation o join shadow.result_observation ro on ro.observation=o.id join public.result_processcapability rpc on rpc.result=ro.result join public.processcapability pc on rpc.capability=pc.id union select o.id, o.observedproperty from public.observation o);
insert into shadow.observation_dimensionalityinstance (observation, dimensionalityinstance) (select distinct o.id, pc.dimensionalityinstance from public.observation o join shadow.result_observation ro on ro.observation=o.id join public.result_processcapability rpc on rpc.result=ro.result join public.processcapability pc on rpc.capability=pc.id where pc.dimensionalityinstance is not null);
insert into shadow.observation_dimensionalitytimeline (observation, dimensionalitytimeline) (select distinct o.id, pc.dimensionalitytimeline from public.observation o join shadow.result_observation ro on ro.observation=o.id join public.result_processcapability rpc on rpc.result=ro.result join public.processcapability pc on rpc.capability=pc.id where pc.dimensionalitytimeline is not null);
update shadow.observation vo set results = (select array_agg(ro.result || '||' || onr.linkage || '||' || onr.name || '||' ||  (case when rdf.title is not null then rdf.title else 'unknown' end)) from public.observation o join shadow.result_observation ro on ro.observation=o.id join public.result_onlineresource ror on ror.result=ro.result join public.onlineresource onr on onr.id=ror.onlineresource left join public.resultdataformat rdf on rdf.id=onr.applicationprofile where o.id=vo.id);
update shadow.observation vo set results = ARRAY[]::text[] where results is null or (array_length(results, 1) = 1 and results[1] is null);
update shadow.observation vo set resulttypes = (select array_agg(distinct rdf.id) from public.observation o join shadow.result_observation ro on ro.observation=o.id join public.result_onlineresource ror on ror.result=ro.result join public.onlineresource onr on onr.id=ror.onlineresource left join public.resultdataformat rdf on rdf.id=onr.applicationprofile where o.id=vo.id and rdf.id is not null);
update shadow.observation vo set resulttypes = ARRAY[]::text[] where resulttypes is null;
insert into shadow.observation_year(observation, year) ( select  id, unnest(years) as year from (select o.id, yearsdifference(startdate, enddate) as years from shadow.observation o where enddate is not null) as foo  union select o.id, extract('year' from startdate) as year from shadow.observation o where enddate is null);


-- observation

insert into shadow.observation_observationcollection (observation, observationcollection) (select o.id, 'http://resources.espas-fp7.eu/observationCollection/ROB/SWAPnominalAll/1' from shadow.observation as o join shadow.observation_procedure as op on o.id=op.observation where op.procedure = 'http://resources.espas-fp7.eu/acquisition/ROB/SWAPnominal/1' and o.startdate >= '2009-01-01');

insert into shadow.observation_observationcollection (observation, observationcollection) (select o.id, 'http://resources.espas-fp7.eu/observationCollection/iasb/whisper1/1' from shadow.observation as o join shadow.observation_procedure as op on o.id=op.observation where op.procedure = 'http://resources.espas-fp7.eu/acquisition/iasb/whisper1/1');
insert into shadow.observation_observationcollection (observation, observationcollection) (select o.id, 'http://resources.espas-fp7.eu/observationCollection/iasb/whisper2/1' from shadow.observation as o join shadow.observation_procedure as op on o.id=op.observation where op.procedure = 'http://resources.espas-fp7.eu/acquisition/iasb/whisper2/1');
insert into shadow.observation_observationcollection (observation, observationcollection) (select o.id, 'http://resources.espas-fp7.eu/observationCollection/iasb/whisper3/1' from shadow.observation as o join shadow.observation_procedure as op on o.id=op.observation where op.procedure = 'http://resources.espas-fp7.eu/acquisition/iasb/whisper3/1');
insert into shadow.observation_observationcollection (observation, observationcollection) (select o.id, 'http://resources.espas-fp7.eu/observationCollection/iasb/whisper4/1' from shadow.observation as o join shadow.observation_procedure as op on o.id=op.observation where op.procedure = 'http://resources.espas-fp7.eu/acquisition/iasb/whisper4/1');

insert into shadow.observation_observationcollection (observation, observationcollection) (select o.id, 'http://resources.espas-fp7.eu/observationCollection/noa/AthensIonograms/1' from shadow.observation as o join shadow.observation_procedure as op on o.id=op.observation join shadow.observation_observedproperty as oo on o.id=oo.observation where op.procedure = 'http://resources.espas-fp7.eu/compositeProcess/noa/athDig-artist/1' and oo.observedproperty = 'http://ontology.espas-fp7.eu/compositeObservedProperty/noa-ionogram');
insert into shadow.observation_observationcollection (observation, observationcollection) (select o.id, 'http://resources.espas-fp7.eu/observationCollection/noa/AthensSAO/1' from shadow.observation as o join shadow.observation_procedure as op on o.id=op.observation join shadow.observation_observedproperty as oo on o.id=oo.observation where op.procedure = 'http://resources.espas-fp7.eu/compositeProcess/noa/athDig-artist/1' and oo.observedproperty = 'http://ontology.espas-fp7.eu/compositeObservedProperty/noa-sao');
insert into shadow.observation_observationcollection (observation, observationcollection) (select o.id, 'http://resources.espas-fp7.eu/observationCollection/noa/fplots-M3000F2-Athens/1' from shadow.observation as o join shadow.observation_procedure as op on o.id=op.observation join shadow.observation_observedproperty as oo on o.id=oo.observation where op.procedure = 'http://resources.espas-fp7.eu/computation/noa/sirm/1' and oo.observedproperty = 'http://ontology.espas-fp7.eu/observedProperty/M_3000km_F2-Layer');
insert into shadow.observation_observationcollection (observation, observationcollection) (select o.id, 'http://resources.espas-fp7.eu/observationCollection/noa/fplots-fminfof2-Athens/1' from shadow.observation as o join shadow.observation_procedure as op on o.id=op.observation join shadow.observation_observedproperty as oo on o.id=oo.observation where op.procedure = 'http://resources.espas-fp7.eu/computation/noa/sirm/1' and oo.observedproperty = 'http://ontology.espas-fp7.eu/observedProperty/CriticalFrequency_F2-Layer');
insert into shadow.observation_observationcollection (observation, observationcollection) (select o.id, 'http://resources.espas-fp7.eu/observationCollection/noa/mapsElectronDensity/1' from shadow.observation as o join shadow.observation_procedure as op on o.id=op.observation where op.procedure = 'http://resources.espas-fp7.eu/computation/noa/Ne3D/1');
insert into shadow.observation_observationcollection (observation, observationcollection) (select o.id, 'http://resources.espas-fp7.eu/observationCollection/noa/mapsFoF2/1' from shadow.observation as o join shadow.observation_procedure as op on o.id=op.observation join shadow.observation_observedproperty as oo on o.id=oo.observation where op.procedure = 'http://resources.espas-fp7.eu/computation/noa/sirmup/1' and oo.observedproperty = 'http://ontology.espas-fp7.eu/observedProperty/CriticalFrequency_F2-Layer');
insert into shadow.observation_observationcollection (observation, observationcollection) (select o.id, 'http://resources.espas-fp7.eu/observationCollection/noa/mapsM3000F2/1' from shadow.observation as o join shadow.observation_procedure as op on o.id=op.observation join shadow.observation_observedproperty as oo on o.id=oo.observation where op.procedure = 'http://resources.espas-fp7.eu/computation/noa/sirmup/1' and oo.observedproperty = 'http://ontology.espas-fp7.eu/observedProperty/M_3000km_F2-Layer');
insert into shadow.observation_observationcollection (observation, observationcollection) (select o.id, 'http://resources.espas-fp7.eu/observationCollection/noa/mapsMUF-Athens/1' from shadow.observation as o join shadow.observation_procedure as op on o.id=op.observation where op.procedure = 'http://resources.espas-fp7.eu/compositeProcess/noa/sirmup-lockwood/1');
insert into shadow.observation_observationcollection (observation, observationcollection) (select o.id, 'http://resources.espas-fp7.eu/observationCollection/noa/nasa-isis1/1' from shadow.observation as o join shadow.observation_procedure as op on o.id=op.observation where op.procedure = 'http://resources.espas-fp7.eu/acquisition/noa/nasa-isis1/1');
insert into shadow.observation_observationcollection (observation, observationcollection) (select o.id, 'http://resources.espas-fp7.eu/observationCollection/noa/nasa-isis2/1' from shadow.observation as o join shadow.observation_procedure as op on o.id=op.observation where op.procedure = 'http://resources.espas-fp7.eu/acquisition/noa/nasa-isis2/1');
insert into shadow.observation_observationcollection (observation, observationcollection) (select o.id, 'http://resources.espas-fp7.eu/observationCollection/noa/demeter-iap-burst/1' from shadow.observation as o join shadow.observation_procedure as op on o.id=op.observation where op.procedure = 'http://resources.espas-fp7.eu/acquisition/noa/demeter-iap-burst/1');
insert into shadow.observation_observationcollection (observation, observationcollection) (select o.id, 'http://resources.espas-fp7.eu/observationCollection/noa/demeter-isl-survey/1' from shadow.observation as o join shadow.observation_procedure as op on o.id=op.observation where op.procedure = 'http://resources.espas-fp7.eu/acquisition/noa/demeter-isl-survey/1');
insert into shadow.observation_observationcollection (observation, observationcollection) (select o.id, 'http://resources.espas-fp7.eu/observationCollection/noa/demeter-iap-survey/1' from shadow.observation as o join shadow.observation_procedure as op on o.id=op.observation where op.procedure = 'http://resources.espas-fp7.eu/acquisition/noa/demeter-iap-survey/1');
insert into shadow.observation_observationcollection (observation, observationcollection) (select o.id, 'http://resources.espas-fp7.eu/observationCollection/noa/demeter-isl-burst/1' from shadow.observation as o join shadow.observation_procedure as op on o.id=op.observation where op.procedure = 'http://resources.espas-fp7.eu/acquisition/noa/demeter-isl-burst/1');

insert into shadow.observation_observationcollection (observation, observationcollection) (select o.id, 'http://resources.espas-fp7.eu/observationCollection/ubirm/edamgrids/1' from shadow.observation as o join shadow.observation_procedure as op on o.id=op.observation where op.procedure = 'http://resources.espas-fp7.eu/computation/ubirm/edam/1');

insert into shadow.observation_observationcollection (observation, observationcollection) (select o.id, 'http://resources.espas-fp7.eu/observationCollection/ucl/all_UCL-FPIs/1' from shadow.observation as o join shadow.observation_procedure as op on o.id=op.observation where op.procedure = 'http://resources.espas-fp7.eu/acquisition/ucl/uclKEOPSobservatory-FPIgreen/1' or op.procedure = 'http://resources.espas-fp7.eu/acquisition/ucl/uclKEOPSobservatory-FPIred/1' or op.procedure = 'http://resources.espas-fp7.eu/acquisition/ucl/uclSvalbardKHOobservatory-FPIred/1' or op.procedure = 'http://resources.espas-fp7.eu/acquisition/ucl/uclSvalbardKHOobservatory-FPIgreen/1' or op.procedure = 'http://resources.espas-fp7.eu/acquisition/ucl/uclSodankylaobservatory-FPI/1' or op.procedure = 'http://resources.espas-fp7.eu/acquisition/ucl/uclSvalbardAdventdalenobservatory-FPIred/1');

insert into shadow.observation_observationcollection (observation, observationcollection) (select o.id, 'http://resources.espas-fp7.eu/observationCollection/uot/BJNdata/1' from shadow.observation as o join shadow.observation_procedure as op on o.id=op.observation where op.procedure = 'http://resources.espas-fp7.eu/acquisition/uot/TGOMagnetometer-Bjornoya/1');
insert into shadow.observation_observationcollection (observation, observationcollection) (select o.id, 'http://resources.espas-fp7.eu/observationCollection/uot/TROdata/1' from shadow.observation as o join shadow.observation_procedure as op on o.id=op.observation where op.procedure = 'http://resources.espas-fp7.eu/acquisition/uot/TGOMagnetometer-Tromso/1');
insert into shadow.observation_observationcollection (observation, observationcollection) (select o.id, 'http://resources.espas-fp7.eu/observationCollection/uot/DOBdata/1' from shadow.observation as o join shadow.observation_procedure as op on o.id=op.observation where op.procedure = 'http://resources.espas-fp7.eu/acquisition/uot/TGOMagnetometer-Dombas/1');

insert into shadow.observation_observationcollection (observation, observationcollection) (select o.id, 'http://resources.espas-fp7.eu/observationCollection/uoulu/metop02/1' from shadow.observation as o join shadow.observation_procedure as op on o.id=op.observation where op.procedure = 'http://resources.espas-fp7.eu/acquisition/uoulu/metop02/1');
insert into shadow.observation_observationcollection (observation, observationcollection) (select o.id, 'http://resources.espas-fp7.eu/observationCollection/uoulu/noaa06/1' from shadow.observation as o join shadow.observation_procedure as op on o.id=op.observation where op.procedure = 'http://resources.espas-fp7.eu/acquisition/uoulu/noaa06/1');
insert into shadow.observation_observationcollection (observation, observationcollection) (select o.id, 'http://resources.espas-fp7.eu/observationCollection/uoulu/noaa07/1' from shadow.observation as o join shadow.observation_procedure as op on o.id=op.observation where op.procedure = 'http://resources.espas-fp7.eu/acquisition/uoulu/noaa07/1');
insert into shadow.observation_observationcollection (observation, observationcollection) (select o.id, 'http://resources.espas-fp7.eu/observationCollection/uoulu/noaa08/1' from shadow.observation as o join shadow.observation_procedure as op on o.id=op.observation where op.procedure = 'http://resources.espas-fp7.eu/acquisition/uoulu/noaa08/1');
insert into shadow.observation_observationcollection (observation, observationcollection) (select o.id, 'http://resources.espas-fp7.eu/observationCollection/uoulu/noaa10/1' from shadow.observation as o join shadow.observation_procedure as op on o.id=op.observation where op.procedure = 'http://resources.espas-fp7.eu/acquisition/uoulu/noaa10/1');
insert into shadow.observation_observationcollection (observation, observationcollection) (select o.id, 'http://resources.espas-fp7.eu/observationCollection/uoulu/noaa12/1' from shadow.observation as o join shadow.observation_procedure as op on o.id=op.observation where op.procedure = 'http://resources.espas-fp7.eu/acquisition/uoulu/noaa12/1');
insert into shadow.observation_observationcollection (observation, observationcollection) (select o.id, 'http://resources.espas-fp7.eu/observationCollection/uoulu/noaa15/1' from shadow.observation as o join shadow.observation_procedure as op on o.id=op.observation where op.procedure = 'http://resources.espas-fp7.eu/acquisition/uoulu/noaa15/1');
insert into shadow.observation_observationcollection (observation, observationcollection) (select o.id, 'http://resources.espas-fp7.eu/observationCollection/uoulu/noaa16/1' from shadow.observation as o join shadow.observation_procedure as op on o.id=op.observation where op.procedure = 'http://resources.espas-fp7.eu/acquisition/uoulu/noaa16/1');
insert into shadow.observation_observationcollection (observation, observationcollection) (select o.id, 'http://resources.espas-fp7.eu/observationCollection/uoulu/noaa17/1' from shadow.observation as o join shadow.observation_procedure as op on o.id=op.observation where op.procedure = 'http://resources.espas-fp7.eu/acquisition/uoulu/noaa17/1');
insert into shadow.observation_observationcollection (observation, observationcollection) (select o.id, 'http://resources.espas-fp7.eu/observationCollection/uoulu/noaa18/1' from shadow.observation as o join shadow.observation_procedure as op on o.id=op.observation where op.procedure = 'http://resources.espas-fp7.eu/acquisition/uoulu/noaa18/1');
insert into shadow.observation_observationcollection (observation, observationcollection) (select o.id, 'http://resources.espas-fp7.eu/observationCollection/uoulu/noaa19/1' from shadow.observation as o join shadow.observation_procedure as op on o.id=op.observation where op.procedure = 'http://resources.espas-fp7.eu/acquisition/uoulu/noaa19/1');

insert into shadow.observation_observationcollection (observation, observationcollection) (select o.id, 'http://resources.espas-fp7.eu/observationCollection/uleic/mappot_collection/1' from shadow.observation as o join shadow.observation_procedure as op on o.id=op.observation where op.procedure = 'http://resources.espas-fp7.eu/computation/uleic/mappot/1');

insert into shadow.observation_observationcollection (observation, observationcollection) (select o.id, 'http://resources.espas-fp7.eu/observationCollection/dtu/DTU-Col/1' from shadow.observation as o join shadow.observation_instrument as oi on o.id=oi.observation join shadow.observation_observedproperty as oo on o.id=oo.observation where oi.instrument = 'http://resources.espas-fp7.eu/dtu/DTU-FGE/1' and oo.observedproperty = 'http://ontology.espas-fp7.eu/compositeObservedProperty/MagneticField');

insert into shadow.observation_observationcollection (observation, observationcollection) (select o.id, 'http://resources.espas-fp7.eu/observationCollection/srcpas/Magion-3/1' from shadow.observation as o join shadow.observation_procedure as op on o.id=op.observation where op.procedure = 'http://resources.espas-fp7.eu/process/srcpas/Magion-3/1');

insert into shadow.observation_project (observation, project) (select ooc.observation, ocp.project from public.observationcollection_project ocp join public.observationcollection oc on ocp.observationcollection=oc.id join shadow.observation_observationcollection ooc on oc.id=ooc.observationcollection); 

-- computation
update shadow.computation vc set observationcollectionids = (select array_agg(distinct foo.observationcollection) from (select ooc.observationcollection from shadow.observation_observationcollection ooc join shadow.observation_computation oc on ooc.observation = oc.observation where vc.id=oc.computation) foo );
update shadow.computation vc set observationcollectionids = array[]::text[] where observationcollectionids is null;
update shadow.computation vc set projectids = (select array_agg(distinct ocp.project) from public.observationcollection_project ocp where vc.observationcollectionids @> array[ocp.observationcollection]::text[]);
update shadow.computation vc set projectids = array[]::text[] where projectids is null;

-- computationtype
update shadow.computationtype vct set observationcollectionids = (select array_agg(distinct id) from (select unnest(observationcollectionids) as id from shadow.computation vc where vc.computationtypeids @> array[vct.id]::text[]) foo);
update shadow.computationtype vct set observationcollectionids = array[]::text[] where observationcollectionids is null;

-- instrument
update shadow.instrument vi set observationcollectionids = (select array_agg(distinct foo.observationcollection) from (select ooc.observationcollection from shadow.observation_observationcollection ooc join shadow.observation_instrument oi on ooc.observation = oi.observation where vi.id=oi.instrument) foo );
update shadow.instrument vi set observationcollectionids = array[]::text[] where observationcollectionids is null;
update shadow.instrument vi set projectids = (select array_agg(distinct ocp.project) from public.observationcollection_project ocp where vi.observationcollectionids @> array[ocp.observationcollection]::text[]);
update shadow.instrument vi set projectids = array[]::text[] where projectids is null;

-- instrument type
update shadow.instrumenttype vit set observationcollectionids = (select array_agg(distinct id) from ( select unnest(observationcollectionids) as id from shadow.instrument vc where vc.instrumenttypeids @> array[vit.id]::text[]) foo);
update shadow.instrumenttype vit set observationcollectionids = array[]::text[] where observationcollectionids is null;

-- observation collection
update shadow.observationcollection voc set instrumentids = (select array_agg(distinct foo.instrument) from (select oi.instrument from shadow.observation_instrument oi join shadow.observation_observationcollection ooc on oi.observation=ooc.observation where voc.id=ooc.observationcollection) foo );
update shadow.observationcollection voc set instrumentids = array[]::text[] where instrumentids is null;
update shadow.observationcollection voc set computationids = (select array_agg(distinct foo.computation) from (select oc.computation from shadow.observation_computation oc join shadow.observation_observationcollection ooc on oc.observation=ooc.observation where voc.id=ooc.observationcollection) foo );
update shadow.observationcollection voc set computationids = array[]::text[] where computationids is null;
update shadow.observationcollection voc set observedpropertyids = (select array_agg(distinct foo.observedproperty) from (select oop.observedproperty from shadow.observation_observedproperty oop join shadow.observation_observationcollection ooc on oop.observation=ooc.observation where voc.id=ooc.observationcollection) foo );
update shadow.observationcollection voc set observedpropertyids = array[]::text[] where observedpropertyids is null;
update shadow.observationcollection voc set dimensionalitytimelineids = (select array_agg(distinct foo.dimensionalitytimeline) from (select odt.dimensionalitytimeline from shadow.observation_dimensionalitytimeline odt join shadow.observation_observationcollection ooc on odt.observation=ooc.observation where voc.id=ooc.observationcollection) foo );
update shadow.observationcollection voc set dimensionalitytimelineids = array[]::text[] where dimensionalitytimelineids is null;
update shadow.observationcollection voc set dimensionalityinstanceids = (select array_agg(distinct foo.dimensionalityinstance) from (select odi.dimensionalityinstance from shadow.observation_dimensionalityinstance odi join shadow.observation_observationcollection ooc on odi.observation=ooc.observation where voc.id=ooc.observationcollection) foo );
update shadow.observationcollection voc set dimensionalityinstanceids = array[]::text[] where dimensionalityinstanceids is null;
update shadow.observationcollection voc set regionofspaceids = (select array_agg(distinct foo.regionofspace) from (select ors.regionofspace from shadow.observation_regionofspace ors join shadow.observation_observationcollection ooc on ors.observation=ooc.observation where voc.id=ooc.observationcollection) foo );
update shadow.observationcollection voc set regionofspaceids = array[]::text[] where regionofspaceids is null;

-- observed property
update shadow.observedproperty vop set observationcollectionids = (select array_agg(distinct foo.observationcollection) from (select ooc.observationcollection from shadow.observation_observationcollection ooc join shadow.observation_observedproperty oop on ooc.observation = oop.observation where vop.id=oop.observedproperty) foo );
update shadow.observedproperty vop set observationcollectionids = array[]::text[] where observationcollectionids is null;

-- platform
update shadow.platform vp set observationcollectionids = (select array_agg(distinct foo.observationcollection) from (select ooc.observationcollection from shadow.observation_observationcollection ooc join shadow.observation_platform op on ooc.observation = op.observation where vp.id=op.platform) foo );
update shadow.platform vp set observationcollectionids = array[]::text[] where observationcollectionids is null;

-- project
update shadow.project vp set observedpropertyids = (select array_agg(distinct foo.observedproperty) from (select oop.observedproperty from shadow.observation_observedproperty oop join shadow.observation_project op on oop.observation=op.observation where vp.id=op.project) foo );
update shadow.project vp set observedpropertyids = array[]::text[] where observationcollectionids is null;

-- measurand
update shadow.measurand vm set observationcollectionids = (select array_agg(distinct ooc.observationcollection) from shadow.observation_observationcollection ooc join shadow.observation_observedproperty oop on ooc.observation=oop.observation join public.observedproperty_measurand pom on oop.observedproperty=pom.observedproperty where vm.id=pom.measurand);
update shadow.measurand vm set observationcollectionids = array[]::text[] where observationcollectionids is null;

-- phenomenon
update shadow.phenomenon vp set observationcollectionids = (select array_agg(distinct ooc.observationcollection) from shadow.observation_observationcollection ooc join shadow.observation_observedproperty oop on ooc.observation=oop.observation join public.observedproperty_phenomenon pop on oop.observedproperty=pop.observedproperty where vp.id=pop.phenomenon);
update shadow.phenomenon vp set observationcollectionids = array[]::text[] where observationcollectionids is null;

-- qualifier
update shadow.qualifier vq set observationcollectionids = (select array_agg(distinct ooc.observationcollection) from shadow.observation_observationcollection ooc join shadow.observation_observedproperty oop on ooc.observation=oop.observation join public.observedproperty_qualifier poq on oop.observedproperty=poq.observedproperty where vq.id=poq.qualifier);
update shadow.qualifier vq set observationcollectionids = array[]::text[] where observationcollectionids is null;

-- instrument
update shadow.instrument vi set startdate = (select min(startdate) from shadow.observation vo join shadow.observation_instrument voi on vo.id=voi.observation where vi.id=voi.instrument);
update shadow.instrument vi set enddate = (select max(enddate) from shadow.observation vo join shadow.observation_instrument voi on vo.id=voi.observation where vi.id=voi.instrument);

--instrument type
update shadow.instrumenttype vit set startdate = (select min(startdate) from shadow.instrument vi where vi.instrumenttypeids @> array[vit.id]::text[]);
update shadow.instrumenttype vit set enddate = (select max(enddate) from shadow.instrument vi where vi.instrumenttypeids @> array[vit.id]::text[]);

-- computation
update shadow.computation vc set startdate = (select min(startdate) from shadow.observation vo join shadow.observation_computation voc on vo.id=voc.observation where vc.id=voc.computation);
update shadow.computation vc set enddate = (select max(enddate) from shadow.observation vo join shadow.observation_computation voc on vo.id=voc.observation where vc.id=voc.computation);

-- computation type
update shadow.computationtype vct set startdate = (select min(startdate) from shadow.computation vc where vc.computationtypeids @> array[vct.id]::text[]);
update shadow.computationtype vct set enddate = (select max(enddate) from shadow.computation vc where vc.computationtypeids @> array[vct.id]::text[]);

-- observation collections
update shadow.observationcollection voc set startdate = (select min(startdate) from shadow.observation vo join shadow.observation_observationcollection vooc on vo.id=vooc.observation where voc.id=vooc.observationcollection);
update shadow.observationcollection voc set enddate = (select max(enddate) from shadow.observation vo join shadow.observation_observationcollection vooc on vo.id=vooc.observation where voc.id=vooc.observationcollection);

-- observed proprties
update shadow.observedproperty vop set startdate = (select min(startdate) from shadow.observation vo join shadow.observation_observedproperty oop on vo.id=oop.observation where vop.id=oop.observedproperty);
update shadow.observedproperty vop set enddate = (select max(enddate) from shadow.observation vo join shadow.observation_observedproperty oop on vo.id=oop.observation where vop.id=oop.observedproperty);

-- platform
update shadow.platform vp set startdate = (select min(startdate) from shadow.observation vo join shadow.observation_platform vop on vo.id=vop.observation where vp.id=vop.platform);
update shadow.platform vp set enddate = (select max(enddate) from shadow.observation vo join shadow.observation_platform vop on vo.id=vop.observation where vp.id=vop.platform);

-- regionsofspace
update shadow.regionofspace vrs set startdate = (select min(startdate) from shadow.observation vo join shadow.observation_regionofspace vors on vo.id=vors.observation where vrs.id=vors.regionofspace);
update shadow.regionofspace vrs set enddate = (select max(enddate) from shadow.observation vo join shadow.observation_regionofspace vors on vo.id=vors.observation where vrs.id=vors.regionofspace);

-- dimensionalitytimeline
update shadow.dimensionalitytimeline vdt set startdate = (select min(startdate) from shadow.observation vo join shadow.observation_dimensionalitytimeline vodt on vo.id=vodt.observation where vdt.id=vodt.dimensionalitytimeline);
update shadow.dimensionalitytimeline vdt set enddate = (select max(enddate) from shadow.observation vo join shadow.observation_dimensionalitytimeline vodt on vo.id=vodt.observation where vdt.id=vodt.dimensionalitytimeline);

-- dimensionalityinstance
update shadow.dimensionalityinstance vdi set startdate = (select min(startdate) from shadow.observation vo join shadow.observation_dimensionalityinstance vodi on vo.id=vodi.observation where vdi.id=vodi.dimensionalityinstance);
update shadow.dimensionalityinstance vdi set enddate = (select max(enddate) from shadow.observation vo join shadow.observation_dimensionalityinstance vodi on vo.id=vodi.observation where vdi.id=vodi.dimensionalityinstance);

-- project
update shadow.project vp set startdate = (select min(startdate) from shadow.observation vo join shadow.observation_project vop on vo.id=vop.observation where vp.id=vop.project);
update shadow.project vp set enddate = (select max(enddate) from shadow.observation vo join shadow.observation_project vop on vo.id=vop.observation where vp.id=vop.project);

-- measurand
update shadow.measurand vm set startdate = (select min(startdate) from shadow.observedproperty vop where vop.measurandids @> array[vm.id]::text[]);
update shadow.measurand vm set enddate = (select max(enddate) from shadow.observedproperty vop where vop.measurandids @> array[vm.id]::text[]);

-- qualifier
update shadow.qualifier vq set startdate = (select min(startdate) from shadow.observedproperty vop where vop.qualifierids @> array[vq.id]::text[]);
update shadow.qualifier vq set enddate = (select max(enddate) from shadow.observedproperty vop where vop.qualifierids @> array[vq.id]::text[]);

-- phenomenon
update shadow.phenomenon vp set startdate = (select min(startdate) from shadow.observedproperty vop where vop.phenomenonids @> array[vp.id]::text[]);
update shadow.phenomenon vp set enddate = (select max(enddate) from shadow.observedproperty vop where vop.phenomenonids @> array[vp.id]::text[]);
