-- SELECT (TIMESTAMP WITHOUT TIME ZONE '2012-09-07 18:40:10');

select count(*) from (
	SELECT
	ac.acquisitionId AS dri_objidentifier -- acquisition
	FROM acquisition AS ac
	INNER JOIN instrument AS ins ON ins.instrumentId = ac.instrument
	INNER JOIN instrumentType AS it ON it.instrumentTypeId = ins.instrumentType
	LEFT JOIN dataProduct_acquisition AS dpa ON dpa.acquisition = ac.acquisitionId
	LEFT JOIN dataProduct AS dp ON dp.dataProductId = dpa.dataProduct
	INNER JOIN dataproducttype AS dpt ON dp.dataproducttype = dpt.dataproducttypeid
   INNER JOIN dataset_instrument AS di ON di.instrument = ins.instrumentId
   INNER JOIN dataset AS dats ON dats.datasetId = di.dataset
	INNER JOIN program AS pro ON pro.programId = dats.primaryProgram
	INNER JOIN organization AS org ON org.organizationId = pro.organization
	INNER JOIN observatory AS obs ON obs.observatoryId = ins.observatory
   LEFT JOIN
   (
      SELECT dataset,
         array_agg(ch.characteristicId) AS esf_characteristicid,
         array_agg(ch.name) AS esf_characteristicname,
         array_agg(ch.spaceRegionValue) AS esf_regionofspace,
         array_agg(ch.characteristicProperty) AS esf_characteristicproperty
      FROM dataset_characteristic AS dc
      INNER JOIN characteristic AS ch ON ch.characteristicId = dc.characteristic
      GROUP BY dc.dataset
   ) AS dc ON dc.dataset = dats.datasetId
	GROUP BY ac.acquisitionId, ac.time, ins.instrumentId, ins.name, it.instrumentTypeId,
	         it.value, dats.datasetId, dats.title, dats.description, dats.longitude,
	         dats.latitude, dats.altitude, dats.startDate, dats.endDate, org.organizationId,
	         org.name, org.acronym, obs.observatoryId, obs.name, obs.description, pro.programId,
	         pro.name,
            dc.esf_characteristicId, dc.esf_characteristicname,
            dc.esf_regionofspace, dc.esf_characteristicproperty
   ORDER BY ac.acquisitionId
) as records
;