/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.enabling.manager.msro.espas.wf.util;

import eu.dnetlib.enabling.manager.msro.espas.wf.util.Resource;
import eu.dnetlib.enabling.manager.msro.espas.wf.util.TreeNode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class Tree<E extends Resource> {
    private TreeNode<E> root;
    private Map<String, List<TreeNode<E>>> nodesToAdd = new HashMap<String, List<TreeNode<E>>>();

    public Tree() {
        this.root = new TreeNode<Object>(null);
    }

    public boolean contains(String elementId) {
        return this.existsNodeWithId(elementId) != null;
    }

    public void addElement(String parentId, E element) {
        TreeNode<E> node = new TreeNode<E>(element);
        this.addNode(parentId, node);
    }

    public List<E> traverse(TraversalOrder traversalOrder) {
        ArrayList<TreeNode<E>> traverseList = new ArrayList<TreeNode<E>>();
        ArrayList listOfElements = new ArrayList();
        if (traversalOrder.equals((Object)TraversalOrder.BREADTH_FIRST_TRAVERSAL)) {
            this.buildBreadthFirstOrder(this.root, traverseList);
        } else {
            this.buildDepthFirstOrder(this.root, traverseList);
        }
        for (int i = 0; i < traverseList.size(); ++i) {
            if (traverseList.get(i) == this.root) continue;
            listOfElements.add(((TreeNode)traverseList.get(i)).getResource());
        }
        return listOfElements;
    }

    private TreeNode<E> existsNodeWithId(String treeNodeId) {
        return this.findNodeWithId(this.root, treeNodeId);
    }

    private TreeNode<E> findNodeWithId(TreeNode<E> currentNode, String treeNodeId) {
        TreeNode<E> returnNode;
        block2: {
            TreeNode<E> child;
            block1: {
                returnNode = null;
                if (currentNode == this.root || !((Resource)currentNode.getResource()).getId().equals(treeNodeId)) break block1;
                returnNode = currentNode;
                break block2;
            }
            if (!currentNode.hasChildren()) break block2;
            Iterator<TreeNode<E>> i$ = currentNode.getChildren().iterator();
            while (i$.hasNext() && (returnNode = this.findNodeWithId(child = i$.next(), treeNodeId)) == null) {
            }
        }
        return returnNode;
    }

    private void addNode(String parentId, TreeNode<E> node) {
        TreeNode<E> parentNode = null;
        if (parentId == null || parentId.equals("")) {
            this.root.addChild(node);
            if (this.nodesToAdd.containsKey(((Resource)node.getResource()).getId())) {
                for (TreeNode<E> child : this.nodesToAdd.get(((Resource)node.getResource()).getId())) {
                    this.addNode(((Resource)node.getResource()).getId(), child);
                }
            }
        } else {
            parentNode = this.existsNodeWithId(parentId);
            if (parentNode != null) {
                parentNode.addChild(node);
                if (this.nodesToAdd.containsKey(((Resource)node.getResource()).getId())) {
                    for (TreeNode<E> child : this.nodesToAdd.get(((Resource)node.getResource()).getId())) {
                        this.addNode(((Resource)node.getResource()).getId(), child);
                    }
                }
            } else if (this.nodesToAdd.containsKey(parentId)) {
                List<TreeNode<TreeNode<E>>> children = this.nodesToAdd.get(parentId);
                children.add(node);
            } else {
                ArrayList<TreeNode<E>> children = new ArrayList<TreeNode<E>>();
                children.add(node);
                this.nodesToAdd.put(parentId, children);
            }
        }
    }

    private void buildBreadthFirstOrder(TreeNode<E> root, List<TreeNode<E>> traverseList) {
        LinkedList queue = new LinkedList();
        queue.add(root);
        while (!queue.isEmpty()) {
            TreeNode node = (TreeNode)queue.remove();
            traverseList.add(node);
            if (!node.hasChildren()) continue;
            queue.addAll(node.getChildren());
        }
    }

    private void buildDepthFirstOrder(TreeNode<E> node, List<TreeNode<E>> traverseList) {
        traverseList.add(node);
        for (TreeNode<E> child : node.getChildren()) {
            this.buildBreadthFirstOrder(child, traverseList);
        }
    }

    public static enum TraversalOrder {
        BREADTH_FIRST_TRAVERSAL,
        DEPTH_FIRST_TRAVERSAL;

    }
}

