/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.enabling.manager.msro.espas.wf.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import javax.sql.DataSource;
import org.apache.log4j.Logger;
import org.springframework.core.io.Resource;
import org.springframework.transaction.annotation.Transactional;

public class DBUpdatesUtil {
    private static Logger log = Logger.getLogger(DBUpdatesUtil.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Transactional
    public static void executeUpdates(DataSource datasource, Resource commands) throws IOException, SQLException {
        BufferedReader in = new BufferedReader(new InputStreamReader(commands.getInputStream()));
        String line = null;
        while ((line = in.readLine()) != null) {
            if (line.trim().length() == 0 || line.startsWith("--")) continue;
            Connection con = null;
            Statement stmt = null;
            try {
                con = datasource.getConnection();
                stmt = con.prepareStatement(line);
                log.warn((Object)("Executing update: " + line));
                stmt.executeUpdate();
            }
            catch (SQLException e) {
                log.error((Object)("Error executing update: " + line), (Throwable)e);
            }
            finally {
                if (stmt != null) {
                    stmt.close();
                }
                if (con == null) continue;
                con.close();
            }
        }
    }
}

