/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.enabling.manager.msro.espas.wf.dm;

import com.googlecode.sarasvati.Arc;
import com.googlecode.sarasvati.Engine;
import com.googlecode.sarasvati.NodeToken;
import com.sun.xml.bind.api.JAXBRIContext;
import eu.dnetlib.enabling.manager.msro.espas.wf.dm.DownloadDBUtils;
import eu.dnetlib.enabling.manager.msro.espas.wf.dm.DownloadRequestListHolder;
import eu.dnetlib.espas.download.jaxb.RESOURCEPROFILE;
import eu.dnetlib.workflow.AbstractJobNode;
import java.io.Reader;
import java.io.StringReader;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ProviderStatusUpdateJob
extends AbstractJobNode {
    static final String JOB_STATUS_VARIABLE = "localRequestStatus";
    static final String PROVIDER_URL_VARIABLE = "localRequestDownloadUrl";
    private static final Log _logger = LogFactory.getLog(ProviderStatusUpdateJob.class);
    private DownloadDBUtils downloadDBUtils;

    public void execute(Engine engine, NodeToken token) {
        super.execute(engine, token);
        String nodeName = this.getName();
        int threadIndex = Integer.parseInt(nodeName.substring(nodeName.lastIndexOf("_") + 1)) - 1;
        DownloadRequestListHolder jobListHolder = (DownloadRequestListHolder)token.getProcess().getEnv().getTransientAttribute("DownloadRequest_Var");
        String providerId = jobListHolder.popProviderJob(threadIndex);
        String jobStatus = token.getEnv().getAttribute(JOB_STATUS_VARIABLE);
        String downloadURL = token.getEnv().getAttribute(PROVIDER_URL_VARIABLE);
        try {
            long jobId = this.getJobId(token);
            if (jobStatus.equalsIgnoreCase("COMPLETED")) {
                this.downloadDBUtils.updateProviderDetails(jobId, providerId, jobStatus, "", downloadURL);
            }
        }
        catch (Exception e) {
            _logger.error((Object)("Error while updating provider [" + providerId + "] status for jod "), (Throwable)e);
        }
        engine.complete(token, Arc.DEFAULT_ARC);
    }

    private long getJobId(NodeToken token) {
        return Long.parseLong(token.getFullEnv().getAttribute("DownloadJobId_Var"));
    }

    private String getResourceProfileConfiguration(NodeToken token) {
        return token.getFullEnv().getAttribute("resourceProfile");
    }

    private RESOURCEPROFILE deSerializeProfile(String downloadRequestType) throws JAXBException {
        JAXBContext marshallingContxt = JAXBRIContext.newInstance((Class[])new Class[]{RESOURCEPROFILE.class});
        _logger.error((Object)("Deserializing " + downloadRequestType));
        RESOURCEPROFILE result = (RESOURCEPROFILE)marshallingContxt.createUnmarshaller().unmarshal((Reader)new StringReader(downloadRequestType));
        return result;
    }

    public DownloadDBUtils getDownloadDBUtils() {
        return this.downloadDBUtils;
    }

    public void setDownloadDBUtils(DownloadDBUtils downloadDBUtils) {
        this.downloadDBUtils = downloadDBUtils;
    }
}

