/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.enabling.manager.msro.espas.wf.dm;

import com.googlecode.sarasvati.Engine;
import com.googlecode.sarasvati.NodeToken;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpException;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpService;
import eu.dnetlib.enabling.manager.msro.espas.wf.dm.DownloadDBUtils;
import eu.dnetlib.enabling.manager.msro.espas.wf.dm.DownloadRequestListHolder;
import eu.dnetlib.enabling.tools.ServiceLocator;
import eu.dnetlib.enabling.tools.blackboard.BlackboardJob;
import eu.dnetlib.workflow.AbstractBlackboardWorkflowJobListener;
import eu.dnetlib.workflow.BlackboardJobNode;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LocalDownloadJob
extends BlackboardJobNode {
    private static Log _logger = LogFactory.getLog(LocalDownloadJob.class);
    private ServiceLocator<ISLookUpService> lookupLocator;
    private DownloadDBUtils downloadDBUtils;

    protected String locateService(NodeToken token) {
        String nodeName = this.getName();
        int threadIndex = Integer.parseInt(nodeName.substring(nodeName.lastIndexOf("_") + 1)) - 1;
        DownloadRequestListHolder jobListHolder = (DownloadRequestListHolder)token.getProcess().getEnv().getTransientAttribute("DownloadRequest_Var");
        String providerId = jobListHolder.popProviderJob(threadIndex);
        String[] providerDetails = this.downloadDBUtils.getProviderDetails(providerId);
        String providerServiceURL = "";
        if (providerDetails != null) {
            providerServiceURL = providerDetails[1];
        }
        String query = "//RESOURCE_PROFILE[.//RESOURCE_TYPE/@value = 'LocalDownloadManagerServiceResourceType' and starts-with(.//RESOURCE_URI/@value,'" + providerServiceURL + "')]//RESOURCE_IDENTIFIER/@value/string()";
        try {
            return ((ISLookUpService)this.lookupLocator.getService()).getResourceProfileByQuery(query);
        }
        catch (ISLookUpException e) {
            this.downloadDBUtils.updateProviderDetails(this.getJobId(token), providerId, "FAILED", "Unable to connect to local download service of provider :" + providerDetails[0], "");
            return null;
        }
    }

    protected void prepareJob(BlackboardJob job, NodeToken token) {
        try {
            DownloadRequestListHolder jobListHolder = (DownloadRequestListHolder)token.getProcess().getEnv().getTransientAttribute("DownloadRequest_Var");
            String nodeName = this.getName();
            int threadIndex = Integer.parseInt(nodeName.substring(nodeName.lastIndexOf("_") + 1)) - 1;
            long jobId = this.getJobId(token);
            String providerId = jobListHolder.popProviderJob(threadIndex);
            String providerJobStatus = this.downloadDBUtils.getProviderJobStatus(jobId, providerId);
            if (providerJobStatus.equalsIgnoreCase("FAILED")) {
                job.setError("Failed due to Policy or other type of exception");
            } else {
                job.getParameters().put("downloadJob", "" + jobId);
                job.getParameters().put("providerJob", providerId);
                job.setAction("START-LOCAL_DOWNLOADING");
            }
        }
        catch (Exception e) {
            _logger.error((Object)"Error starting local download job", (Throwable)e);
        }
    }

    private long getJobId(NodeToken token) {
        return Long.parseLong(token.getFullEnv().getAttribute("DownloadJobId_Var"));
    }

    protected AbstractBlackboardWorkflowJobListener createJobListener(Engine engine, NodeToken token) {
        return super.createJobListener(engine, token);
    }

    public ServiceLocator<ISLookUpService> getLookupLocator() {
        return this.lookupLocator;
    }

    public void setLookupLocator(ServiceLocator<ISLookUpService> lookupLocator) {
        this.lookupLocator = lookupLocator;
    }

    public DownloadDBUtils getDownloadDBUtils() {
        return this.downloadDBUtils;
    }

    public void setDownloadDBUtils(DownloadDBUtils downloadDBUtils) {
        this.downloadDBUtils = downloadDBUtils;
    }
}

