/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.enabling.manager.msro.espas.wf.dm;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.LinkedList;
import javax.sql.DataSource;
import org.apache.log4j.Logger;
import org.springframework.transaction.annotation.Transactional;

public class DownloadDBUtils {
    private static final Logger _logger = Logger.getLogger(DownloadDBUtils.class);
    private DataSource downlodDBSource;
    private boolean inited = false;
    private static final String getProvidersCountQ = "select count(providerid) from download.providerjob where download.providerjob.jobid=?";
    private static final String getProviderDetailsQ = "select namespace, url, name from dataprovider where namespace=?";
    private static final String getProviderRequestDetailsQ = "select download.request.requestid, download.request.status from download.providerjob join download.request on (download.providerjob.jobid=download.request.jobid and download.providerjob.providerid=download.request.providerid) where download.providerjob.jobid=? and download.providerjob.providerid=?";
    private static final String getJobProvidersQ = "select download.providerjob.providerid from download.providerjob where download.providerjob.jobid=?";
    private static final String getProviderStatusQ = "select status from download.providerjob where jobid=? and providerid=?";
    private static final String setProviderStatusQ = "update download.providerjob set status=?, jobstatusreport=?, downloadurl=? where jobid=? and providerid=?";
    private static final String setJobStatusQ = "update download.downloadjob set status=?, statusreport=? where jobid=?";
    private static PreparedStatement getProvidersCountStm;
    private static PreparedStatement getProviderDetailsStm;
    private static PreparedStatement getProviderRequestDetailsStm;
    private static PreparedStatement getProviderJobsDetailStm;
    private static PreparedStatement getProviderStatusStm;
    private static PreparedStatement setProviderStatusStm;
    private static PreparedStatement setJobStatusStm;
    private Connection dbConnection;

    private void init() throws SQLException {
        if (!this.inited || this.dbConnection.isClosed() || this.dbConnection == null) {
            this.dbConnection = this.downlodDBSource.getConnection();
            getProvidersCountStm = this.dbConnection.prepareStatement(getProvidersCountQ);
            getProviderDetailsStm = this.dbConnection.prepareStatement(getProviderDetailsQ);
            getProviderJobsDetailStm = this.dbConnection.prepareStatement(getJobProvidersQ);
            getProviderRequestDetailsStm = this.dbConnection.prepareStatement(getProviderRequestDetailsQ);
            getProviderStatusStm = this.dbConnection.prepareStatement(getProviderStatusQ);
            setProviderStatusStm = this.dbConnection.prepareStatement(setProviderStatusQ);
            setJobStatusStm = this.dbConnection.prepareStatement(setJobStatusQ);
            this.inited = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<String> getProvidersJobDetails(Long jobId) {
        LinkedList<String> results = new LinkedList<String>();
        try {
            this.init();
            getProviderJobsDetailStm.clearParameters();
            getProviderJobsDetailStm.setString(1, jobId.toString());
            ResultSet providerRequests = getProviderJobsDetailStm.executeQuery();
            while (providerRequests.next()) {
                String providerId = providerRequests.getString(1);
                results.add(providerId);
            }
            providerRequests.close();
        }
        catch (SQLException ex) {
            _logger.error((Object)"Exception while retrieving provider job details from database!", (Throwable)ex);
        }
        finally {
            return results;
        }
    }

    public synchronized int getProviderJobsCount(Long jobId) {
        try {
            this.init();
            getProvidersCountStm.clearParameters();
            getProvidersCountStm.setString(1, jobId.toString());
            ResultSet providerRS = getProvidersCountStm.executeQuery();
            if (providerRS.next()) {
                int result = providerRS.getInt(1);
                providerRS.close();
                return result;
            }
            providerRS.close();
            return 0;
        }
        catch (SQLException ex) {
            _logger.error((Object)"Unable to retrieve download job details from the database!", (Throwable)ex);
            return -1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized String[] getProviderDetails(String providerId) {
        String[] providerDetails = null;
        try {
            this.init();
            getProviderDetailsStm.clearParameters();
            getProviderDetailsStm.setString(1, providerId);
            ResultSet providerRS = getProviderDetailsStm.executeQuery();
            if (providerRS.next()) {
                providerDetails = new String[]{providerRS.getString(1), providerRS.getString(2), providerRS.getString(3)};
            }
            providerRS.close();
        }
        catch (SQLException ex) {
            _logger.error((Object)"Unable to retrieve download job details from the database!", (Throwable)ex);
        }
        finally {
            return providerDetails;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized String getProviderJobStatus(long jobId, String providerId) {
        String providerStatus = null;
        try {
            this.init();
            getProviderStatusStm.clearParameters();
            getProviderStatusStm.setString(1, jobId + "");
            getProviderStatusStm.setString(2, providerId);
            ResultSet providerRS = getProviderStatusStm.executeQuery();
            if (providerRS.next()) {
                providerStatus = providerRS.getString(1);
            }
            providerRS.close();
        }
        catch (SQLException ex) {
            _logger.error((Object)"Unable to retrieve provider status from the database!", (Throwable)ex);
        }
        finally {
            return providerStatus;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Collection<String[]> getProviderJobs(Long jobId, String providerId) {
        LinkedList<String[]> results = new LinkedList<String[]>();
        try {
            this.init();
            getProviderRequestDetailsStm.clearParameters();
            getProviderRequestDetailsStm.setString(1, jobId.toString());
            getProviderRequestDetailsStm.setString(2, providerId);
            ResultSet providerRequests = getProviderRequestDetailsStm.executeQuery();
            while (providerRequests.next()) {
                String requestId = providerRequests.getString(1);
                String status = providerRequests.getString(2);
                results.add(new String[]{requestId, status});
            }
            providerRequests.close();
        }
        catch (SQLException ex) {
            _logger.error((Object)"Exception while retrieving provider job details from database!", (Throwable)ex);
        }
        finally {
            return results;
        }
    }

    @Transactional
    void updateJobDetails(long jobId, String status, String statusreport) {
        try {
            this.init();
            setJobStatusStm.clearParameters();
            setJobStatusStm.setString(1, status);
            setJobStatusStm.setString(2, statusreport);
            setJobStatusStm.setString(3, jobId + "");
            setJobStatusStm.executeUpdate();
        }
        catch (SQLException ex) {
            _logger.error((Object)"Exception while updating job details in database!", (Throwable)ex);
        }
    }

    @Transactional
    public synchronized void updateProviderDetails(long jobId, String providerId, String jobStatus, String statusreport, String downloadURL) {
        try {
            this.init();
            setProviderStatusStm.clearParameters();
            setProviderStatusStm.setString(1, jobStatus);
            setProviderStatusStm.setString(2, statusreport);
            setProviderStatusStm.setString(3, downloadURL);
            setProviderStatusStm.setString(4, jobId + "");
            setProviderStatusStm.setString(5, providerId);
        }
        catch (SQLException ex) {
            _logger.error((Object)"Exception while updating provider job details in database!", (Throwable)ex);
        }
    }

    public DataSource getDownlodDBSource() {
        return this.downlodDBSource;
    }

    public void setDownlodDBSource(DataSource downlodDBSource) {
        this.downlodDBSource = downlodDBSource;
    }
}

