/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.enabling.manager.msro.espas.wf.dm;

import com.googlecode.sarasvati.Arc;
import com.googlecode.sarasvati.Engine;
import com.googlecode.sarasvati.NodeToken;
import eu.dnetlib.enabling.manager.msro.espas.wf.dm.DownloadDBUtils;
import eu.dnetlib.enabling.manager.msro.espas.wf.dm.DownloadRequestListHolder;
import eu.dnetlib.workflow.AbstractJobNode;
import org.apache.log4j.Logger;

public class ConsolidateDownloadLinksJob
extends AbstractJobNode {
    private static final Logger _logger = Logger.getLogger(ConsolidateDownloadLinksJob.class);
    private DownloadDBUtils downloadDBUtils;

    public void execute(Engine engine, NodeToken token) {
        long jobId = this.getJobId(token);
        try {
            super.execute(engine, token);
            DownloadRequestListHolder jobListHolder = (DownloadRequestListHolder)token.getProcess().getEnv().getTransientAttribute("DownloadRequest_Var");
            boolean allFailed = true;
            for (String providerId : jobListHolder.getProviderJobList()) {
                String providerStatus = this.downloadDBUtils.getProviderJobStatus(jobId, providerId);
                if (!providerStatus.equalsIgnoreCase("COMPLETED")) continue;
                allFailed = false;
            }
            if (!allFailed) {
                this.downloadDBUtils.updateJobDetails(jobId, "COMPLETED", "Download request has been processed successfully.");
                engine.complete(token, Arc.DEFAULT_ARC);
            } else {
                this.downloadDBUtils.updateJobDetails(jobId, "FAILED", "Processing of download requests has failed due to policy or other types of exceptions.");
                engine.complete(token, "failed");
            }
        }
        catch (Exception ex) {
            _logger.error((Object)"", (Throwable)ex);
            this.downloadDBUtils.updateJobDetails(jobId, "FAILED", "Processing of download requests has failed due to policy or other types of exceptions.");
            engine.complete(token, "failed");
        }
    }

    private long getJobId(NodeToken token) {
        return Long.parseLong(token.getFullEnv().getAttribute("DownloadJobId_Var"));
    }

    public DownloadDBUtils getDownloadDBUtils() {
        return this.downloadDBUtils;
    }

    public void setDownloadDBUtils(DownloadDBUtils downloadDBUtils) {
        this.downloadDBUtils = downloadDBUtils;
    }
}

