/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.enabling.manager.msro.espas.wf.dm;

import com.googlecode.sarasvati.Arc;
import com.googlecode.sarasvati.Engine;
import com.googlecode.sarasvati.NodeToken;
import com.sun.xml.bind.api.JAXBRIContext;
import eu.dnetlib.enabling.manager.msro.espas.wf.dm.DownloadDBUtils;
import eu.dnetlib.enabling.manager.msro.espas.wf.dm.DownloadRequestListHolder;
import eu.dnetlib.espas.download.jaxb.RESOURCEPROFILE;
import eu.dnetlib.workflow.AbstractJobNode;
import java.io.Reader;
import java.io.StringReader;
import java.util.Collection;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AssignDownloadJob
extends AbstractJobNode {
    private final Log _logger = LogFactory.getLog(((Object)((Object)this)).getClass());
    static final String DOWNLOADLIST_ENV_VARIABLE = "DownloadRequest_Var";
    static final String DOWNLOADJOBID_ENV_VARIABLE = "DownloadJobId_Var";
    private DownloadDBUtils downloadDBUtils;

    public void execute(Engine engine, NodeToken token) {
        super.execute(engine, token);
        this._logger.info((Object)"processing download request ");
        DownloadRequestListHolder jobListHolder = this.prepareDownloadRequestList(token);
        if (jobListHolder != null && !jobListHolder.isEmtpy()) {
            this._logger.error((Object)("Adding holder: " + jobListHolder));
            token.getProcess().getEnv().setTransientAttribute(DOWNLOADLIST_ENV_VARIABLE, (Object)jobListHolder);
            this._logger.debug((Object)"AssignDownloadJob finished successfully.");
            engine.complete(token, Arc.DEFAULT_ARC);
        } else {
            this._logger.debug((Object)"AssignDownloadJob failed.");
            engine.complete(token, "failed");
        }
    }

    private DownloadRequestListHolder prepareDownloadRequestList(NodeToken token) {
        try {
            DownloadRequestListHolder downloadRequestHolder = new DownloadRequestListHolder();
            String resourceProfile = this.getResourceProfileConfiguration(token);
            RESOURCEPROFILE xmlDownloadRequest = this.deSerializeProfile(resourceProfile);
            long jobId = xmlDownloadRequest.getBODY().getCONFIGURATION().getDOWNLOADID();
            token.getFullEnv().setAttribute(DOWNLOADJOBID_ENV_VARIABLE, (Object)jobId);
            Collection<String> providersList = this.downloadDBUtils.getProvidersJobDetails(jobId);
            for (String providerId : providersList) {
                downloadRequestHolder.pushProviderJob(providerId);
            }
            downloadRequestHolder.setRequestId(xmlDownloadRequest.getBODY().getCONFIGURATION().getDOWNLOADID());
            return downloadRequestHolder;
        }
        catch (Exception ex) {
            this._logger.error((Object)"Error creating job holder", (Throwable)ex);
            return null;
        }
    }

    private String getResourceProfileConfiguration(NodeToken token) {
        return token.getFullEnv().getAttribute("resourceProfile");
    }

    private RESOURCEPROFILE deSerializeProfile(String downloadRequestType) throws JAXBException {
        JAXBContext marshallingContxt = JAXBRIContext.newInstance((Class[])new Class[]{RESOURCEPROFILE.class});
        this._logger.error((Object)("Deserializing " + downloadRequestType));
        RESOURCEPROFILE result = (RESOURCEPROFILE)marshallingContxt.createUnmarshaller().unmarshal((Reader)new StringReader(downloadRequestType));
        return result;
    }

    public DownloadDBUtils getDownloadDBUtils() {
        return this.downloadDBUtils;
    }

    public void setDownloadDBUtils(DownloadDBUtils downloadDBUtils) {
        this.downloadDBUtils = downloadDBUtils;
    }
}

