/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.enabling.manager.msro.espas.wf;

import com.googlecode.sarasvati.Arc;
import com.googlecode.sarasvati.Engine;
import com.googlecode.sarasvati.NodeToken;
import eu.dnetlib.enabling.manager.msro.espas.wf.OntologyRSListener;
import eu.dnetlib.enabling.resultset.ResultSetFactory;
import eu.dnetlib.enabling.resultset.ResultSetListener;
import eu.dnetlib.workflow.AbstractJobNode;
import java.io.IOException;
import java.net.URL;
import java.util.List;
import javax.xml.ws.wsaddressing.W3CEndpointReference;
import org.apache.commons.httpclient.util.URIUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class OntologyReaderJob
extends AbstractJobNode {
    private List<URL> ontologyUrls = null;
    private Log logger = LogFactory.getLog(((Object)((Object)this)).getClass());
    private ResultSetFactory rsFactory = null;

    public void execute(Engine engine, NodeToken token) {
        try {
            W3CEndpointReference epr = this.rsFactory.createResultSet((ResultSetListener)new OntologyRSListener(this.ontologyUrls));
            this.logger.debug((Object)("Setting dataSource to " + epr.toString()));
            token.getFullEnv().setAttribute("dataSource", "dnet://EPR/" + URIUtil.encodePath((String)epr.toString()));
        }
        catch (IOException e) {
            this.logger.error((Object)"Error reading ontology", (Throwable)e);
        }
        engine.complete(token, Arc.DEFAULT_ARC);
    }

    public List<URL> getOntologyUrls() {
        return this.ontologyUrls;
    }

    public void setOntologyUrls(List<URL> ontologyUrls) {
        this.ontologyUrls = ontologyUrls;
    }

    public ResultSetFactory getRsFactory() {
        return this.rsFactory;
    }

    public void setRsFactory(ResultSetFactory rsFactory) {
        this.rsFactory = rsFactory;
    }
}

