/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.enabling.manager.msro.espas.wf;

import eu.dnetlib.enabling.manager.msro.espas.wf.util.OntologyUtil;
import eu.dnetlib.enabling.resultset.ResultSetListener;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.GZIPInputStream;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

class OntologyRSListener
implements ResultSetListener {
    Log logger = LogFactory.getLog(this.getClass());
    private List<String> xmls = new ArrayList<String>();

    public OntologyRSListener(List<URL> ontologyURLS) throws IOException {
        for (URL url : ontologyURLS) {
            this.logger.debug((Object)("Reading ontology from url" + url.toString()));
            InputStream is = this.downloadOntology(url);
            this.xmls.add(OntologyUtil.reorderConcepts(is));
        }
    }

    public List<String> getResult(int fromPosition, int toPosition) {
        this.logger.info((Object)("Returning from " + fromPosition + "  to " + toPosition));
        return this.xmls.subList(fromPosition - 1, toPosition);
    }

    public int getSize() {
        this.logger.info((Object)("Size: " + this.xmls.size()));
        return this.xmls.size();
    }

    private InputStream downloadOntology(URL url) throws IOException {
        InputStream inStr = null;
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        HttpURLConnection.setFollowRedirects(true);
        conn.setRequestProperty("Accept-Encoding", "gzip, deflate");
        String encoding = conn.getContentEncoding();
        inStr = encoding != null && encoding.equalsIgnoreCase("gzip") ? new GZIPInputStream(conn.getInputStream()) : (encoding != null && encoding.equalsIgnoreCase("deflate") ? new InflaterInputStream(conn.getInputStream(), new Inflater(true)) : conn.getInputStream());
        return inStr;
    }
}

