/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.enabling.manager.msro.espas.wf;

import com.googlecode.sarasvati.Arc;
import com.googlecode.sarasvati.Engine;
import com.googlecode.sarasvati.NodeToken;
import eu.dnetlib.enabling.is.registry.rmi.ISRegistryException;
import eu.dnetlib.enabling.is.registry.rmi.ISRegistryService;
import eu.dnetlib.enabling.tools.ServiceLocator;
import eu.dnetlib.workflow.AbstractJobNode;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AssignMDStoreJob
extends AbstractJobNode {
    private static final Log log = LogFactory.getLog(AssignMDStoreJob.class);
    private ServiceLocator<ISRegistryService> registryLocator;

    public void execute(Engine engine, NodeToken token) {
        String mdId = token.getEnv().getAttribute("emf_native_id");
        String cswId = token.getProcess().getEnv().getAttribute("cswId");
        String query = "for $x in collection('')//RESOURCE_PROFILE[.//RESOURCE_IDENTIFIER[@value='" + cswId + "']]" + " return (update value $x//DATA_SINK  with 'dnet://MDStoreDS/" + mdId + "?type=REFRESH')";
        log.info((Object)("Executing " + query));
        try {
            ((ISRegistryService)this.getRegistryLocator().getService()).executeXUpdate(query);
        }
        catch (ISRegistryException e) {
            log.error((Object)"Error assigning md store to csw", (Throwable)e);
        }
        engine.complete(token, Arc.DEFAULT_ARC);
    }

    public ServiceLocator<ISRegistryService> getRegistryLocator() {
        return this.registryLocator;
    }

    public void setRegistryLocator(ServiceLocator<ISRegistryService> registryLocator) {
        this.registryLocator = registryLocator;
    }
}

