/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.enabling.manager.msro.espas;

import com.googlecode.sarasvati.Engine;
import com.googlecode.sarasvati.Graph;
import com.googlecode.sarasvati.GraphProcess;
import com.googlecode.sarasvati.env.Env;
import eu.dnetlib.enabling.actions.AbstractSubscriptionAction;
import eu.dnetlib.enabling.manager.msro.espas.wf.dm.DownloadDBUtils;
import eu.dnetlib.enabling.manager.msro.espas.wf.dm.UpdateProcess;
import eu.dnetlib.espas.download.jaxb.DOWNLOADREQUESTTYPE;
import eu.dnetlib.espas.download.jaxb.RESOURCEPROFILE;
import eu.dnetlib.workflow.GraphProcessRegistry;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.namespace.QName;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.core.io.Resource;

public class DownloadManagerNotificationHandler
extends AbstractSubscriptionAction {
    private static final Log log = LogFactory.getLog(DownloadManagerNotificationHandler.class);
    private transient Engine engine;
    private GraphProcessRegistry processRegistry;
    private DownloadDBUtils downloadDBUtils;
    private Resource graphTemplate = null;

    public void notified(String subscrId, String topic, String rsId, String profile) {
        log.info((Object)("Download notification: " + topic + "(" + (Object)((Object)this) + ")"));
        if (!topic.startsWith(this.getTopicPrefix())) {
            return;
        }
        log.info((Object)("Download notification matched, processing " + topic));
        try {
            RESOURCEPROFILE resourceprofile = this.getResourceProfile(profile);
            Long downloadJobId = resourceprofile.getBODY().getCONFIGURATION().getDOWNLOADID();
            int providerCount = this.downloadDBUtils.getProviderJobsCount(downloadJobId);
            if (providerCount <= 0) {
                log.error((Object)("counted providers are: " + providerCount));
                return;
            }
            UpdateProcess updateProcess = new UpdateProcess(this.graphTemplate);
            log.error((Object)("providers: " + providerCount));
            updateProcess.insertParallelDownloadThreads(providerCount - 1);
            String graphDescription = updateProcess.getUpdatedProcess();
            log.error((Object)("final graph: " + graphDescription));
            File tmpFile = File.createTempFile("wftfs", null);
            IOUtils.copy((Reader)new StringReader(graphDescription), (OutputStream)new FileOutputStream(tmpFile));
            this.engine.getLoader().load(tmpFile);
            Graph graph = this.engine.getRepository().getLatestGraph("cswLDownloadGraph");
            if (graph == null) {
                throw new IllegalArgumentException("graph called cswLDownloadGraph doesn't exist");
            }
            GraphProcess process = this.engine.getFactory().newProcess(graph);
            this.processRegistry.associateProcessWithResource(process, rsId);
            Env env = process.getEnv();
            env.setAttribute("resourceProfile", profile);
            this.engine.startProcess(process);
        }
        catch (JAXBException e) {
            log.error((Object)"Error unmarshalling profile", (Throwable)e);
        }
        catch (IOException e) {
            log.error((Object)"Error creating graph", (Throwable)e);
        }
    }

    @Deprecated
    private String getDownloadRequest(RESOURCEPROFILE resourceprofile) throws JAXBException {
        JAXBContext jc = JAXBContext.newInstance((Class[])new Class[]{DOWNLOADREQUESTTYPE.class});
        Marshaller marshaller = jc.createMarshaller();
        StringWriter sw = new StringWriter();
        marshaller.setProperty("jaxb.fragment", (Object)Boolean.TRUE);
        JAXBElement je = new JAXBElement(QName.valueOf("DOWNLOAD_REQUEST"), DOWNLOADREQUESTTYPE.class, (Object)resourceprofile.getBODY().getCONFIGURATION().getDOWNLOADREQUEST());
        marshaller.marshal((Object)je, (Writer)sw);
        return sw.toString();
    }

    private RESOURCEPROFILE getResourceProfile(String profile) throws JAXBException {
        JAXBContext jc = JAXBContext.newInstance((Class[])new Class[]{RESOURCEPROFILE.class});
        Unmarshaller unmarshaller = jc.createUnmarshaller();
        return (RESOURCEPROFILE)unmarshaller.unmarshal((Reader)new StringReader(profile));
    }

    public Engine getEngine() {
        return this.engine;
    }

    public void setEngine(Engine engine) {
        this.engine = engine;
    }

    public GraphProcessRegistry getProcessRegistry() {
        return this.processRegistry;
    }

    public void setProcessRegistry(GraphProcessRegistry processRegistry) {
        this.processRegistry = processRegistry;
    }

    public DownloadDBUtils getDownloadDBUtils() {
        return this.downloadDBUtils;
    }

    public void setDownloadDBUtils(DownloadDBUtils downloadDBUtils) {
        this.downloadDBUtils = downloadDBUtils;
    }

    public Resource getGraphTemplate() {
        return this.graphTemplate;
    }

    @Required
    public void setGraphTemplate(Resource graphTemplate) {
        this.graphTemplate = graphTemplate;
    }
}

