/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.enabling.manager.msro.espas;

import com.googlecode.sarasvati.GraphProcess;
import com.googlecode.sarasvati.env.Env;
import eu.dnetlib.data.information.MDStoreDataSinkSourceDescriptorGenerator;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpDocumentNotFoundException;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpException;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpService;
import eu.dnetlib.enabling.manager.msro.AbstractWorkflowLauncherNotificationHandler;
import eu.dnetlib.enabling.tools.ServiceLocator;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Required;

public class CSWReindexNotificationHandler
extends AbstractWorkflowLauncherNotificationHandler {
    private static final Log log = LogFactory.getLog(CSWReindexNotificationHandler.class);
    @Resource
    private MDStoreDataSinkSourceDescriptorGenerator sourceDescriptionGenerator;
    private ServiceLocator<ISLookUpService> lookupLocator;
    private String layout;

    public void prepareProcess(GraphProcess process, Env env, String rsId, String profile) {
        String query = "//RESOURCE_PROFILE[contains(.//DATA_SINK, '" + rsId + "')]//RESOURCE_IDENTIFIER/@value/string()";
        try {
            String repId = ((ISLookUpService)this.lookupLocator.getService()).getResourceProfileByQuery(query);
            this.getProcessRegistry().associateProcessWithResource(process, repId);
        }
        catch (ISLookUpDocumentNotFoundException e) {
            log.warn((Object)("cannot locate the repository associated with the mdstore " + rsId), (Throwable)e);
        }
        catch (ISLookUpException e) {
            log.warn((Object)("cannot locate the repository associated with the mdstore " + rsId), (Throwable)e);
        }
        String combinedQuery = "//RESOURCE_PROFILE[.//RESOURCE_IDENTIFIER/@value = '" + rsId + "']//METADATA_FORMAT/text()," + "//RESOURCE_PROFILE[.//RESOURCE_IDENTIFIER/@value = '" + rsId + "']//METADATA_FORMAT_INTERPRETATION/text()";
        try {
            List combined = ((ISLookUpService)this.lookupLocator.getService()).quickSearchProfile(combinedQuery);
            env.setAttribute("dataSource", this.sourceDescriptionGenerator.generateDataSourceDescriptor(rsId));
            env.setAttribute("mdId", rsId);
            env.setAttribute("format", (String)combined.get(0));
            env.setAttribute("interpretation", (String)combined.get(1));
            env.setAttribute("layout", this.getLayout());
        }
        catch (ISLookUpException e) {
            throw new IllegalStateException("cannot reindex", e);
        }
    }

    public ServiceLocator<ISLookUpService> getLookupLocator() {
        return this.lookupLocator;
    }

    public void setLookupLocator(ServiceLocator<ISLookUpService> lookupLocator) {
        this.lookupLocator = lookupLocator;
    }

    public String getLayout() {
        return this.layout;
    }

    @Required
    public void setLayout(String layout) {
        this.layout = layout;
    }

    public MDStoreDataSinkSourceDescriptorGenerator getSourceDescriptionGenerator() {
        return this.sourceDescriptionGenerator;
    }

    public void setSourceDescriptionGenerator(MDStoreDataSinkSourceDescriptorGenerator sourceDescriptionGenerator) {
        this.sourceDescriptionGenerator = sourceDescriptionGenerator;
    }
}

