<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:dc="http://purl.org/dc/elements/1.1/"
	xmlns:dr="http://www.driver-repository.eu/namespace/dr" xmlns:dri="http://www.driver-repository.eu/namespace/dri" 
	xmlns:oaa="http://namespace.openaire.eu/oaa" xmlns:oaf="http://namespace.openaire.eu/oaf"
	xmlns:dnet="eu.dnetlib.data.transform.xml.DNetClaimToHbaseXsltFunctions"
    xmlns:exslt="http://exslt.org/common" extension-element-prefixes="exslt" 
    exclude-result-prefixes="xsl dc dr dri oaa oaf dnet exslt">
    
    <xsl:output omit-xml-declaration="yes" indent="yes"/>
    
    <xsl:param name="mergeIdForHomonyms" select="true()" />
    <xsl:param name="writeCoAuthors" select="false()" />
    
	<xsl:template match="/*">
	
		<xsl:variable name="dateofcollection" select="//dr:dateOfCollection"/>
		
		<xsl:variable name="metadata" select="exslt:node-set(//*[local-name()='metadata']/*)" />
		<xsl:variable name="namespaceprefix">
			<xsl:choose>
			
				<!-- TODO check namespaceprefix length is 12 -->
				<xsl:when test="string-length(//oaf:datasourceprefix) &gt; 0">
					<xsl:value-of select="//oaf:datasourceprefix" />
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="unknown_" />
				</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
	
		<xsl:choose>
<!-- 			<xsl:when test="count($metadata) = 0 or string-length($namespaceprefix) = 0"> -->
			<xsl:when test="count($metadata) = 0">
				<ROWS/>
			</xsl:when>
			<xsl:otherwise>
			
				<xsl:variable name="objIdentifier" select="//dri:objIdentifier" />
				<xsl:variable name="resultId" select="dnet:oafSimpleId('result', //dri:objIdentifier)" />
				
				<xsl:if test="string-length($resultId) &gt; 0">
				
					<xsl:variable name="collectedfromid" select="dnet:oafSplitId('datasource', //oaf:collectedFrom/@id)" />
					<xsl:variable name="collectedfromname" select="//oaf:collectedFrom/@name" />
				
					<xsl:variable name="hostedbyid" select="dnet:oafSplitId('datasource', //oaf:hostedBy/@id)" />
					<xsl:variable name="hostedbyname" select="//oaf:hostedBy/@name" />
					
					<xsl:variable name="originalidTest" select="/record/*[local-name() = 'header']/*[local-name() = 'recordIdentifier']" />
					<xsl:variable name="originalid">
						<xsl:choose>
							<xsl:when test="contains($originalidTest, '::')">
								<xsl:value-of select="substring-after($originalidTest, '::')" />
							</xsl:when>
							<xsl:otherwise>
								<xsl:value-of select="$originalidTest" />
							</xsl:otherwise>
						</xsl:choose>
					</xsl:variable>
				
					<xsl:variable name="result" select="dnet:oafResultFromClaim($resultId, $hostedbyid, $hostedbyname, $collectedfromid, $collectedfromname, $originalid, $dateofcollection, $metadata)"/>
					
					<ROWS>
						<ROW key="{$resultId}" columnFamily="result">
							<QUALIFIER name="body" type="base64"><xsl:value-of select="$result" /></QUALIFIER>
						</ROW>
						
						<xsl:for-each select="//*[local-name()='projectid']">
	
							<xsl:variable name="projectId" select="dnet:oafSplitId('project', normalize-space(.))"/>
							
							<xsl:variable name="resultproject" select="dnet:oafResultProjectFromClaim($resultId, $projectId)"/>
							<xsl:variable name="projectresult" select="dnet:oafResultProjectFromClaim($projectId, $resultId)"/>
	
							<xsl:if test="string-length($projectId) &gt; 0">
								<ROW key="{$resultId}" columnFamily="resultProject">
									<QUALIFIER name="{$projectId}" type="base64"><xsl:value-of select="$resultproject"/></QUALIFIER>
								</ROW>
								<ROW key="{$projectId}" columnFamily="resultProject">
									<QUALIFIER name="{$resultId}" type="base64"><xsl:value-of select="$projectresult"/></QUALIFIER>
								</ROW>
							</xsl:if>							
						</xsl:for-each>
					
						<xsl:for-each select="//dc:creator">
							
							<xsl:variable name="personIdPart">
								<xsl:call-template name="personIdTmpl">
									<xsl:with-param name="objIdentifier" select="$objIdentifier" />
								</xsl:call-template>
							</xsl:variable>
							<xsl:variable name="position" select="position()" />
							
							<xsl:variable name="personId" select="dnet:oafId('person', $namespaceprefix, normalize-space($personIdPart))" /> 
							<xsl:variable name="person" select="dnet:oafPersonFromClaim($personId, $collectedfromid, $collectedfromname, $originalid, $dateofcollection, .)" />
							<xsl:variable name="personresult" select="dnet:oafPersonResultFromClaim($personId, $resultId, $position)" />
							<xsl:variable name="resultperson" select="dnet:oafPersonResultFromClaim($resultId, $personId, $position)" />
	
							<xsl:if test="string-length($personId) &gt; 0">
								<ROW key="{$personId}" columnFamily="person">
									<QUALIFIER name="body" type="base64"><xsl:value-of select="$person" /></QUALIFIER>
								</ROW>
								<ROW key="{$personId}" columnFamily="personResult">
									<QUALIFIER name="{$resultId}" type="base64"><xsl:value-of select="$personresult" /></QUALIFIER>
								</ROW>
								<ROW key="{$resultId}" columnFamily="personResult">
									<QUALIFIER name="{$personId}" type="base64"><xsl:value-of select="$resultperson" /></QUALIFIER>
								</ROW>
							</xsl:if>
							
							<!-- COAUTHORS -->
							<xsl:if test="$writeCoAuthors = true()">
								<xsl:for-each select="../dc:creator">
									<xsl:if test="$position != position()">
										<xsl:variable name="coauthorIdPart">
											<xsl:call-template name="personIdTmpl">
												<xsl:with-param name="objIdentifier" select="$objIdentifier" />
											</xsl:call-template>
										</xsl:variable>
										<xsl:variable name="coauthorId" select="dnet:oafId('person', $namespaceprefix, normalize-space($coauthorIdPart))" /> 
										<xsl:variable name="personperson" select="dnet:oafPersonPersonFromClaim($personId, $coauthorId)" />
										<ROW key="{$personId}" columnFamily="personPerson">
											<QUALIFIER name="{$coauthorId}" type="base64"><xsl:value-of select="$personperson" /></QUALIFIER>
										</ROW>
									</xsl:if>
								</xsl:for-each>
							</xsl:if>
							<!-- / COAUTHORS -->
						</xsl:for-each>
					</ROWS>
				</xsl:if>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	
	<xsl:template name="personIdTmpl">
		<xsl:param name="objIdentifier" />
		<xsl:choose>
			<xsl:when test="$mergeIdForHomonyms = false()">
				<xsl:value-of select="concat($objIdentifier, '::', normalize-space(.))" />
			</xsl:when>				
			<xsl:otherwise>
				<xsl:value-of select="normalize-space(.)" />
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>

</xsl:stylesheet>
