/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.transform.xml;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.protobuf.Message;
import eu.dnetlib.data.proto.OafProtos;
import eu.dnetlib.data.proto.PersonProtos;
import eu.dnetlib.data.proto.PersonResultProtos;
import eu.dnetlib.data.proto.RelMetadataProtos;
import eu.dnetlib.data.proto.RelTypeProtos;
import eu.dnetlib.data.proto.ResultProjectProtos;
import eu.dnetlib.data.proto.ResultProtos;
import eu.dnetlib.data.proto.ResultResultProtos;
import eu.dnetlib.data.proto.TypeProtos;
import eu.dnetlib.data.transform.xml.AbstractDNetOafXsltFunctions;
import eu.dnetlib.pace.model.Person;
import java.util.ArrayList;
import java.util.Map;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DataciteToHbaseXsltFunctions
extends AbstractDNetOafXsltFunctions {
    private static Map<String, String> mappingAccess = Maps.newHashMap();

    public static String oafResultFromDatacite(String resultId, NodeList metadata, NodeList titles, NodeList subjects, NodeList publisher, NodeList descriptions, NodeList dates, NodeList resourceTypes, NodeList formats, NodeList sizes, NodeList languages, NodeList rights, NodeList version, String provenance, String trust, String hostedbyId, String hostedbyName, String collectedfromId, String collectedfromName, String originalId, String instanceUri, String dateOfCollection) {
        try {
            String TmpName;
            String tmpID;
            NodeList childNodes;
            Node currentNode;
            int i;
            ResultProtos.Result.Builder result = ResultProtos.Result.newBuilder();
            ResultProtos.Result.Metadata.Builder metadataProto = ResultProtos.Result.Metadata.newBuilder();
            for (i = 0; i < subjects.getLength(); ++i) {
                currentNode = subjects.item(i);
                childNodes = currentNode.getChildNodes();
                if (childNodes.getLength() <= 0) continue;
                String subjectValue = childNodes.item(0).getNodeValue();
                DataciteToHbaseXsltFunctions.addField((Message.Builder)metadataProto, ResultProtos.Result.Metadata.getDescriptor().findFieldByName("subject"), DataciteToHbaseXsltFunctions.getStructuredProperty(subjectValue, "UNKNOWN", "UNKNOWN", "dnet:result_subject", "dnet:result_subject"));
            }
            for (i = 0; i < titles.getLength(); ++i) {
                currentNode = titles.item(i);
                childNodes = currentNode.getChildNodes();
                if (childNodes.getLength() <= 0) continue;
                String titleValue = childNodes.item(0).getNodeValue();
                String classname = "main title";
                String classid = "main title";
                if (currentNode.hasAttributes()) {
                    NamedNodeMap attributes = currentNode.getAttributes();
                    if (attributes.getNamedItem("titleType").getNodeValue().equals("AlternativeTitle")) {
                        classname = "alternative title";
                        classid = "alternative title";
                    }
                    if (attributes.getNamedItem("titleType").getNodeValue().equals("Subtitle")) {
                        classname = "subtitle";
                        classid = "subtitle";
                    }
                    if (attributes.getNamedItem("titleType").getNodeValue().equals("TranslatedTitle")) {
                        classname = "translated title";
                        classid = "translated title";
                    }
                }
                DataciteToHbaseXsltFunctions.addField((Message.Builder)metadataProto, ResultProtos.Result.Metadata.getDescriptor().findFieldByName("title"), DataciteToHbaseXsltFunctions.getStructuredProperty(titleValue, classname, classid, "dnet:dataCite_title", "dnet:dataCite_title"));
            }
            for (i = 0; i < descriptions.getLength(); ++i) {
                currentNode = descriptions.item(i);
                if (!currentNode.hasChildNodes()) continue;
                String descriptionValue = currentNode.getChildNodes().item(0).getNodeValue();
                DataciteToHbaseXsltFunctions.addField((Message.Builder)metadataProto, ResultProtos.Result.Metadata.getDescriptor().findFieldByName("description"), descriptionValue);
            }
            DataciteToHbaseXsltFunctions.addField((Message.Builder)metadataProto, ResultProtos.Result.Metadata.getDescriptor().findFieldByName("publisher"), DataciteToHbaseXsltFunctions.getFirstItem(publisher));
            for (i = 0; i < dates.getLength(); ++i) {
                currentNode = dates.item(i);
                if (!currentNode.hasAttributes() || !currentNode.hasChildNodes()) continue;
                String dateAttribute = currentNode.getAttributes().getNamedItem("dateType").getNodeValue();
                String dateValue = currentNode.getChildNodes().item(0).getNodeValue();
                String protoAttribute = "relevantdate";
                if ("Accepted".equals(dateAttribute)) {
                    protoAttribute = "dateofacceptance";
                } else if ("Issued".equals(dateAttribute)) {
                    protoAttribute = "storagedate";
                } else if ("Updated".equals(dateAttribute)) {
                    protoAttribute = "lastmetadataupdate";
                } else if ("Available".equals(dateAttribute)) {
                    protoAttribute = "embargoenddate";
                }
                if (!protoAttribute.equals("relevantdate")) {
                    DataciteToHbaseXsltFunctions.addField((Message.Builder)metadataProto, ResultProtos.Result.Metadata.getDescriptor().findFieldByName(protoAttribute), dateValue);
                    continue;
                }
                DataciteToHbaseXsltFunctions.addField((Message.Builder)metadataProto, ResultProtos.Result.Metadata.getDescriptor().findFieldByName(protoAttribute), DataciteToHbaseXsltFunctions.getStructuredProperty(dateValue, "UNKNOWN", "UNKNOWN", "dnet:dataCite_date", "dnet:dataCite_date"));
            }
            DataciteToHbaseXsltFunctions.addField((Message.Builder)metadataProto, ResultProtos.Result.Metadata.getDescriptor().findFieldByName("size"), DataciteToHbaseXsltFunctions.getFirstItem(sizes));
            DataciteToHbaseXsltFunctions.addField((Message.Builder)metadataProto, ResultProtos.Result.Metadata.getDescriptor().findFieldByName("format"), DataciteToHbaseXsltFunctions.getFirstItem(formats));
            DataciteToHbaseXsltFunctions.addField((Message.Builder)metadataProto, ResultProtos.Result.Metadata.getDescriptor().findFieldByName("version"), DataciteToHbaseXsltFunctions.getFirstItem(version));
            DataciteToHbaseXsltFunctions.addField((Message.Builder)metadataProto, ResultProtos.Result.Metadata.getDescriptor().findFieldByName("language"), DataciteToHbaseXsltFunctions.setQualifier(DataciteToHbaseXsltFunctions.getDefaultQualifier("dnet:languages"), Lists.newArrayList((Object[])new String[]{DataciteToHbaseXsltFunctions.getFirstItem(languages)})));
            DataciteToHbaseXsltFunctions.addField((Message.Builder)metadataProto, ResultProtos.Result.Metadata.getDescriptor().findFieldByName("resulttype"), DataciteToHbaseXsltFunctions.getSimpleQualifier("dataset", "dnet:result_typologies"));
            if (hostedbyId == null && hostedbyName == null) {
                tmpID = collectedfromId;
                TmpName = collectedfromName;
            } else {
                tmpID = hostedbyId;
                TmpName = hostedbyName;
            }
            ResultProtos.Result.Instance.Builder instance = ResultProtos.Result.Instance.newBuilder().setHostedby(DataciteToHbaseXsltFunctions.getKV(tmpID, TmpName));
            String tmpRigths = "UNKNOWN";
            String firstRight = DataciteToHbaseXsltFunctions.getFirstItem(rights);
            if (mappingAccess.containsKey(firstRight)) {
                tmpRigths = mappingAccess.get(firstRight);
            }
            DataciteToHbaseXsltFunctions.addField((Message.Builder)instance, ResultProtos.Result.Instance.getDescriptor().findFieldByName("licence"), DataciteToHbaseXsltFunctions.setQualifier(DataciteToHbaseXsltFunctions.getDefaultQualifier("dnet:access_modes"), Lists.newArrayList((Object[])new String[]{tmpRigths})));
            DataciteToHbaseXsltFunctions.addField((Message.Builder)instance, ResultProtos.Result.Instance.getDescriptor().findFieldByName("instancetype"), DataciteToHbaseXsltFunctions.setQualifier(DataciteToHbaseXsltFunctions.getDefaultQualifier("dnet:dataCite_resource"), Lists.newArrayList((Object[])new String[]{"0000"})));
            DataciteToHbaseXsltFunctions.addField((Message.Builder)instance, ResultProtos.Result.Instance.getDescriptor().findFieldByName("url"), instanceUri);
            result.addInstance(instance);
            ArrayList pids = Lists.newArrayList();
            OafProtos.OafEntity.Builder entity = DataciteToHbaseXsltFunctions.getEntity(TypeProtos.Type.result, resultId, DataciteToHbaseXsltFunctions.getKV(collectedfromId, collectedfromName), originalId, dateOfCollection, pids).setResult(result.setMetadata(metadataProto));
            OafProtos.Oaf oaf = DataciteToHbaseXsltFunctions.getOaf(entity, DataciteToHbaseXsltFunctions.getDataInfo(provenance, trust, false, false));
            return DataciteToHbaseXsltFunctions.base64(oaf.toByteArray());
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            throw new RuntimeException(e);
        }
    }

    public static String oafResultResultFromDatacite(String sourceId, String targetId, String provenanceAction, String trust) {
        try {
            ResultResultProtos.ResultResult.Builder rp = ResultResultProtos.ResultResult.newBuilder();
            RelMetadataProtos.RelMetadata.Builder metadata = RelMetadataProtos.RelMetadata.newBuilder().setSemantics(DataciteToHbaseXsltFunctions.getSimpleQualifier("isRelatedTo", "dnet:result_result_relations"));
            OafProtos.OafRel.Builder rel = DataciteToHbaseXsltFunctions.getRel(sourceId, targetId, RelTypeProtos.RelType.resultResult, false).setResultResult(rp.setRelMetadata(metadata));
            return DataciteToHbaseXsltFunctions.base64(DataciteToHbaseXsltFunctions.getOaf(rel, DataciteToHbaseXsltFunctions.getDataInfo(provenanceAction, trust, false, false)).toByteArray());
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            throw new RuntimeException(e);
        }
    }

    public static String getFirstItem(NodeList list) {
        String out = "";
        if (list != null && list.getLength() > 0 && list.item(0).getChildNodes() != null && list.item(0).getChildNodes().getLength() > 0) {
            out = list.item(0).getChildNodes().item(0).getNodeValue();
        }
        return out;
    }

    public static String oafResultProjectFromDMF(String sourceId, String targetId, String provenanceAction, String trust) {
        try {
            ResultProjectProtos.ResultProject.Builder rp = ResultProjectProtos.ResultProject.newBuilder();
            RelMetadataProtos.RelMetadata.Builder metadata = RelMetadataProtos.RelMetadata.newBuilder().setSemantics(DataciteToHbaseXsltFunctions.getSimpleQualifier("isResultOf", "dnet:result_project_relations"));
            OafProtos.OafRel.Builder rel = DataciteToHbaseXsltFunctions.getRel(sourceId, targetId, RelTypeProtos.RelType.resultProject, false).setResultProject(rp.setRelMetadata(metadata));
            return DataciteToHbaseXsltFunctions.base64(DataciteToHbaseXsltFunctions.getOaf(rel, DataciteToHbaseXsltFunctions.getDataInfo(provenanceAction, trust, false, false)).toByteArray());
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            throw new RuntimeException(e);
        }
    }

    public static String oafPersonFromDatacite(String personId, String fullname, String provenanceAction, String trust, String collectedfromId, String collectedfromName, String originalId, String dateOfCollection) {
        try {
            PersonProtos.Person.Builder person = PersonProtos.Person.newBuilder();
            PersonProtos.Person.Metadata.Builder metadata = PersonProtos.Person.Metadata.newBuilder();
            metadata.setFullname(fullname);
            Person p = new Person(fullname, false);
            if (p.isAccurate()) {
                metadata.setFirstname(Joiner.on((String)" ").join((Iterable)p.getName()));
                metadata.clearSecondnames().addAllSecondnames((Iterable)p.getSurname());
                metadata.setFullname(p.getNormalisedFullname());
            }
            ArrayList pids = Lists.newArrayList();
            OafProtos.OafEntity.Builder entity = DataciteToHbaseXsltFunctions.getEntity(TypeProtos.Type.person, personId, DataciteToHbaseXsltFunctions.getKV(collectedfromId, collectedfromName), originalId, dateOfCollection, pids).setPerson(person.setMetadata(metadata));
            return DataciteToHbaseXsltFunctions.base64(DataciteToHbaseXsltFunctions.getOaf(entity, DataciteToHbaseXsltFunctions.getDataInfo(provenanceAction, trust, false, false)).toByteArray());
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            throw new RuntimeException(e);
        }
    }

    public static String oafPersonResultFromDatacite(String personId, String resultId, int rank, String provenanceAction, String trust) {
        try {
            PersonResultProtos.PersonResult.Builder pr = PersonResultProtos.PersonResult.newBuilder().setRanking("" + rank);
            RelMetadataProtos.RelMetadata.Builder metadata = RelMetadataProtos.RelMetadata.newBuilder().setSemantics(DataciteToHbaseXsltFunctions.getSimpleQualifier("author", "dnet:personroles"));
            OafProtos.OafRel.Builder rel = DataciteToHbaseXsltFunctions.getRel(personId, resultId, RelTypeProtos.RelType.personResult, false).setPersonResult(pr.setRelMetadata(metadata));
            return DataciteToHbaseXsltFunctions.base64(DataciteToHbaseXsltFunctions.getOaf(rel, DataciteToHbaseXsltFunctions.getDataInfo(provenanceAction, trust, false, false)).toByteArray());
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            throw new RuntimeException(e);
        }
    }

    static {
        mappingAccess.put("info:eu-repo/semantics/openAccess", "OPEN");
        mappingAccess.put("info:eu-repo/semantics/closedAccess", "CLOSED");
        mappingAccess.put("info:eu-repo/semantics/restrictedAccess", "RESTRICTED");
        mappingAccess.put("info:eu-repo/semantics/embargoedAccess", "EMBARGO");
    }
}

