/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.oai.init.mongo;

import eu.dnetlib.data.information.DataSinkSourceException;
import eu.dnetlib.data.information.DataSource;
import eu.dnetlib.data.information.DataSourceResolver;
import eu.dnetlib.data.information.MDStoreDataSinkSourceDescriptorGenerator;
import eu.dnetlib.data.information.oai.publisher.conf.OAIStoreInitializer;
import eu.dnetlib.data.information.oai.publisher.info.MDFInfo;
import eu.dnetlib.data.information.oai.publisher.store.MongoPublisherStore;
import eu.dnetlib.data.information.oai.publisher.store.MongoPublisherStoreDAO;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpException;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpService;
import eu.dnetlib.enabling.resultset.client.IterableResultSetClient;
import eu.dnetlib.enabling.resultset.client.ResultSetClientFactory;
import eu.dnetlib.enabling.tools.ServiceLocator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PublisherInitializerMongo
extends OAIStoreInitializer {
    private static final Log log = LogFactory.getLog(PublisherInitializerMongo.class);
    private DataSourceResolver dataSourceResolver;
    private ServiceLocator<ISLookUpService> lookupLocator;
    private ResultSetClientFactory resultSetClientFactory;

    protected void synchronizeContent(MongoPublisherStore store) {
        log.info((Object)("Synchronizing content for stores: \n\tformat:" + this.getMdfInfo().getSourceFormatName() + " \n\tinterpretation: " + this.getMdfInfo().getSourceFormatInterpretation() + " \n\tlayout: " + this.getMdfInfo().getSourceFormatLayout()));
        String query = "//RESOURCE_PROFILE[.//RESOURCE_TYPE/@value = 'MDStoreDSResourceType' and .//METADATA_FORMAT = '" + this.getMdfInfo().getSourceFormatName() + "' and  .//METADATA_FORMAT_INTERPRETATION ='" + this.getMdfInfo().getSourceFormatInterpretation() + "' and .//METADATA_FORMAT_LAYOUT = '" + this.getMdfInfo().getSourceFormatLayout() + "']//RESOURCE_IDENTIFIER/@value/string()";
        MDStoreDataSinkSourceDescriptorGenerator storeDescriptorGenerator = new MDStoreDataSinkSourceDescriptorGenerator();
        try {
            List mdStoreIds = ((ISLookUpService)this.lookupLocator.getService()).quickSearchProfile(query);
            for (String mdStoreId : mdStoreIds) {
                DataSource source = this.dataSourceResolver.resolve(storeDescriptorGenerator.generateDataSourceDescriptor(mdStoreId));
                IterableResultSetClient records = this.resultSetClientFactory.getClient(source.retrieve());
                store.feed((Iterable)records, mdStoreId);
            }
        }
        catch (ISLookUpException e) {
            log.fatal((Object)("Can't synchronize content for stores: \n\tformat:" + this.getMdfInfo().getSourceFormatName() + " \n\tinterpretation: " + this.getMdfInfo().getSourceFormatInterpretation() + " \n\tlayout: " + this.getMdfInfo().getSourceFormatLayout()));
            log.fatal((Object)e.getMessage());
        }
        catch (DataSinkSourceException e) {
            log.fatal((Object)("Can't synchronize content for stores: \n\tformat:" + this.getMdfInfo().getSourceFormatName() + " \n\tinterpretation: " + this.getMdfInfo().getSourceFormatInterpretation() + " \n\tlayout: " + this.getMdfInfo().getSourceFormatLayout()));
            log.fatal((Object)e.getMessage());
        }
    }

    public PublisherInitializerMongo() {
    }

    public PublisherInitializerMongo(MDFInfo mdfInfo, MongoPublisherStoreDAO oaiStoreDao, boolean forceContentSyncronization, DataSourceResolver dataSourceResolver, ServiceLocator<ISLookUpService> lookupLocator, ResultSetClientFactory resultSetClientFactory) {
        super(mdfInfo, oaiStoreDao, forceContentSyncronization);
        this.dataSourceResolver = dataSourceResolver;
        this.lookupLocator = lookupLocator;
        this.resultSetClientFactory = resultSetClientFactory;
    }

    public DataSourceResolver getDataSourceResolver() {
        return this.dataSourceResolver;
    }

    public void setDataSourceResolver(DataSourceResolver dataSourceResolver) {
        this.dataSourceResolver = dataSourceResolver;
    }

    public ServiceLocator<ISLookUpService> getLookupLocator() {
        return this.lookupLocator;
    }

    public void setLookupLocator(ServiceLocator<ISLookUpService> lookupLocator) {
        this.lookupLocator = lookupLocator;
    }

    public ResultSetClientFactory getResultSetClientFactory() {
        return this.resultSetClientFactory;
    }

    public void setResultSetClientFactory(ResultSetClientFactory resultSetClientFactory) {
        this.resultSetClientFactory = resultSetClientFactory;
    }
}

