/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.actionmanager.actions;

import com.google.common.collect.Lists;
import eu.dnetlib.actionmanager.ActionManagerConstants;
import eu.dnetlib.actionmanager.actions.AbstractMetaAction;
import eu.dnetlib.actionmanager.actions.ActionFactory;
import eu.dnetlib.actionmanager.actions.AtomicAction;
import eu.dnetlib.actionmanager.common.Agent;
import eu.dnetlib.actionmanager.common.Operation;
import eu.dnetlib.actionmanager.common.Provenance;
import eu.dnetlib.actionmanager.rmi.ActionManagerException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.util.Bytes;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.DocumentResult;
import org.dom4j.io.DocumentSource;
import org.dom4j.io.SAXReader;

public class XsltInfoPackageAction
extends AbstractMetaAction<String> {
    private final Transformer transformer;
    private static final Log log = LogFactory.getLog(XsltInfoPackageAction.class);

    protected XsltInfoPackageAction(String set, Agent agent, Operation operation, String infoPackage, Transformer transformer, ActionFactory actionFactory) {
        super(set, agent, operation, infoPackage, actionFactory);
        this.transformer = transformer;
    }

    private Document applyXslt(String xml, Provenance provenance, String trust, String nsprefix) throws DocumentException, TransformerException {
        Document doc = new SAXReader().read((Reader)new StringReader(xml));
        DocumentResult result = new DocumentResult();
        this.transformer.setParameter("trust", trust);
        this.transformer.setParameter("provenance", provenance.toString());
        this.transformer.setParameter("namespaceprefix", nsprefix);
        this.transformer.transform((Source)new DocumentSource(doc), (Result)result);
        return result.getDocument();
    }

    @Override
    protected List<AtomicAction> calculateAtomicActions(Provenance provenance, String trust, String nsprefix) throws ActionManagerException {
        ArrayList list = Lists.newArrayList();
        try {
            Document doc = this.applyXslt((String)this.getMetaContent(), provenance, trust, nsprefix);
            for (Object o : doc.selectNodes("//ACTION")) {
                list.add(this.createAtomicAction((Element)o));
            }
        }
        catch (Exception e) {
            log.error((Object)"Error generating actions", (Throwable)e);
            throw new ActionManagerException((Throwable)e);
        }
        return list;
    }

    private AtomicAction createAtomicAction(Element elem) {
        String key = elem.valueOf("./@targetKey");
        String colFamily = elem.valueOf("./@targetColumnFamily");
        String col = elem.valueOf("./@targetColumn");
        String value64 = elem.getTextTrim();
        byte[] value = value64.isEmpty() ? null : Base64.decodeBase64((String)value64);
        return this.getActionFactory().createAtomicAction(this.getSet(), this.getAgent(), key, colFamily, col, value);
    }

    @Override
    public boolean isValid() {
        return true;
    }

    @Override
    public ActionManagerConstants.ACTION_TYPE getTypology() {
        return ActionManagerConstants.ACTION_TYPE.pkg;
    }

    @Override
    protected byte[] getBytesContent(String content) {
        return Bytes.toBytes((String)content);
    }
}

