/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.actionmanager.actions;

import com.google.common.collect.Lists;
import eu.dnetlib.actionmanager.ActionManagerConstants;
import eu.dnetlib.actionmanager.actions.AbstractAction;
import eu.dnetlib.actionmanager.common.Agent;
import eu.dnetlib.actionmanager.common.Operation;
import eu.dnetlib.actionmanager.common.Provenance;
import eu.dnetlib.actionmanager.hbase.HBasePutFactory;
import java.util.List;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.util.Bytes;

public class AtomicAction
extends AbstractAction {
    private String targetRowKey;
    private String targetColumnFamily;
    private String targetColumn;
    private byte[] targetValue;

    public AtomicAction(String set, Agent agent) {
        super(set, agent);
    }

    public AtomicAction(String set, Agent agent, Operation operation, String targetRowKey, String targetColumnFamily, String targetColumn, byte[] targetValue) {
        this(set, agent);
        this.targetRowKey = targetRowKey;
        this.targetColumnFamily = targetColumnFamily;
        this.targetColumn = targetColumn;
        this.targetValue = targetValue;
    }

    @Override
    public List<Put> asPutOperations(String parentId, Provenance provenance, String trust, String nsprefix) {
        Put put = HBasePutFactory.createPutOperation(this.getRowKey(), this.getSet(), this.getAgent());
        put.add(ActionManagerConstants.SET_COLFAMILY, Bytes.toBytes((String)this.getSet()), Bytes.toBytes((String)this.getSet()));
        put.add(ActionManagerConstants.TARGET_COLFAMILY, ActionManagerConstants.TARGET_KEY_COL, Bytes.toBytes((String)this.targetRowKey));
        put.add(ActionManagerConstants.TARGET_COLFAMILY, ActionManagerConstants.TARGET_COLFAMILY_COL, Bytes.toBytes((String)this.targetColumnFamily));
        put.add(ActionManagerConstants.TARGET_COLFAMILY, ActionManagerConstants.TARGET_COL_COL, Bytes.toBytes((String)this.targetColumn));
        put.add(ActionManagerConstants.TARGET_COLFAMILY, ActionManagerConstants.TARGET_OAF_COL, this.targetValue);
        if (parentId != null && !parentId.isEmpty()) {
            put.add(ActionManagerConstants.RELATION_COLFAMILY, Bytes.toBytes((String)parentId), ActionManagerConstants.ISPARTOF);
        }
        return Lists.newArrayList((Object[])new Put[]{put});
    }

    @Override
    public ActionManagerConstants.ACTION_TYPE getTypology() {
        return ActionManagerConstants.ACTION_TYPE.aac;
    }

    public String getTargetRowKey() {
        return this.targetRowKey;
    }

    public void setTargetRowKey(String targetRowKey) {
        this.targetRowKey = targetRowKey;
    }

    public String getTargetColumnFamily() {
        return this.targetColumnFamily;
    }

    public void setTargetColumnFamily(String targetColumnFamily) {
        this.targetColumnFamily = targetColumnFamily;
    }

    public String getTargetColumn() {
        return this.targetColumn;
    }

    public void setTargetColumn(String targetColumn) {
        this.targetColumn = targetColumn;
    }

    public byte[] getTargetValue() {
        return this.targetValue;
    }

    public void setTargetValue(byte[] targetValue) {
        this.targetValue = targetValue;
    }

    @Override
    public boolean isValid() {
        return this.getRowKey() != null && !this.getRowKey().isEmpty() && this.getSet() != null && !this.getSet().isEmpty() && this.targetRowKey != null && !this.targetRowKey.isEmpty() && this.targetColumnFamily != null && !this.targetColumnFamily.isEmpty() && this.targetColumn != null && !this.targetColumn.isEmpty() && this.targetValue != null && this.targetValue.length > 0;
    }
}

