/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.actionmanager.actions;

import com.google.common.collect.Lists;
import eu.dnetlib.actionmanager.actions.AtomicAction;
import eu.dnetlib.actionmanager.actions.XsltInfoPackageAction;
import eu.dnetlib.actionmanager.common.Agent;
import eu.dnetlib.actionmanager.common.Operation;
import eu.dnetlib.actionmanager.rmi.ActionManagerException;
import eu.dnetlib.data.proto.RelTypeProtos;
import eu.dnetlib.data.proto.TypeProtos;
import eu.dnetlib.miscutils.datetime.DateUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import org.apache.hadoop.hbase.util.Bytes;
import org.dom4j.Document;
import org.dom4j.io.DocumentSource;
import org.dom4j.io.SAXReader;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.core.io.Resource;

public class ActionFactory {
    private Map<String, Resource> xslts;
    final TransformerFactory tFactory = TransformerFactory.newInstance();

    @Deprecated
    public List<AtomicAction> createUpdateActions(String set, Agent agent, String originalId, String updateId, TypeProtos.Type entityType, byte[] updateContent) {
        ArrayList res = Lists.newArrayList();
        if (originalId.equals(updateId)) {
            throw new IllegalArgumentException("originalId and updateId must be different");
        }
        res.add(this.createAtomicAction(set, agent, updateId, entityType.toString(), "body", updateContent));
        res.add(this.createAtomicAction(set, agent, updateId, RelTypeProtos.RelType.similarRel.toString(), originalId, Bytes.toBytes((String)"")));
        res.add(this.createAtomicAction(set, agent, originalId, RelTypeProtos.RelType.similarRel.toString(), updateId, Bytes.toBytes((String)"")));
        return res;
    }

    public List<AtomicAction> createUpdateActions(String set, Agent agent, String originalId, TypeProtos.Type entityType, byte[] updateContent) {
        ArrayList res = Lists.newArrayList();
        res.add(this.createAtomicAction(set, agent, originalId, entityType.toString(), "update_" + DateUtils.now(), updateContent));
        return res;
    }

    public AtomicAction createAtomicAction(String set, Agent agent, String targetKey, String targetColFamily, String targetCol, byte[] targetContent) {
        AtomicAction action = new AtomicAction(set, agent);
        action.setTargetRowKey(targetKey);
        action.setTargetColumnFamily(targetColFamily);
        action.setTargetColumn(targetCol);
        action.setTargetValue(targetContent);
        return action;
    }

    public XsltInfoPackageAction generateInfoPackageAction(String xsltResource, String set, Agent agent, Operation operation, String infoPackage) throws ActionManagerException {
        Transformer transformer = this.prepareXsltTransformer(xsltResource);
        return new XsltInfoPackageAction(set, agent, operation, infoPackage, transformer, this);
    }

    public Transformer prepareXsltTransformer(String xsltName) throws ActionManagerException {
        try {
            if (!this.xslts.containsKey(xsltName)) {
                throw new ActionManagerException("XSLT " + xsltName + " not found");
            }
            Document doc = new SAXReader().read(this.xslts.get(xsltName).getInputStream());
            return this.tFactory.newTransformer((Source)new DocumentSource(doc));
        }
        catch (Exception e) {
            throw new ActionManagerException("Problem with xslt resource " + xsltName, (Throwable)e);
        }
    }

    public Map<String, Resource> getXslts() {
        return this.xslts;
    }

    @Required
    public void setXslts(Map<String, Resource> xslts) {
        this.xslts = xslts;
    }
}

