/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.actionmanager.actions;

import com.google.common.collect.Lists;
import eu.dnetlib.actionmanager.ActionManagerConstants;
import eu.dnetlib.actionmanager.actions.AbstractAction;
import eu.dnetlib.actionmanager.actions.ActionFactory;
import eu.dnetlib.actionmanager.actions.AtomicAction;
import eu.dnetlib.actionmanager.common.Agent;
import eu.dnetlib.actionmanager.common.Operation;
import eu.dnetlib.actionmanager.common.Provenance;
import eu.dnetlib.actionmanager.hbase.HBasePutFactory;
import eu.dnetlib.actionmanager.rmi.ActionManagerException;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.util.Bytes;

public abstract class AbstractMetaAction<T>
extends AbstractAction {
    private Operation operation;
    private T metaContent;
    private ActionFactory actionFactory;

    public AbstractMetaAction(String set, Agent agent, Operation operation, T metaContent, ActionFactory actionFactory) {
        super(set, agent);
        this.setOperation(operation);
        this.metaContent = metaContent;
        this.setActionFactory(actionFactory);
    }

    @Override
    public List<Put> asPutOperations(String parentId, Provenance provenance, String trust, String nsprefix) throws ActionManagerException {
        ArrayList puts = Lists.newArrayList();
        ArrayList partIds = Lists.newArrayList();
        for (AtomicAction action : this.calculateAtomicActions(provenance, trust, nsprefix)) {
            if (action == null || !action.isValid()) continue;
            puts.addAll(action.asPutOperations(this.getRowKey(), provenance, trust, nsprefix));
            partIds.add(action.getRowKey());
        }
        puts.add(this.prepareMetaPut(partIds));
        return puts;
    }

    private Put prepareMetaPut(List<String> partIds) {
        Put put = HBasePutFactory.createPutOperation(this.getRowKey(), this.getSet(), this.getAgent());
        put.add(ActionManagerConstants.OPERATION_COLFAMILY, Bytes.toBytes((String)this.getOperation().toString()), Bytes.toBytes((String)this.getOperation().toString()));
        put.add(ActionManagerConstants.ACTION_COLFAMILY, Bytes.toBytes((String)this.getTypology().toString()), this.getBytesContent(this.metaContent));
        for (String id : partIds) {
            put.add(ActionManagerConstants.RELATION_COLFAMILY, Bytes.toBytes((String)id), ActionManagerConstants.HASPARTS);
        }
        return put;
    }

    protected abstract List<AtomicAction> calculateAtomicActions(Provenance var1, String var2, String var3) throws ActionManagerException;

    protected abstract byte[] getBytesContent(T var1);

    public Operation getOperation() {
        return this.operation;
    }

    public void setOperation(Operation operation) {
        this.operation = operation;
    }

    public T getMetaContent() {
        return this.metaContent;
    }

    public void setMetaContent(T metaContent) {
        this.metaContent = metaContent;
    }

    public ActionFactory getActionFactory() {
        return this.actionFactory;
    }

    public void setActionFactory(ActionFactory actionFactory) {
        this.actionFactory = actionFactory;
    }
}

