/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.xml.database.exist;

import eu.dnetlib.enabling.is.store.BulkResourceImporter;
import eu.dnetlib.xml.database.exist.SyncExistDatabase;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Required;

public class PersistentExistDatabase
extends SyncExistDatabase {
    private static final Log log = LogFactory.getLog(PersistentExistDatabase.class);
    private transient File dbDirectory;
    private String configTemplate = "default-exist-conf.xml";
    private String dbRootPath;
    private BulkResourceImporter bulkImporter;
    private File existConfigFile;
    private boolean XQueryJavaEnabled;

    @Override
    public void start() {
        log.warn((Object)"STARTING PERSISTENT EXIST DATABASE");
        this.dbDirectory = new File(this.dbRootPath);
        if (this.dbDirectory.exists()) {
            this.bulkImporter.setEnabled(false);
            this.existConfigFile = new File(this.dbDirectory, "conf.xml");
            this.enableJava(this.existConfigFile, this.isXQueryJavaEnabled());
            this.setConfigFile(this.existConfigFile.getAbsolutePath());
        } else {
            this.createPersistentDatabase();
        }
        super.start();
    }

    @Override
    public void stop() {
        log.info((Object)"shutting down xmldb");
        super.stop();
        log.info((Object)"xmldb closed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void enableJava(File conf, boolean enabled) {
        block7: {
            StringWriter buffer = new StringWriter();
            if (conf.exists()) {
                try {
                    IOUtils.copy((Reader)new FileReader(conf), (Writer)buffer);
                    String newConf = this.patchConfigFileEnableJava(buffer.toString(), enabled);
                    if (newConf.equals(buffer.toString())) break block7;
                    FileWriter writer = new FileWriter(conf);
                    try {
                        IOUtils.copy((Reader)new StringReader(newConf), (Writer)writer);
                    }
                    finally {
                        writer.close();
                    }
                }
                catch (FileNotFoundException e) {
                    log.warn((Object)"cannot patch eXist conf file", (Throwable)e);
                }
                catch (IOException e) {
                    log.warn((Object)"cannot patch eXist conf file", (Throwable)e);
                }
            }
        }
    }

    protected String patchConfigFileEnableJava(String conf, boolean enabled) {
        return conf.replaceAll("enable-java-binding=\"[^\"]*\"", "enable-java-binding=\"" + (enabled ? "yes" : "no") + "\"");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void createPersistentDatabase() {
        log.debug((Object)"creating persistent database");
        try {
            new File(this.dbDirectory, "data").mkdirs();
            InputStream defaultConf = this.getClass().getResourceAsStream(this.getConfigTemplate());
            if (defaultConf == null) {
                throw new IOException("cannot find " + this.getConfigTemplate());
            }
            this.existConfigFile = new File(this.dbDirectory, "conf.xml");
            FileOutputStream confOutput = new FileOutputStream(this.existConfigFile);
            try {
                IOUtils.copy((InputStream)defaultConf, (OutputStream)confOutput);
            }
            finally {
                confOutput.close();
            }
            this.enableJava(this.existConfigFile, this.isXQueryJavaEnabled());
            this.setConfigFile(this.existConfigFile.getAbsolutePath());
        }
        catch (IOException e) {
            log.fatal((Object)"creating database dir", (Throwable)e);
            throw new IllegalStateException(e);
        }
        log.debug((Object)"created temp database");
    }

    public File getDbDirectory() {
        return this.dbDirectory;
    }

    public void setDbDirectory(File dbDirectory) {
        this.dbDirectory = dbDirectory;
    }

    public String getConfigTemplate() {
        return this.configTemplate;
    }

    public void setConfigTemplate(String configTemplate) {
        this.configTemplate = configTemplate;
    }

    public BulkResourceImporter getBulkImporter() {
        return this.bulkImporter;
    }

    @Required
    public void setBulkImporter(BulkResourceImporter bulkImporter) {
        this.bulkImporter = bulkImporter;
    }

    public File getExistConfigFile() {
        return this.existConfigFile;
    }

    public void setExistConfigFile(File existConfigFile) {
        this.existConfigFile = existConfigFile;
    }

    @Required
    public String getDbRootPath() {
        return this.dbRootPath;
    }

    public void setDbRootPath(String dbRootPath) {
        this.dbRootPath = dbRootPath;
    }

    public boolean isXQueryJavaEnabled() {
        return this.XQueryJavaEnabled;
    }

    public void setXQueryJavaEnabled(boolean xQueryJavaEnabled) {
        this.XQueryJavaEnabled = xQueryJavaEnabled;
    }
}

