/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.xml.database.exist;

import com.google.common.collect.Lists;
import eu.dnetlib.miscutils.datetime.DateUtils;
import eu.dnetlib.xml.database.Trigger;
import eu.dnetlib.xml.database.XMLDBResultSet;
import eu.dnetlib.xml.database.XMLDatabase;
import eu.dnetlib.xml.database.exist.DelegatingDiffTrigger;
import eu.dnetlib.xml.database.exist.ExistResultSet;
import eu.dnetlib.xml.database.exist.ExistTriggerRegistry;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.exist.collections.CollectionConfiguration;
import org.exist.util.DatabaseConfigurationException;
import org.exist.xmldb.DatabaseImpl;
import org.exist.xmldb.DatabaseInstanceManager;
import org.exist.xmldb.XmldbURI;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.context.Lifecycle;
import org.xmldb.api.DatabaseManager;
import org.xmldb.api.base.Collection;
import org.xmldb.api.base.Database;
import org.xmldb.api.base.Resource;
import org.xmldb.api.base.ResourceSet;
import org.xmldb.api.base.XMLDBException;
import org.xmldb.api.modules.CollectionManagementService;
import org.xmldb.api.modules.XPathQueryService;

public class ExistDatabase
implements XMLDatabase,
Lifecycle {
    private static final Log log = LogFactory.getLog(ExistDatabase.class);
    public static final String COLLECTION_XCONF = "collection.xconf";
    private static final String XMLRESOURCE = "XMLResource";
    private Map<String, Trigger> triggerConf = new HashMap<String, Trigger>();
    private Database database;
    private Collection root;
    private DatabaseInstanceManager manager;
    private XPathQueryService queryService;
    private CollectionManagementService colman;
    private String configFile;
    private String backupDir;

    public void start() {
        log.info((Object)"starting database");
        try {
            if (this.getDatabase() == null) {
                this.setDatabase((Database)new DatabaseImpl());
                this.getDatabase().setProperty("configuration", this.getConfigFile());
                this.getDatabase().setProperty("create-database", "true");
            }
            DatabaseManager.registerDatabase((Database)this.getDatabase());
            this.setRoot(DatabaseManager.getCollection((String)("xmldb:exist://" + this.getRootCollection()), (String)"admin", (String)""));
            this.setManager((DatabaseInstanceManager)this.getRoot().getService("DatabaseInstanceManager", "1.0"));
            this.setQueryService((XPathQueryService)this.getRoot().getService("XPathQueryService", "1.0"));
            this.setColman((CollectionManagementService)this.getRoot().getService("CollectionManagementService", "1.0"));
            for (Map.Entry<String, Trigger> entry : this.getTriggerConf().entrySet()) {
                this.registerTrigger(entry.getValue(), entry.getKey());
            }
        }
        catch (XMLDBException e) {
            throw new IllegalStateException("cannot open eXist database", e);
        }
    }

    protected Collection getCollection(String collection) throws XMLDBException {
        if (!collection.startsWith("/db")) {
            throw new XMLDBException(0, "collection path should begin with /db");
        }
        return this.database.getCollection("exist://" + collection, "admin", "");
    }

    @Override
    public void create(String name, String collection, String content) throws XMLDBException {
        if ("".equals(name)) {
            throw new XMLDBException(0, "cannot create a xml file with an empty file name");
        }
        Collection col = this.getCollection(collection);
        if (col == null) {
            this.createCollection(collection, true);
            col = this.getCollection(collection);
        }
        Resource res = col.createResource(name, XMLRESOURCE);
        res.setContent((Object)content);
        col.storeResource(res);
    }

    @Override
    public boolean remove(String name, String collection) throws XMLDBException {
        Collection col = this.getCollection(collection);
        Resource res = col.getResource(name);
        if (res == null) {
            return false;
        }
        col.removeResource(res);
        return true;
    }

    @Override
    public void update(String name, String collection, String content) throws XMLDBException {
        Collection col = this.getCollection(collection);
        Resource res = col.getResource(name);
        if (res == null) {
            throw new XMLDBException(0, "resource doesn't exist");
        }
        res.setContent((Object)content);
        col.storeResource(res);
    }

    @Override
    public String read(String name, String collection) throws XMLDBException {
        Collection coll = this.getCollection(collection);
        if (coll == null) {
            return null;
        }
        Resource res = coll.getResource(name);
        if (res != null) {
            return (String)res.getContent();
        }
        return null;
    }

    @Override
    public XMLDBResultSet xquery(String xquery) throws XMLDBException {
        ResourceSet res = this.getQueryService().query(xquery);
        return this.createResultSet(res);
    }

    protected ExistResultSet createResultSet(ResourceSet res) {
        return new ExistResultSet(res);
    }

    public void stop() {
        try {
            this.getManager().shutdown();
            DatabaseManager.deregisterDatabase((Database)this.database);
        }
        catch (XMLDBException e) {
            log.fatal((Object)"cannot close database", (Throwable)e);
        }
    }

    @Override
    public boolean collectionExists(String collection) throws XMLDBException {
        Collection col = this.getCollection(collection);
        return col != null;
    }

    @Override
    public void createCollection(String collection) throws XMLDBException {
        this.createCollection(collection, false);
    }

    @Override
    public void createCollection(String collection, boolean recursive) throws XMLDBException {
        XmldbURI uri;
        if (recursive && !this.collectionExists((uri = XmldbURI.create((String)collection).removeLastSegment()).toString())) {
            this.createCollection(uri.toString(), true);
        }
        this.getColman().createCollection(collection);
    }

    @Override
    public void removeCollection(String collection) throws XMLDBException {
        this.getColman().removeCollection(collection);
    }

    public String getConfigFile() {
        return this.configFile;
    }

    public void setConfigFile(String configFile) {
        this.configFile = configFile;
    }

    @Override
    public String getBackupDir() {
        return this.backupDir;
    }

    @Required
    public void setBackupDir(String backupDir) {
        this.backupDir = backupDir;
    }

    public boolean isRunning() {
        return false;
    }

    protected Database getDatabase() {
        return this.database;
    }

    protected void setDatabase(Database database) {
        this.database = database;
    }

    protected Collection getRoot() {
        return this.root;
    }

    protected void setRoot(Collection root) {
        this.root = root;
    }

    protected DatabaseInstanceManager getManager() {
        return this.manager;
    }

    protected void setManager(DatabaseInstanceManager manager) {
        this.manager = manager;
    }

    protected XPathQueryService getQueryService() {
        return this.queryService;
    }

    protected void setQueryService(XPathQueryService queryService) {
        this.queryService = queryService;
    }

    protected CollectionManagementService getColman() {
        return this.colman;
    }

    protected void setColman(CollectionManagementService colman) {
        this.colman = colman;
    }

    @Override
    public String getRootCollection() {
        return "/db";
    }

    @Override
    public List<String> listChildCollections(String collection) throws XMLDBException {
        Collection col = this.getCollection(collection);
        if (col == null) {
            return Lists.newArrayList();
        }
        return Lists.newArrayList((Object[])col.listChildCollections());
    }

    @Override
    public List<String> list(String collection) throws XMLDBException {
        Collection col = this.getCollection(collection);
        if (col == null) {
            return Lists.newArrayList();
        }
        return Lists.newArrayList((Object[])col.listResources());
    }

    void setExistTrigger(Class<?> triggerClass, String collection, List<String> events, Map<String, String> parameters) throws XMLDBException {
        StringBuilder conf = new StringBuilder();
        conf.append("<exist:collection xmlns:exist=\"http://exist-db.org/collection-config/1.0\"><exist:triggers>");
        String className = triggerClass.getCanonicalName();
        conf.append("<exist:trigger event=\"store,update,remove\" class=\"" + className + "\">");
        if (parameters != null) {
            for (Map.Entry<String, String> entry : parameters.entrySet()) {
                conf.append("<exist:parameter name=\"" + entry.getKey() + "\" value=\"" + entry.getValue() + "\"/>");
            }
        }
        conf.append("</exist:trigger>");
        conf.append("</exist:triggers></exist:collection>");
        log.info((Object)conf.toString());
        this.createCollection("/db/system/config" + collection, true);
        this.create(CollectionConfiguration.DEFAULT_COLLECTION_CONFIG_FILE_URI.toString(), "/db/system/config" + collection, conf.toString());
    }

    @Override
    public void registerTrigger(Trigger trigger, String collection) throws XMLDBException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("triggerName", trigger.getName());
        ExistTriggerRegistry.defaultInstance().registerTrigger(trigger.getName(), trigger);
        this.setExistTrigger(DelegatingDiffTrigger.class, collection, Lists.newArrayList((Object[])new String[]{"store", "update", "delete"}), params);
    }

    public Map<String, Trigger> getTriggerConf() {
        return this.triggerConf;
    }

    public void setTriggerConf(Map<String, Trigger> triggerConf) {
        this.triggerConf = triggerConf;
    }

    @Override
    public String backup() throws XMLDBException, DatabaseConfigurationException {
        log.info((Object)"Starting backup...");
        try {
            this.verifyBackupDir();
            String seq = new SimpleDateFormat("yyyyMMdd-HHmm").format(new Date());
            ZipOutputStream zip = new ZipOutputStream(new FileOutputStream(this.backupDir + "/data-" + seq + ".zip"));
            FileWriter logFile = new FileWriter(this.backupDir + "/report-" + seq + ".log");
            logFile.write("Backup started at: " + DateUtils.now_ISO8601() + "\n\n");
            this.backup(this.getRoot().getName(), zip, logFile);
            logFile.write("\nBackup finished at: " + DateUtils.now_ISO8601() + "\n");
            logFile.flush();
            logFile.close();
            zip.flush();
            zip.close();
            log.info((Object)"Backup finished");
            return this.backupDir;
        }
        catch (Exception e) {
            log.error((Object)"Backup failed", (Throwable)e);
            throw new XMLDBException(0, "cannot backup", (Throwable)e);
        }
    }

    private void verifyBackupDir() {
        File d = new File(this.backupDir);
        if (!d.exists()) {
            d.mkdirs();
        }
    }

    private void backup(String coll, ZipOutputStream zip, FileWriter logFile) throws XMLDBException, IOException {
        logFile.write("COLLECTION: " + coll + "\n");
        log.info((Object)("Backup of collection " + coll));
        for (String file : this.list(coll)) {
            zip.putNextEntry(new ZipEntry(coll + "/" + file + ".xml"));
            Resource resource = this.getCollection(coll).getResource(file);
            zip.write(resource.getContent().toString().getBytes());
            zip.closeEntry();
        }
        for (String c : this.listChildCollections(coll)) {
            this.backup(coll + "/" + c, zip, logFile);
        }
    }
}

