/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.xml.database.exist;

import eu.dnetlib.xml.database.Trigger;
import eu.dnetlib.xml.database.exist.AbstractDiffTrigger;
import eu.dnetlib.xml.database.exist.ExistTriggerRegistry;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.exist.collections.Collection;
import org.exist.collections.CollectionConfigurationException;
import org.exist.storage.DBBroker;
import org.exist.xmldb.XmldbURI;
import org.w3c.dom.Document;

public class DelegatingDiffTrigger
extends AbstractDiffTrigger {
    private static final Log log = LogFactory.getLog(DelegatingDiffTrigger.class);
    private String triggerName;

    public void configure(DBBroker broker, Collection parent, Map parameters) throws CollectionConfigurationException {
        super.configure(broker, parent, parameters);
        if (parameters == null) {
            return;
        }
        Map params = parameters;
        this.setTriggerName((String)params.get("triggerName"));
        if (this.getTriggerName() == null) {
            log.fatal((Object)"trigger id not configured");
            throw new CollectionConfigurationException("trigger name not configured");
        }
    }

    protected Trigger getTrigger() {
        Trigger trigger = ExistTriggerRegistry.defaultInstance().getTrigger(this.getTriggerName());
        if (trigger == null) {
            log.fatal((Object)("no trigger " + this.triggerName + " but there is a registered callback for it"));
            return null;
        }
        return trigger;
    }

    @Override
    protected void triggerUpdate(XmldbURI uri, Document oldDoc, Document newDoc) {
        Trigger trigger = this.getTrigger();
        if (trigger != null) {
            trigger.updated(uri.lastSegment().toString(), uri.removeLastSegment().toString(), oldDoc, newDoc);
        }
    }

    @Override
    protected void triggerCreate(XmldbURI uri, Document newDoc) {
        Trigger trigger = this.getTrigger();
        if (trigger != null) {
            trigger.created(uri.lastSegment().toString(), uri.removeLastSegment().toString(), newDoc);
        }
    }

    @Override
    protected void triggerDelete(XmldbURI uri, Document oldDoc) {
        Trigger trigger = this.getTrigger();
        if (trigger != null) {
            trigger.deleted(uri.lastSegment().toString(), uri.removeLastSegment().toString(), oldDoc);
        }
    }

    public String getTriggerName() {
        return this.triggerName;
    }

    public void setTriggerName(String triggerId) {
        this.triggerName = triggerId;
    }
}

