/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.xml.database.exist;

import eu.dnetlib.xml.database.exist.ExistDOMConverter;
import java.io.IOException;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.exist.collections.triggers.DocumentTrigger;
import org.exist.collections.triggers.FilteringTrigger;
import org.exist.collections.triggers.TriggerException;
import org.exist.dom.DocumentImpl;
import org.exist.security.PermissionDeniedException;
import org.exist.storage.DBBroker;
import org.exist.storage.txn.Txn;
import org.exist.xmldb.XmldbURI;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public abstract class AbstractDiffTrigger
extends FilteringTrigger
implements DocumentTrigger {
    private static final Log log = LogFactory.getLog(AbstractDiffTrigger.class);
    private final transient ExistDOMConverter domConverter = new ExistDOMConverter();
    private final transient ThreadLocal<Document> local = new ThreadLocal();

    public void prepare(int eventType, DBBroker broker, Txn arg2, XmldbURI uri, DocumentImpl doc) throws TriggerException {
        log.debug((Object)("preparing trigger: " + eventType));
        if (doc != null) {
            try {
                this.local.set(this.domConverter.asDocument((Document)doc));
            }
            catch (IOException e) {
                log.fatal((Object)"cannot convert", (Throwable)e);
                throw new TriggerException("cannot convert eXist DOM to normal DOM", (Throwable)e);
            }
            catch (ParserConfigurationException e) {
                log.fatal((Object)"cannot convert", (Throwable)e);
                throw new TriggerException("cannot convert eXist DOM to normal DOM", (Throwable)e);
            }
            catch (SAXException e) {
                log.fatal((Object)"cannot convert", (Throwable)e);
                throw new TriggerException("cannot convert eXist DOM to normal DOM", (Throwable)e);
            }
        }
    }

    public void finish(final int eventType, DBBroker broker, Txn arg2, final XmldbURI uri, DocumentImpl doc) {
        AbstractTriggerFunctor functor;
        log.debug((Object)("trigger finished. Event: " + eventType));
        if (eventType == 1) {
            functor = new AbstractTriggerFunctor(){

                @Override
                void callTrigger(Document oldDoc, Document newDoc) {
                    AbstractDiffTrigger.this.triggerUpdate(uri, oldDoc, newDoc);
                }
            };
        } else if (eventType == 0) {
            this.local.set((Document)doc);
            functor = new AbstractTriggerFunctor(){

                @Override
                void callTrigger(Document oldDoc, Document newDoc) {
                    AbstractDiffTrigger.this.triggerCreate(uri, newDoc);
                }
            };
        } else {
            functor = eventType == 2 ? new AbstractTriggerFunctor(false){

                @Override
                void callTrigger(Document oldDoc, Document newDoc) {
                    AbstractDiffTrigger.this.triggerDelete(uri, oldDoc);
                }
            } : new AbstractTriggerFunctor(){

                @Override
                void callTrigger(Document oldDoc, Document newDoc) {
                    log.fatal((Object)("unhandled trigger event: " + eventType));
                }
            };
        }
        functor.runTrigger(broker, uri.lastSegment());
    }

    protected abstract void triggerCreate(XmldbURI var1, Document var2);

    protected abstract void triggerUpdate(XmldbURI var1, Document var2, Document var3);

    protected abstract void triggerDelete(XmldbURI var1, Document var2);

    abstract class AbstractTriggerFunctor {
        private final transient boolean requiresCurrent;

        AbstractTriggerFunctor() {
            this(true);
        }

        AbstractTriggerFunctor(boolean requiresCurrent) {
            this.requiresCurrent = requiresCurrent;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void runTrigger(DBBroker broker, XmldbURI relative) {
            if (AbstractDiffTrigger.this.local.get() == null) {
                log.fatal((Object)"thread local is empty");
            } else {
                try {
                    Object newDoc = null;
                    if (this.doesRequireCurrent()) {
                        DocumentImpl resource = null;
                        try {
                            XmldbURI uri = AbstractDiffTrigger.this.collection.getURI().append(relative);
                            newDoc = resource = broker.getXMLResource(uri, 0);
                            if (newDoc == null) {
                                log.fatal((Object)("cannot fetch current document version: " + relative));
                                return;
                            }
                            newDoc = AbstractDiffTrigger.this.domConverter.asDocument((Document)newDoc);
                        }
                        finally {
                            if (resource != null) {
                                resource.getUpdateLock().release(0);
                            }
                        }
                    }
                    this.callTrigger((Document)AbstractDiffTrigger.this.local.get(), (Document)newDoc);
                }
                catch (IOException e) {
                    log.warn((Object)"trigger convert doc", (Throwable)e);
                }
                catch (ParserConfigurationException e) {
                    log.warn((Object)"trigger convert doc ", (Throwable)e);
                }
                catch (SAXException e) {
                    log.warn((Object)"trigger convert doc", (Throwable)e);
                }
                catch (PermissionDeniedException e) {
                    log.warn((Object)"trigger convert doc", (Throwable)e);
                }
            }
        }

        boolean doesRequireCurrent() {
            return this.requiresCurrent;
        }

        abstract void callTrigger(Document var1, Document var2);
    }
}

