<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	xmlns:idres="eu.dnetlib.enabling.inspector.msro.ResourceIdentifierResolverWrapper">

	<xsl:template match="/">
		<xsl:apply-templates select="//repo" />
	</xsl:template>

	<xsl:template match="repo">
		<h3>
			<xsl:variable name="id">
				<xsl:apply-templates select="id" mode="profile" />
			</xsl:variable>
		
				<a href="{$id}"><xsl:value-of select="name" /></a>
		</h3>
		<p>
			<xsl:value-of select="size" />
			documents
		</p>
		<table cellspacing="0">
			<tr>
				<th>mdstore</th>
				<th>format</th>
				<th>interp.</th>
				<th>size</th>
				<th>indices</th>
			</tr>
			<xsl:apply-templates select="hi/mdstore" />
		</table>
		
		<hr/>
	</xsl:template>

	<xsl:template match="mdstore">
		<tr>
			<td>
				<xsl:variable name="id">
					<xsl:apply-templates select="id" mode="profile" />
				</xsl:variable>
		
				<a href="{$id}">(profile)</a> |
				<a href="mdstore.do?id={id}">(inspect)</a>
			</td>
			<td>
				<xsl:value-of select="format" />
			</td>
			<td>
				<xsl:value-of select="interpretation" />
			</td>
			<td>
				<xsl:value-of select="size" />
			</td>
			<td>
				<ul>
					<xsl:apply-templates select="index" />
				</ul>
			</td>
		</tr>
	</xsl:template>

	<xsl:template match="index">
		<li>
			<xsl:variable name="id">
				<xsl:apply-templates select="id" mode="profile" />
			</xsl:variable>
			<a href="{$id}">
				<xsl:value-of select="layout" /> (<xsl:value-of select="size"/>)
			</a> <a href="msroDeleteIndex.do?id={string(id)}" onclick="return confirm('do you really want to delete the index?')">X</a>
		</li>
	</xsl:template>

	<xsl:template match="*|text()" mode="profile">
		index.do/db/DRIVER/<xsl:value-of select="idres:getCollectionName(.)"/>/<xsl:value-of select="idres:getFileName(.)"/>/show
	</xsl:template>

</xsl:stylesheet>