declare  namespace sharer="java:eu.dnetlib.test.SpringContextSharer";
declare  namespace bean="java:org.springframework.beans.factory.BeanFactory";
declare  namespace sourcesink="java:eu.dnetlib.enabling.manager.msro.tools.SourceSinkResolver";

<root>
{

let $sourceSinkResolver := bean:getBean(sharer:getGlobalContext(), "msroSourceSinkResolver")
for $r in collection('/db/DRIVER/RepositoryServiceResources/RepositoryServiceResourceType')//RESOURCE_PROFILE

  let $repId := $r//RESOURCE_IDENTIFIER/@value/string()
  order by $r//NUMBER_OF_OBJECTS descending
  
return <repo>

         <id>{$repId}</id>
         <name>{$r//OFFICIAL_NAME/text()}</name>
         <size>{$r//NUMBER_OF_OBJECTS/text()}</size>
 
         {
         for $hi in collection('')//RESOURCE_PROFILE[.//REPOSITORY_SERVICE_IDENTIFIER/text() = $repId and (.//RESOURCE_TYPE/@value = 'HarvestingInstanceDSResourceType' or .//RESOURCE_TYPE/@value = 'TransformationDSResourceType')]
            let $sink := sourcesink:getSinkMdId($sourceSinkResolver, $hi//DATA_SINK/text()),
                $source := sourcesink:getSourceMdId($sourceSinkResolver, $hi//DATA_SOURCE/text())

         return <hi>
                  {
           for $m in //RESOURCE_PROFILE[.//RESOURCE_IDENTIFIER/@value = $hi//MDSTORE_DS_IDENTIFIER
or .//RESOURCE_IDENTIFIER/@value = $sink or .//RESOURCE_IDENTIFIER/@value = $source
]
           let $mid := $m//RESOURCE_IDENTIFIER/@value/string()
               
           return <mdstore>
                    <id>{$mid}</id>
                    <format>{$m//METADATA_FORMAT/text()}</format>
                    <interpretation>{$m//METADATA_FORMAT_INTERPRETATION/text()}</interpretation>
                    <size>{$m//NUMBER_OF_RECORDS/text()}</size>
                    {
                     for $i in //RESOURCE_PROFILE[.//RESOURCE_TYPE/@value = 'ManagerServiceMapDSResourceType']//INDEX[MDSTORE/@id = $mid]
                     let $ip := //RESOURCE_PROFILE[.//RESOURCE_IDENTIFIER/@value = $i/@id]

                     return <index> 
                <id>{$i/@id/string()}</id>
                <layout>{$ip//METADATA_FORMAT_LAYOUT/text()}</layout>
                <size>{$ip//INDEX_SIZE/text()}</size>
                <stale>{$ip//INDEX_STALE/text()}"</stale>
                <updated>{$ip//INDEX_LAST_UPDATE/text()}"</updated>
                            </index>
                    }
                  </mdstore>
                  }
                </hi>
         }

       </repo>
}
</root>    