<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	xmlns:idres="eu.dnetlib.enabling.inspector.msro.ResourceIdentifierResolverWrapper">

	<xsl:template match="/">
		<ul>
			<xsl:apply-templates select="//store" />
		</ul>
	</xsl:template>

	<xsl:template match="store">
		<li>
			<ul>
				<xsl:apply-templates select=".//index" />
			</ul>
		</li>
	</xsl:template>

	<xsl:template match="index">

		<xsl:variable name="id">
				<xsl:apply-templates select="id" mode="profile" />
		</xsl:variable>

		<li>	
			<xsl:value-of select="size"/>: <a href="{$id}">(profile) <xsl:value-of select="format"/>/<xsl:value-of select="layout"/></a> - <a href="msroDeleteIndex.do?id={id}">clean delete</a>
		</li>
	</xsl:template>

	<xsl:template match="*|text()" mode="profile">
		index.do/db/DRIVER/<xsl:value-of select="idres:getCollectionName(.)"/>/<xsl:value-of select="idres:getFileName(.)"/>/show
	</xsl:template>

</xsl:stylesheet>