/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.workflow.sarasvati;

import com.googlecode.sarasvati.Node;
import com.googlecode.sarasvati.load.DefaultNodeFactory;
import com.googlecode.sarasvati.load.SarasvatiLoadException;
import com.googlecode.sarasvati.mem.MemNode;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class SarasvatiNodeFactory
extends DefaultNodeFactory
implements ApplicationContextAware {
    private String beanNamePrefix = "wfNode";
    private transient ApplicationContext applicationContext;
    private boolean exclusive;

    public SarasvatiNodeFactory() {
        super(MemNode.class);
    }

    public SarasvatiNodeFactory(Class<? extends Node> defaultClass) {
        super(defaultClass);
    }

    public Node newNode(String type) throws SarasvatiLoadException {
        if ("node".equals(type)) {
            return super.newNode(type);
        }
        Node prototypeNode = (Node)this.applicationContext.getBean(this.beanNamePrefix + type, Node.class);
        if (prototypeNode != null) {
            return prototypeNode;
        }
        if (this.exclusive && !"node".equals(type)) {
            throw new SarasvatiLoadException("cannot find bean " + this.beanNamePrefix + type);
        }
        return super.newNode(type);
    }

    public void setApplicationContext(ApplicationContext context) {
        this.applicationContext = context;
    }

    public String getBeanNamePrefix() {
        return this.beanNamePrefix;
    }

    public void setBeanNamePrefix(String beanNamePrefix) {
        this.beanNamePrefix = beanNamePrefix;
    }

    public boolean isExclusive() {
        return this.exclusive;
    }

    public void setExclusive(boolean exclusive) {
        this.exclusive = exclusive;
    }
}

