/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.workflow.sarasvati;

import com.googlecode.sarasvati.Engine;
import com.googlecode.sarasvati.Graph;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.io.IOUtils;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.core.io.Resource;

public class SarasvatiGraphFactory
implements FactoryBean {
    private Engine engine;
    private Resource definition;
    private String graphName;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getObject() throws Exception {
        File tmpFile = File.createTempFile("wftfs", null);
        try {
            IOUtils.copy((InputStream)this.definition.getInputStream(), (OutputStream)new FileOutputStream(tmpFile));
            this.engine.getLoader().load(tmpFile);
            String name = null;
            name = this.graphName == null ? new File(this.definition.getURL().getPath()).getName().replace(".wf.xml", "") : this.graphName;
            Graph graph = this.engine.getRepository().getLatestGraph(name);
            if (graph == null) {
                throw new IllegalArgumentException("graph called " + name + " doesn't exist");
            }
            Graph graph2 = graph;
            return graph2;
        }
        finally {
            tmpFile.delete();
        }
    }

    public Class<?> getObjectType() {
        return Graph.class;
    }

    public boolean isSingleton() {
        return false;
    }

    public Engine getEngine() {
        return this.engine;
    }

    public void setEngine(Engine engine) {
        this.engine = engine;
    }

    public Resource getDefinition() {
        return this.definition;
    }

    public void setDefinition(Resource definition) {
        this.definition = definition;
    }

    public String getGraphName() {
        return this.graphName;
    }

    public void setGraphName(String graphName) {
        this.graphName = graphName;
    }
}

