/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.workflow.sarasvati;

import com.googlecode.sarasvati.GraphProcess;
import eu.dnetlib.enabling.tools.UniqueIdentifierGenerator;
import eu.dnetlib.enabling.tools.UniqueIdentifierGeneratorImpl;
import eu.dnetlib.workflow.GraphProcessRegistry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MemGraphProcessRegistry
implements GraphProcessRegistry {
    private static final Log log = LogFactory.getLog(MemGraphProcessRegistry.class);
    private Map<String, Collection<GraphProcess>> byResource = new HashMap<String, Collection<GraphProcess>>();
    private Map<String, GraphProcess> byId = new HashMap<String, GraphProcess>();
    private Map<GraphProcess, String> byProcess = new HashMap<GraphProcess, String>();
    private UniqueIdentifierGenerator uuidGen = new UniqueIdentifierGeneratorImpl("pr-");

    @Override
    public GraphProcess findProcess(String identifier) {
        return this.byId.get(identifier);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<GraphProcess> findProcessesByResource(String identifier) {
        MemGraphProcessRegistry memGraphProcessRegistry = this;
        synchronized (memGraphProcessRegistry) {
            Collection<GraphProcess> res = this.byResource.get(identifier);
            if (res == null) {
                return new ArrayList<GraphProcess>();
            }
            return res;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String associateProcessWithResource(GraphProcess process, String identifier) {
        this.registerProcess(process);
        MemGraphProcessRegistry memGraphProcessRegistry = this;
        synchronized (memGraphProcessRegistry) {
            Collection<GraphProcess> processes = this.findProcessesByResource(identifier);
            processes.add(process);
            this.byResource.put(identifier, processes);
        }
        return identifier;
    }

    @Override
    public String registerProcess(GraphProcess process) {
        log.info((Object)("registering process " + process));
        if (this.byProcess.containsKey(process)) {
            return this.byProcess.get(process);
        }
        String uuid = this.uuidGen.generateIdentifier();
        log.info((Object)("allocating id " + uuid));
        this.byId.put(uuid, process);
        this.byProcess.put(process, uuid);
        return uuid;
    }

    @Override
    public Collection<String> listIdentifiers() {
        return this.byId.keySet();
    }

    @Override
    public void unregisterProcess(String identifier) {
        GraphProcess process = this.findProcess(identifier);
        this.byId.remove(identifier);
        for (Collection<GraphProcess> processes : this.byResource.values()) {
            processes.remove(process);
        }
    }

    public UniqueIdentifierGenerator getUuidGen() {
        return this.uuidGen;
    }

    public void setUuidGen(UniqueIdentifierGenerator uuidGen) {
        this.uuidGen = uuidGen;
    }

    public Map<String, Collection<GraphProcess>> getByResource() {
        return this.byResource;
    }

    public void setByResource(Map<String, Collection<GraphProcess>> byResource) {
        this.byResource = byResource;
    }

    public Map<String, GraphProcess> getById() {
        return this.byId;
    }

    public void setById(Map<String, GraphProcess> byId) {
        this.byId = byId;
    }

    public Map<GraphProcess, String> getByProcess() {
        return this.byProcess;
    }

    public void setByProcess(Map<GraphProcess, String> byProcess) {
        this.byProcess = byProcess;
    }

    @Override
    public String getProcessIdentifier(GraphProcess process) {
        return this.byProcess.get(process);
    }
}

