/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.workflow;

import com.googlecode.sarasvati.Engine;
import com.googlecode.sarasvati.NodeToken;
import eu.dnetlib.enabling.tools.blackboard.BlackboardClientHandler;
import eu.dnetlib.enabling.tools.blackboard.BlackboardJob;
import eu.dnetlib.enabling.tools.blackboard.BlackboardJobImpl;
import eu.dnetlib.enabling.tools.blackboard.BlackboardJobListener;
import eu.dnetlib.enabling.tools.blackboard.BlackboardJobRegistry;
import eu.dnetlib.workflow.AbstractBlackboardWorkflowJobListener;
import eu.dnetlib.workflow.AbstractJobNode;
import eu.dnetlib.workflow.BlackboardWorkflowJobListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Required;

public abstract class BlackboardJobNode
extends AbstractJobNode {
    private static final Log log = LogFactory.getLog(BlackboardJobNode.class);
    private BlackboardClientHandler blackboardHandler;
    private BlackboardJobRegistry jobRegistry;

    public void execute(Engine engine, NodeToken token) {
        log.info((Object)"executing blackboard node");
        try {
            token.getEnv().setAttribute("isBlackboard", (Object)true);
            String serviceId = this.locateService(token);
            if (serviceId == null) {
                token.getEnv().setAttribute("hasFailed", (Object)true);
                token.getEnv().setAttribute("errorMessage", "cannot locate target service profile");
                engine.complete(token, "failed");
                return;
            }
            BlackboardJob job = this.blackboardHandler.newJob(serviceId);
            token.getEnv().setTransientAttribute("blackboardJob", (Object)job);
            token.getEnv().setAttribute("blackboardServiceId", ((BlackboardJobImpl)job).getServiceId());
            this.prepareJob(job, token);
            AbstractBlackboardWorkflowJobListener listener = this.createJobListener(engine, token);
            this.jobRegistry.registerJobListener(job, (BlackboardJobListener)listener);
            this.blackboardHandler.assign(job);
        }
        catch (RuntimeException e) {
            token.getEnv().setAttribute("hasFailed", (Object)true);
            token.getEnv().setAttribute("errorMessage", "cannot prepare blackboard job: " + e);
            engine.complete(token, "failed");
            log.warn((Object)"cannot prepare blackboard job", (Throwable)e);
        }
    }

    protected AbstractBlackboardWorkflowJobListener createJobListener(Engine engine, NodeToken token) {
        return new BlackboardWorkflowJobListener(engine, token, this.getAttributePrefix());
    }

    protected String getAttributePrefix() {
        return "";
    }

    protected String locateService() {
        return null;
    }

    protected String locateService(NodeToken token) {
        return this.locateService();
    }

    protected void prepareJob(BlackboardJob job, NodeToken token) {
    }

    public BlackboardClientHandler getBlackboardHandler() {
        return this.blackboardHandler;
    }

    @Required
    public void setBlackboardHandler(BlackboardClientHandler blackboardHandler) {
        this.blackboardHandler = blackboardHandler;
    }

    public BlackboardJobRegistry getJobRegistry() {
        return this.jobRegistry;
    }

    @Required
    public void setJobRegistry(BlackboardJobRegistry jobRegistry) {
        this.jobRegistry = jobRegistry;
    }
}

