/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.workflow;

import com.googlecode.sarasvati.Engine;
import com.googlecode.sarasvati.Node;
import com.googlecode.sarasvati.NodeToken;
import com.googlecode.sarasvati.mem.MemNode;
import eu.dnetlib.enabling.inspector.msro.progress.ProgressProvider;
import eu.dnetlib.miscutils.datetime.DateUtils;
import java.util.Date;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class AbstractJobNode
extends MemNode {
    private static final Log log = LogFactory.getLog(AbstractJobNode.class);
    private ProgressProvider progressProvider;
    private String description;
    private String extraDescription;

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public <T> T getAdaptor(Class<T> clazz) {
        if (clazz == String.class) {
            if (this.getDescription() == null) {
                return (T)this.getName();
            }
            return (T)this.getDescription();
        }
        return (T)super.getAdaptor(clazz);
    }

    protected void failed(Engine engine, NodeToken token, Throwable exception) {
        log.fatal((Object)"got exception while executing workflow node", exception);
        token.getEnv().setAttribute("hasFailed", (Object)true);
        token.getEnv().setAttribute("errorMessage", exception.getMessage());
        engine.complete(token, "failed");
    }

    public String getExtraDescription() {
        return this.extraDescription;
    }

    public void setExtraDescription(String extraDescription) {
        this.extraDescription = extraDescription;
    }

    public String getProgressDescription(NodeToken token) {
        int totValue;
        if (this.progressProvider == null) {
            return null;
        }
        String totS = "???";
        String percentS = "";
        int currValue = this.progressProvider.getCurrentValue((Node)this, token);
        if (currValue <= (totValue = this.progressProvider.getTotalValue((Node)this, token))) {
            totS = "" + totValue;
            if (totValue > 0) {
                percentS = " (" + Math.round(currValue * 100 / totValue) + "%)";
            }
        }
        return "Progress: " + currValue + "/" + totS + percentS + " RPS: " + this.rps(currValue, token.getCreateDate()) + " ETA: " + this.eta(currValue, totValue, token.getCreateDate());
    }

    private String rps(int currValue, Date createDate) {
        if (createDate == null) {
            return "??";
        }
        long delta = (DateUtils.now() - createDate.getTime()) / 1000L;
        if (delta == 0L) {
            return "??";
        }
        return "" + (long)currValue / delta;
    }

    private String eta(int currValue, int totValue, Date createDate) {
        if (createDate == null) {
            return "??";
        }
        long delta = (DateUtils.now() - createDate.getTime()) / 1000L;
        if (currValue == 0) {
            return "??";
        }
        return this.formatElapsed((long)(totValue - currValue) * delta / (long)currValue);
    }

    private String formatElapsed(long delta) {
        long hours = delta / 3600L;
        long minutes = delta % 3600L / 60L;
        long seconds = delta % 3600L % 60L;
        String elapsed = "";
        if (hours < 10L) {
            elapsed = elapsed + "0";
        }
        elapsed = elapsed + hours + ":";
        if (minutes < 10L) {
            elapsed = elapsed + "0";
        }
        elapsed = elapsed + minutes + ":";
        if (seconds < 10L) {
            elapsed = elapsed + "0";
        }
        elapsed = elapsed + seconds;
        return elapsed;
    }

    public void setProgressProvider(ProgressProvider progressProvider) {
        this.progressProvider = progressProvider;
    }

    public ProgressProvider getProgressProvider() {
        return this.progressProvider;
    }
}

