/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.workflow;

import com.googlecode.sarasvati.Arc;
import com.googlecode.sarasvati.Engine;
import com.googlecode.sarasvati.NodeToken;
import com.googlecode.sarasvati.env.Env;
import eu.dnetlib.enabling.tools.blackboard.AbstractBlackboardJobListener;
import eu.dnetlib.enabling.tools.blackboard.BlackboardJob;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class AbstractBlackboardWorkflowJobListener
extends AbstractBlackboardJobListener {
    private static final Log log = LogFactory.getLog(AbstractBlackboardWorkflowJobListener.class);
    private Engine engine;
    private NodeToken token;
    private String envPrefix;

    public AbstractBlackboardWorkflowJobListener(Engine engine, NodeToken token) {
        this(engine, token, "");
    }

    public AbstractBlackboardWorkflowJobListener(Engine engine, NodeToken token, String envPrefix) {
        this.engine = engine;
        this.token = token;
        this.envPrefix = envPrefix;
    }

    public void processJob(BlackboardJob job) {
        this.token.getEnv().setTransientAttribute("blackboardJob", (Object)job);
        super.processJob(job);
    }

    protected void onDone(BlackboardJob job) {
        log.debug((Object)"Blackboard workflow node DONE");
    }

    protected void onFailed(BlackboardJob job) {
        log.warn((Object)("Blackboard workflow node FAILED: " + job.getError()));
        this.token.getEnv().setAttribute("hasFailed", (Object)true);
        this.token.getEnv().setAttribute("errorMessage", job.getError());
    }

    protected void complete(BlackboardJob job) {
        this.complete(job, Arc.DEFAULT_ARC);
    }

    protected void complete(BlackboardJob job, String arc) {
        this.mergeParameters(job);
        this.engine.complete(this.token, arc);
        this.engine.executeQueuedArcTokens(this.token.getProcess());
    }

    protected void onOngoing(BlackboardJob job) {
        this.token.getEnv().setAttribute("isOngoing", (Object)true);
    }

    protected void mergeParameters(BlackboardJob job) {
        Env env = this.token.getEnv();
        String prefix = "";
        if (this.envPrefix != null && !this.getEnvPrefix().isEmpty()) {
            prefix = this.envPrefix + "_";
        }
        for (Map.Entry entry : job.getParameters().entrySet()) {
            env.setAttribute(prefix + (String)entry.getKey(), (String)entry.getValue());
        }
    }

    public Engine getEngine() {
        return this.engine;
    }

    public void setEngine(Engine engine) {
        this.engine = engine;
    }

    public NodeToken getToken() {
        return this.token;
    }

    public void setToken(NodeToken token) {
        this.token = token;
    }

    public String getEnvPrefix() {
        return this.envPrefix;
    }

    public void setEnvPrefix(String envPrefix) {
        this.envPrefix = envPrefix;
    }
}

