/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.enabling.manager.msro.wf;

import com.googlecode.sarasvati.Arc;
import com.googlecode.sarasvati.Engine;
import com.googlecode.sarasvati.NodeToken;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpDocumentNotFoundException;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpException;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpService;
import eu.dnetlib.enabling.is.registry.rmi.ISRegistryException;
import eu.dnetlib.enabling.is.registry.rmi.ISRegistryService;
import eu.dnetlib.enabling.tools.ServiceLocator;
import eu.dnetlib.workflow.AbstractJobNode;
import org.springframework.beans.factory.annotation.Required;

public class UpdateRepositorySizeJob
extends AbstractJobNode {
    private ServiceLocator<ISLookUpService> lookupLocator;
    private ServiceLocator<ISRegistryService> registryLocator;

    public void execute(Engine engine, NodeToken token) {
        String mdId = token.getFullEnv().getAttribute("mdId");
        String query = "//RESOURCE_PROFILE[.//MDSTORE_DS_IDENTIFIER='" + mdId + "' or contains(.//DATA_SINK, '" + mdId + "')]//REPOSITORY_SERVICE_IDENTIFIER/text()";
        try {
            String idxId = token.getEnv().getAttribute("id");
            String repId = ((ISLookUpService)this.lookupLocator.getService()).getResourceProfileByQuery(query);
            String update = "for $x in //RESOURCE_PROFILE[.//RESOURCE_IDENTIFIER/@value='" + repId + "']" + " return update value $x//STATUS/NUMBER_OF_OBJECTS with collection('')//RESOURCE_PROFILE[.//RESOURCE_IDENTIFIER/@value='" + idxId + "']//INDEX_SIZE/text()";
            ((ISRegistryService)this.registryLocator.getService()).executeXUpdate(update);
            String size = ((ISLookUpService)this.lookupLocator.getService()).getResourceProfileByQuery("//RESOURCE_PROFILE[.//RESOURCE_IDENTIFIER/@value='" + repId + "']//NUMBER_OF_OBJECTS/text()");
            token.getEnv().setAttribute("size", size);
            engine.complete(token, Arc.DEFAULT_ARC);
        }
        catch (ISLookUpDocumentNotFoundException e) {
            this.failed(engine, token, e);
        }
        catch (ISLookUpException e) {
            this.failed(engine, token, e);
        }
        catch (ISRegistryException e) {
            this.failed(engine, token, e);
        }
    }

    public ServiceLocator<ISLookUpService> getLookupLocator() {
        return this.lookupLocator;
    }

    @Required
    public void setLookupLocator(ServiceLocator<ISLookUpService> lookupLocator) {
        this.lookupLocator = lookupLocator;
    }

    public ServiceLocator<ISRegistryService> getRegistryLocator() {
        return this.registryLocator;
    }

    @Required
    public void setRegistryLocator(ServiceLocator<ISRegistryService> registryLocator) {
        this.registryLocator = registryLocator;
    }
}

