/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.enabling.manager.msro.wf;

import com.googlecode.sarasvati.env.Env;
import eu.dnetlib.enabling.manager.msro.wf.AbstractDataDSJobNode;
import org.antlr.stringtemplate.StringTemplate;

public class TDSJobNode
extends AbstractDataDSJobNode {
    private String inputFormat = "oai_dc";
    private String outputFormat = "DMF";
    private String inputInterpretation = "driver";
    private String outputInterpretation = "driver";
    private String sinkType = "REFRESH";
    private String inputFormatAttributeName;
    private String outputFormatAttributeName;

    @Override
    protected String getDSType() {
        return "tds";
    }

    @Override
    protected void prepareParameters(StringTemplate template, Env env) {
        this.readInputFormatFromEnv(env);
        this.readOutputFormatFromEnv(env);
        template.setAttribute("input_mdFormat", (Object)this.inputFormat);
        template.setAttribute("output_mdFormat", (Object)this.outputFormat);
        template.setAttribute("input_interpretation", (Object)this.inputInterpretation);
        template.setAttribute("output_interpretation", (Object)this.outputInterpretation);
        template.setAttribute("sink_type", (Object)this.sinkType);
        template.setAttribute("input_mdstore_id", (Object)env.getAttribute(this.inputFormat + "_" + this.inputInterpretation + "_id"));
        template.setAttribute("output_mdstore_id", (Object)env.getAttribute(this.outputFormat + "_" + this.outputInterpretation + "_id"));
    }

    private void readInputFormatFromEnv(Env env) {
        String inputF = env.getAttribute(this.inputFormatAttributeName);
        if (inputF != null) {
            this.inputFormat = inputF;
        }
    }

    private void readOutputFormatFromEnv(Env env) {
        String outF = env.getAttribute(this.outputFormatAttributeName);
        if (outF != null) {
            this.outputFormat = outF;
        }
    }

    public String getInputFormat() {
        return this.inputFormat;
    }

    public void setInputFormat(String inputFormat) {
        this.inputFormat = inputFormat;
    }

    public String getOutputFormat() {
        return this.outputFormat;
    }

    public void setOutputFormat(String outputFormat) {
        this.outputFormat = outputFormat;
    }

    public String getInputInterpretation() {
        return this.inputInterpretation;
    }

    public void setInputInterpretation(String inputInterpretation) {
        this.inputInterpretation = inputInterpretation;
    }

    public String getOutputInterpretation() {
        return this.outputInterpretation;
    }

    public void setOutputInterpretation(String outputInterpretation) {
        this.outputInterpretation = outputInterpretation;
    }

    public String getSinkType() {
        return this.sinkType;
    }

    public void setSinkType(String sinkType) {
        this.sinkType = sinkType;
    }

    public void setInputFormatAttributeName(String inputFormatAttributeName) {
        this.inputFormatAttributeName = inputFormatAttributeName;
    }

    public String getInputFormatAttributeName() {
        return this.inputFormatAttributeName;
    }

    public String getOutputFormatAttributeName() {
        return this.outputFormatAttributeName;
    }

    public void setOutputFormatAttributeName(String outputFormatAttributeName) {
        this.outputFormatAttributeName = outputFormatAttributeName;
    }
}

